/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.AddAllBackupOperation;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddAllOperation
extends CollectionBackupAwareOperation {
    List<Data> dataList;
    transient Collection<CollectionRecord> recordList;
    int index = -1;

    public AddAllOperation() {
    }

    public AddAllOperation(CollectionProxyId proxyId, Data dataKey, int threadId, List<Data> dataList, int index) {
        super(proxyId, dataKey, threadId);
        this.dataList = dataList;
        this.index = index;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        Collection<CollectionRecord> coll = container.getOrCreateCollectionWrapper(this.dataKey).getCollection();
        this.recordList = new ArrayList<CollectionRecord>(this.dataList.size());
        try {
            int i = 0;
            for (Data data : this.dataList) {
                CollectionRecord record = new CollectionRecord(this.isBinary() ? data : this.toObject(data));
                boolean added = true;
                if (this.index == -1) {
                    added = coll.add(record);
                } else {
                    List list = (List)coll;
                    list.add(this.index + i++, record);
                }
                if (!added) continue;
                record.setRecordId(container.nextId());
                this.recordList.add(record);
            }
            this.response = this.recordList.size() != 0;
        }
        catch (IndexOutOfBoundsException e) {
            this.response = e;
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new AddAllBackupOperation(this.proxyId, this.dataKey, this.recordList, this.index);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
        out.writeInt(this.dataList.size());
        for (Data data : this.dataList) {
            data.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
        int size = in.readInt();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = IOUtil.readData(in);
            this.dataList.add(data);
        }
    }

    @Override
    public int getId() {
        return 1;
    }
}

