/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HazelcastClusterMessageListener
implements MessageListener<ClusteringMessage> {
    private static final Log log = LogFactory.getLog(HazelcastClusterMessageListener.class);
    private ConfigurationContext configurationContext;
    private final Map<String, Long> recdMsgsBuffer;
    private final List<ClusteringMessage> sentMsgsBuffer;

    public HazelcastClusterMessageListener(ConfigurationContext configurationContext, Map<String, Long> recdMsgsBuffer, List<ClusteringMessage> sentMsgsBuffer) {
        this.configurationContext = configurationContext;
        this.recdMsgsBuffer = recdMsgsBuffer;
        this.sentMsgsBuffer = sentMsgsBuffer;
    }

    public void onMessage(Message<ClusteringMessage> clusteringMessage) {
        try {
            ClusteringMessage msg = (ClusteringMessage)clusteringMessage.getMessageObject();
            if (!this.sentMsgsBuffer.contains(msg)) {
                log.info((Object)("Received ClusteringMessage: " + msg));
                msg.execute(this.configurationContext);
                this.recdMsgsBuffer.put(msg.getUuid(), System.currentTimeMillis());
            }
        }
        catch (ClusteringFault e) {
            log.error((Object)"Cannot process ClusteringMessage", (Throwable)e);
        }
    }
}

