/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.FieldInstruction;
import serp.bytecode.visitor.BCVisitor;

public class PutFieldInstruction
extends FieldInstruction {
    PutFieldInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int getLogicalStackChange() {
        if (this.getFieldTypeName() == null) {
            return 0;
        }
        if (this.getOpcode() == 179) {
            return -1;
        }
        return -2;
    }

    public int getStackChange() {
        String type = this.getFieldTypeName();
        if (type == null) {
            return 0;
        }
        int stack = -2;
        if (Long.TYPE.getName().equals(type) || Double.TYPE.getName().equals(type)) {
            ++stack;
        }
        if (this.getOpcode() == 179) {
            ++stack;
        }
        return stack;
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterPutFieldInstruction(this);
        visit.exitPutFieldInstruction(this);
    }
}

