/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnlinkIdentityRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityId;
    private Map<String, String> logins;
    private ListWithAutoConstructFlag<String> loginsToRemove;

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public UnlinkIdentityRequest withIdentityId(String identityId) {
        this.identityId = identityId;
        return this;
    }

    public Map<String, String> getLogins() {
        return this.logins;
    }

    public void setLogins(Map<String, String> logins) {
        this.logins = logins;
    }

    public UnlinkIdentityRequest withLogins(Map<String, String> logins) {
        this.setLogins(logins);
        return this;
    }

    public UnlinkIdentityRequest addLoginsEntry(String key, String value) {
        if (null == this.logins) {
            this.logins = new HashMap<String, String>();
        }
        if (this.logins.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.logins.put(key, value);
        return this;
    }

    public UnlinkIdentityRequest clearLoginsEntries() {
        this.logins = null;
        return this;
    }

    public List<String> getLoginsToRemove() {
        return this.loginsToRemove;
    }

    public void setLoginsToRemove(Collection<String> loginsToRemove) {
        if (loginsToRemove == null) {
            this.loginsToRemove = null;
            return;
        }
        ListWithAutoConstructFlag loginsToRemoveCopy = new ListWithAutoConstructFlag(loginsToRemove.size());
        loginsToRemoveCopy.addAll(loginsToRemove);
        this.loginsToRemove = loginsToRemoveCopy;
    }

    public UnlinkIdentityRequest withLoginsToRemove(String ... loginsToRemove) {
        if (this.getLoginsToRemove() == null) {
            this.setLoginsToRemove(new ArrayList<String>(loginsToRemove.length));
        }
        for (String value : loginsToRemove) {
            this.getLoginsToRemove().add(value);
        }
        return this;
    }

    public UnlinkIdentityRequest withLoginsToRemove(Collection<String> loginsToRemove) {
        if (loginsToRemove == null) {
            this.loginsToRemove = null;
        } else {
            ListWithAutoConstructFlag loginsToRemoveCopy = new ListWithAutoConstructFlag(loginsToRemove.size());
            loginsToRemoveCopy.addAll(loginsToRemove);
            this.loginsToRemove = loginsToRemoveCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityId() != null) {
            sb.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getLogins() != null) {
            sb.append("Logins: " + this.getLogins() + ",");
        }
        if (this.getLoginsToRemove() != null) {
            sb.append("LoginsToRemove: " + this.getLoginsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        hashCode = 31 * hashCode + (this.getLogins() == null ? 0 : this.getLogins().hashCode());
        hashCode = 31 * hashCode + (this.getLoginsToRemove() == null ? 0 : this.getLoginsToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkIdentityRequest)) {
            return false;
        }
        UnlinkIdentityRequest other = (UnlinkIdentityRequest)obj;
        if (other.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (other.getIdentityId() != null && !other.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (other.getLogins() == null ^ this.getLogins() == null) {
            return false;
        }
        if (other.getLogins() != null && !other.getLogins().equals(this.getLogins())) {
            return false;
        }
        if (other.getLoginsToRemove() == null ^ this.getLoginsToRemove() == null) {
            return false;
        }
        return other.getLoginsToRemove() == null || other.getLoginsToRemove().equals(this.getLoginsToRemove());
    }
}

