/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.JobStatus;
import org.apache.airavata.registry.core.experiment.catalog.model.JobStatusPK;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusResource.class);
    private String statusId;
    private String jobId;
    private String taskId;
    private String state;
    private Timestamp timeOfStateChange;
    private String reason;

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Timestamp getTimeOfStateChange() {
        return this.timeOfStateChange;
    }

    public void setTimeOfStateChange(Timestamp timeOfStateChange) {
        this.timeOfStateChange = timeOfStateChange;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for task status data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for task status data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for task status data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for task status data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            if (this.jobId == null || this.statusId == null || this.taskId == null) {
                throw new RegistryException("Does not have the job id or status id or task id");
            }
            em = ExpCatResourceUtils.getEntityManager();
            JobStatusPK jobStatusPK = new JobStatusPK();
            jobStatusPK.setJobId(this.jobId);
            jobStatusPK.setStatusId(this.statusId);
            jobStatusPK.setTaskId(this.taskId);
            JobStatus existingJobStatus = (JobStatus)em.find(JobStatus.class, (Object)jobStatusPK);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            JobStatus jobStatus = existingJobStatus == null ? new JobStatus() : existingJobStatus;
            jobStatus.setStatusId(this.statusId);
            jobStatus.setJobId(this.jobId);
            jobStatus.setTaskId(this.taskId);
            jobStatus.setState(this.state);
            jobStatus.setReason(this.reason);
            if (this.timeOfStateChange == null) {
                this.timeOfStateChange = AiravataUtils.getCurrentTimestamp();
            }
            jobStatus.setTimeOfStateChange(this.timeOfStateChange);
            if (existingJobStatus == null) {
                em.persist((Object)jobStatus);
            } else {
                em.merge((Object)jobStatus);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

