/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.GridftpDataMovement;
import org.apache.airavata.registry.core.app.catalog.model.GridftpEndpoint;
import org.apache.airavata.registry.core.app.catalog.model.GridftpEndpoint_PK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.GridftpDataMovementResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridftpEndpointResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GridftpEndpointResource.class);
    private String endpoint;
    private String dataMovementInterfaceId;
    private GridftpDataMovementResource gridftpDataMovementResource;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpEndpoint", new Object[0][]);
            generator.setParameter("endpoint", ids.get("endpoint"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpEndpoint", new Object[0][]);
            generator.setParameter("endpoint", ids.get("endpoint"));
            generator.setParameter("dataMovementInterfaceId", ids.get("dataMovementInterfaceId"));
            Query q = generator.selectQuery(em);
            GridftpEndpoint gridftpEndpoint = (GridftpEndpoint)q.getSingleResult();
            GridftpEndpointResource gridftpEndpointResource = (GridftpEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_ENDPOINT, gridftpEndpoint);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            GridftpEndpointResource gridftpEndpointResource2 = gridftpEndpointResource;
            return gridftpEndpointResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> gridftpEndpointResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpEndpoint", new Object[0][]);
            if (fieldName.equals("endpoint") || fieldName.equals("dataMovementInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    GridftpEndpoint gridftpEndpoint = (GridftpEndpoint)result;
                    GridftpEndpointResource gridftpEndpointResource = (GridftpEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_ENDPOINT, gridftpEndpoint);
                    gridftpEndpointResources.add(gridftpEndpointResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Gridftp Endpoint Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Gridftp Endpoint Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gridftpEndpointResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> gridftpEndpointResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("GridftpEndpoint", new Object[0][]);
            if (fieldName.equals("endpoint") || fieldName.equals("dataMovementInterfaceId")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    GridftpEndpoint gridftpEndpoint = (GridftpEndpoint)result;
                    GridftpEndpointResource gridftpEndpointResource = (GridftpEndpointResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.GRIDFTP_ENDPOINT, gridftpEndpoint);
                    gridftpEndpointResourceIDs.add(gridftpEndpointResource.getDataMovementInterfaceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Gridftp Endpoint Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Gridftp Endpoint Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return gridftpEndpointResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            GridftpEndpoint gridftpEndpoint;
            em = AppCatalogJPAUtils.getEntityManager();
            GridftpEndpoint existingGridftpEndpoint = (GridftpEndpoint)em.find(GridftpEndpoint.class, (Object)new GridftpEndpoint_PK(this.endpoint, this.dataMovementInterfaceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingGridftpEndpoint == null) {
                gridftpEndpoint = new GridftpEndpoint();
                gridftpEndpoint.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                gridftpEndpoint = existingGridftpEndpoint;
                gridftpEndpoint.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            gridftpEndpoint.setEndpoint(this.getEndpoint());
            gridftpEndpoint.setDataMovementInterfaceId(this.getDataMovementInterfaceId());
            GridftpDataMovement gridftpDataMovement = (GridftpDataMovement)em.find(GridftpDataMovement.class, (Object)this.getDataMovementInterfaceId());
            gridftpEndpoint.setGridftpDataMovement(gridftpDataMovement);
            if (existingGridftpEndpoint == null) {
                em.persist((Object)gridftpEndpoint);
            } else {
                em.merge((Object)gridftpEndpoint);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof Map)) {
            logger.error("Identifier should be a map with the field name and it's value");
            throw new AppCatalogException("Identifier should be a map with the field name and it's value");
        }
        HashMap ids = (HashMap)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            GridftpEndpoint gridftpEndpoint = (GridftpEndpoint)em.find(GridftpEndpoint.class, (Object)new GridftpEndpoint_PK((String)ids.get("endpoint"), (String)ids.get("dataMovementInterfaceId")));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = gridftpEndpoint != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public GridftpDataMovementResource getGridftpDataMovementResource() {
        return this.gridftpDataMovementResource;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void setGridftpDataMovementResource(GridftpDataMovementResource gridftpDataMovementResource) {
        this.gridftpDataMovementResource = gridftpDataMovementResource;
    }
}

