/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization.operation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.Message;
import org.wso2.carbon.registry.synchronization.message.MessageCode;

public class UpdateCommand {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static boolean ignoreConflicts = Boolean.parseBoolean(System.getProperty("carbon.registry.ignore.conflicts", "false"));
    private String registryUrl = null;
    private String outputFile = null;
    private String workingLocation = null;
    private String checkOutPath = null;
    private String username = null;
    private boolean cleanRegistry = false;
    private boolean isSilentUpdate = false;
    private int addedCount = 0;
    private int updatedCount = 0;
    private int conflictedCount = 0;
    private int deletedCount = 0;
    private int notDeletedCount = 0;
    private boolean updated = false;

    public UpdateCommand(String outputFile, String workingLocation, String userUrl, boolean isSilentUpdate, String username, boolean cleanRegistry) throws SynchronizationException {
        this.outputFile = outputFile;
        this.workingLocation = workingLocation;
        this.isSilentUpdate = isSilentUpdate;
        this.username = username;
        this.cleanRegistry = cleanRegistry;
        if (userUrl != null) {
            this.registryUrl = Utils.getRegistryUrl(userUrl);
            this.checkOutPath = Utils.getPath(userUrl);
            if (this.checkOutPath == null || this.checkOutPath.equals("")) {
                this.checkOutPath = "/";
            }
        } else {
            OMElement metaOMElement = Utils.getMetaOMElement(workingLocation);
            if (metaOMElement == null) {
                throw new SynchronizationException(MessageCode.CHECKOUT_BEFORE_UPDATE);
            }
            this.registryUrl = metaOMElement.getAttributeValue(new QName("registryUrl"));
            this.checkOutPath = metaOMElement.getAttributeValue(new QName("path"));
        }
    }

    public int getAddedCount() {
        return this.addedCount;
    }

    public int getUpdatedCount() {
        return this.updatedCount;
    }

    public int getConflictedCount() {
        return this.conflictedCount;
    }

    public int getDeletedCount() {
        return this.deletedCount;
    }

    public int getNotDeletedCount() {
        return this.notDeletedCount;
    }

    public void setSilentUpdate(boolean silentUpdate) {
        this.isSilentUpdate = silentUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Registry registry, UserInputCallback callback) throws SynchronizationException {
        boolean deleteTempFileFailed;
        File tempFile;
        block29: {
            if (this.outputFile != null) {
                throw new SynchronizationException(MessageCode.OUTPUT_FILE_NOT_SUPPORTED);
            }
            tempFile = null;
            deleteTempFileFailed = false;
            FileWriter writer = null;
            try {
                try {
                    tempFile = File.createTempFile("dump", ".xml");
                    try {
                        writer = new FileWriter(tempFile);
                        registry.dump(this.checkOutPath, writer);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (RegistryException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING_NO_RESOURCE_OR_NO_PERMISSION, (Throwable)((Object)e), new String[]{"path: " + this.checkOutPath, "username: " + this.username, "registry url: " + this.registryUrl});
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_CREATING_TEMP_FILE_FOR_DUMP);
                }
                XMLStreamReader xmlReader = null;
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(tempFile);
                        xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                        this.updateRecursively(xmlReader, this.workingLocation, this.checkOutPath, callback);
                    }
                    finally {
                        try {
                            if (xmlReader != null) {
                                xmlReader.close();
                            }
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_READING_TEMP_FILE_OF_DUMP);
                }
                catch (XMLStreamException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_READING_STREAM_OF_TEMP_FILE_OF_DUMP);
                }
                if (tempFile == null) break block29;
            }
            catch (Throwable throwable) {
                if (tempFile != null) {
                    deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
                }
                throw throwable;
            }
            boolean bl = deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
        }
        if (deleteTempFileFailed) {
            throw new SynchronizationException(MessageCode.ERROR_IN_CLEANING_UP, new String[]{"file path: " + tempFile.getAbsolutePath()});
        }
        if (this.cleanRegistry && this.registryUrl == null) {
            Utils.cleanEmbeddedRegistry();
        }
        return this.updated;
    }

    public boolean execute(Registry registry) throws SynchronizationException {
        return this.execute(registry, null);
    }

    /*
     * Unable to fully structure code
     */
    private void updateRecursively(XMLStreamReader xmlReader, String filePath, String path, UserInputCallback callback) throws SynchronizationException, XMLStreamException {
        root = Utils.readMetaElement(xmlReader);
        root.addAttribute("path", path, null);
        if (this.registryUrl != null) {
            root.addAttribute("registryUrl", this.registryUrl, null);
        }
        isCollectionString = root.getAttributeValue(new QName("isCollection"));
        isCollection = isCollectionString.equals("true");
        name = root.getAttributeValue(new QName("name"));
        contentBytes = new byte[]{};
        file = new File(filePath);
        isUpdating = false;
        isConflicting = false;
        collectionIsNotUpdated = false;
        updatingMD5 = null;
        children = root.getChildren();
        while (children.hasNext()) {
            child = (OMElement)children.next();
            localName = child.getLocalName();
            if (!localName.equals("content")) continue;
            text = (OMText)child.getFirstOMChild();
            if (text != null) {
                contentBytes = Base64.decode((String)text.getText());
            }
            updatingMD5 = Utils.getMD5(contentBytes);
            root.addAttribute("md5", updatingMD5, null);
            child.detach();
        }
        if (isCollection) {
            metaFilePath = filePath + File.separator + ".meta" + File.separator + "~" + ".xml";
        } else {
            parentDirName = file.getAbsoluteFile().getParent();
            metaFilePath = parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(name) + ".xml";
        }
        metaFile = new File(metaFilePath);
        if (file.exists()) {
            isUpdating = true;
            if (isCollection != file.isDirectory()) {
                throw new SynchronizationException(MessageCode.COLLECTION_AND_RESOURCE_SAME_NAME, new String[]{"file name: " + filePath});
            }
            if (metaFile.exists()) {
                updatingVersionElement = root.getFirstChildWithName(new QName("version"));
                if (updatingVersionElement == null) {
                    throw new SynchronizationException(MessageCode.CHECKOUT_OLD_VERSION, new String[]{"missing element: version", "path: " + path});
                }
                updatingVersionStr = updatingVersionElement.getText();
                metaFileElement = Utils.getOMElementFromMetaFile(metaFilePath);
                metaFileVersionElement = metaFileElement.getFirstChildWithName(new QName("version"));
                if (metaFileVersionElement == null) {
                    metaFileVersionStr = updatingVersionStr;
                    root.addAttribute("version", metaFileVersionStr, null);
                    Utils.createMetaFile(metaFilePath, root);
                } else {
                    metaFileVersionStr = metaFileVersionElement.getText();
                }
                if (isCollection) {
                    if (metaFileVersionStr.equals(updatingVersionStr)) {
                        Utils.createMetaFile(metaFilePath, root);
                        collectionIsNotUpdated = true;
                    }
                } else {
                    currentFileContent = Utils.getBytesFromFile(file);
                    metaFileMD5 = metaFileElement.getAttributeValue(new QName("md5"));
                    currentMD5 = Utils.getMD5(currentFileContent);
                    if (metaFileMD5 != null && metaFileMD5.equals(currentMD5)) {
                        if (metaFileVersionStr.equals(updatingVersionStr)) {
                            Utils.createMetaFile(metaFilePath, root);
                            return;
                        }
                    } else {
                        if (metaFileVersionStr.equals(updatingVersionStr)) {
                            Utils.createMetaFile(metaFilePath, root);
                            return;
                        }
                        if (updatingMD5 != null && !updatingMD5.equals(currentMD5)) {
                            isConflicting = true;
                            root.addAttribute("md5", "", null);
                        }
                    }
                }
            } else if (!isCollection) {
                isConflicting = true;
            }
            if (isConflicting && !this.isSilentUpdate && !UpdateCommand.ignoreConflicts) {
                mineFileName = filePath + ".mine";
                mineFile = new File(mineFileName);
                Utils.copy(file, mineFile);
                versionedFileName = filePath + ".server";
                file = new File(versionedFileName);
                root.addAttribute("conflicting", "true", null);
            }
        } else {
            if (this.isSilentUpdate) {
                return;
            }
            if (metaFile.exists() && (callback == null || callback.getConfirmation(new Message(MessageCode.KEEP_DELETED_FILE, new String[]{filePath}), "delete"))) {
                return;
            }
        }
        if (!isUpdating) {
            try {
                ignore = isCollection ? file.mkdir() : file.createNewFile();
            }
            catch (IOException e) {
                throw new SynchronizationException(MessageCode.FILE_CREATION_FAILED, e, new String[]{"file name: " + filePath});
            }
        }
        if (!isCollection) {
            fileOutputStream = null;
            try {
                writeToFile = true;
                if (file.exists() && (currentContentBytes = Utils.getBytesFromFile(file)) != null && contentBytes != null) {
                    currentContentMd5 = Utils.getMD5(currentContentBytes);
                    writingContentMd5 = Utils.getMD5(contentBytes);
                    if (writingContentMd5 != null && writingContentMd5.equals(currentContentMd5)) {
                        writeToFile = false;
                    }
                }
                if (!writeToFile) ** GOTO lbl125
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(contentBytes);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new SynchronizationException(MessageCode.PROBLEM_IN_CREATING_CONTENT, e, new String[]{"file name: " + filePath});
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e) {
                    UpdateCommand.log.error((Object)"Failed to close the stream", (Throwable)e);
                }
            }
        } else {
            metaDirectoryName = filePath + File.separator + ".meta";
            metaDirectory = new File(metaDirectoryName);
            if (!metaDirectory.exists() && !metaDirectory.mkdir()) {
                throw new SynchronizationException(MessageCode.ERROR_CREATING_META_FILE, new String[]{"file: " + metaDirectoryName});
            }
        }
lbl125:
        // 4 sources

        iterateChildren = true;
        if (!(xmlReader.hasNext() && xmlReader.isStartElement() && xmlReader.getLocalName().equals("children"))) {
            while (!(!xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("resource"))) {
                xmlReader.next();
            }
            iterateChildren = false;
        }
        if (iterateChildren) {
            do {
                xmlReader.next();
                if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("children")) continue;
                if (xmlReader.hasNext()) {
                    do {
                        xmlReader.next();
                    } while (xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("resource")));
                }
                iterateChildren = false;
                break;
            } while (!xmlReader.isStartElement() && xmlReader.hasNext());
        }
        childNames = new HashMap<String, Boolean>();
        if (iterateChildren) {
            while (xmlReader.hasNext() && xmlReader.isStartElement() && xmlReader.getLocalName().equals("resource")) {
                fileResourceName = childName = xmlReader.getAttributeValue(null, "name");
                childFilePath = filePath + File.separator + fileResourceName;
                childPath = (path.equals("/") != false ? "" : path) + "/" + childName;
                this.updateRecursively(xmlReader, childFilePath, childPath, callback);
                childNames.put(fileResourceName, true);
                while (!(xmlReader.isStartElement() || !xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("children"))) {
                    xmlReader.next();
                }
                if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("children")) continue;
                break;
            }
            while (!(!xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("resource"))) {
                xmlReader.next();
            }
            childFileNames = file.list();
            if (childFileNames != null) {
                for (String childFileName : childFileNames) {
                    if (childFileName.equals(".meta") || childNames.get(childFileName) != null && ((Boolean)childNames.get(childFileName)).booleanValue()) continue;
                    childFilePath = file + File.separator + childFileName;
                    childFile = new File(file, childFileName);
                    shouldDelete = false;
                    if (childFile.isDirectory()) {
                        metaDirName = filePath + File.separator + childFileName + File.separator + ".meta" + File.separator + File.separator + "~" + ".xml";
                        childMetaFile = new File(metaDirName);
                        if (childMetaFile.exists()) {
                            shouldDelete = true;
                        }
                    } else {
                        metaFileName = filePath + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(childFileName) + ".xml";
                        childMetaFile = new File(metaFileName);
                        if (childMetaFile.exists()) {
                            shouldDelete = true;
                        }
                    }
                    if (!shouldDelete || this.isSilentUpdate) continue;
                    this.deleteFile(callback, childFilePath, childFile, childMetaFile);
                }
            }
        } else {
            allFilesNames = file.list();
            if (allFilesNames != null) {
                for (String filesName : allFilesNames) {
                    childFilePath = filePath + File.separator + filesName;
                    childFile = new File(childFilePath);
                    if (childFile.isDirectory()) {
                        childMetaCollectionPath = childFilePath + File.separator + ".meta";
                        childMetaFile = new File(childMetaCollectionPath);
                        if (!childMetaFile.exists() || this.isSilentUpdate) continue;
                        this.deleteFile(callback, childFilePath, childFile, childMetaFile);
                        continue;
                    }
                    metaFileFullName = filePath + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(filesName) + ".xml";
                    childMetaFile = new File(metaFileFullName);
                    if (!childMetaFile.exists() || this.isSilentUpdate) continue;
                    this.deleteFile(callback, childFilePath, childFile, childMetaFile);
                }
            }
        }
        if (file.isDirectory() && collectionIsNotUpdated) {
            return;
        }
        if (isCollection) {
            metaFileName = filePath + File.separator + ".meta" + File.separator + "~" + ".xml";
        } else {
            parentDirName = file.getAbsoluteFile().getParent();
            metaFileName = parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(name) + ".xml";
        }
        Utils.createMetaFile(metaFileName, root);
        if (isConflicting) {
            if (callback != null && !this.isSilentUpdate) {
                callback.displayMessage(new Message(MessageCode.CONFLICTED, new String[]{UpdateCommand.refinedPathToPrint(filePath)}));
            }
            ++this.conflictedCount;
        } else if (isUpdating) {
            if (callback != null && !this.isSilentUpdate) {
                callback.displayMessage(new Message(MessageCode.UPDATED, new String[]{UpdateCommand.refinedPathToPrint(filePath)}));
            }
            ++this.updatedCount;
            this.updated = true;
        } else {
            if (callback != null && !this.isSilentUpdate) {
                callback.displayMessage(new Message(MessageCode.ADDED, new String[]{UpdateCommand.refinedPathToPrint(filePath)}));
            }
            ++this.addedCount;
            this.updated = true;
        }
    }

    private void deleteFile(UserInputCallback callback, String childFilePath, File childFile, File childMetaFile) throws SynchronizationException {
        boolean isDeleted = Utils.confirmDelete(childFile, childMetaFile, callback);
        if (isDeleted) {
            if (callback != null && !this.isSilentUpdate) {
                callback.displayMessage(new Message(MessageCode.DELETED, new String[]{UpdateCommand.refinedPathToPrint(childFilePath)}));
            }
            ++this.deletedCount;
            this.updated = true;
        } else {
            if (callback != null && !this.isSilentUpdate) {
                callback.displayMessage(new Message(MessageCode.NOT_DELETED, new String[]{UpdateCommand.refinedPathToPrint(childFilePath)}));
            }
            ++this.notDeletedCount;
        }
    }

    private static String refinedPathToPrint(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuilder refinedPath = new StringBuilder("");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) continue;
            refinedPath.append(token);
            if (!tokenizer.hasMoreElements()) continue;
            refinedPath.append("/");
        }
        return refinedPath.toString();
    }
}

