/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.synchronization.operation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.io.FileUtils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.synchronization.SynchronizationException;
import org.wso2.carbon.registry.synchronization.UserInputCallback;
import org.wso2.carbon.registry.synchronization.Utils;
import org.wso2.carbon.registry.synchronization.message.Message;
import org.wso2.carbon.registry.synchronization.message.MessageCode;

public class CheckOutCommand {
    private String outputFile = null;
    private String checkOutPath = null;
    private String registryUrl = null;
    private String workingDir = null;
    private String username = null;
    private boolean cleanRegistry = false;
    private int addedCount = -1;
    private int overwrittenCount = 0;
    private int nonOverwrittenCount = 0;

    public CheckOutCommand(String outputFile, String workingDir, String userUrl, String username, boolean cleanRegistry) throws SynchronizationException {
        this.outputFile = outputFile;
        this.workingDir = workingDir;
        this.username = username;
        this.cleanRegistry = cleanRegistry;
        if (userUrl == null) {
            throw new SynchronizationException(MessageCode.CO_PATH_MISSING);
        }
        this.registryUrl = Utils.getRegistryUrl(userUrl);
        this.checkOutPath = Utils.getPath(userUrl);
        if (this.checkOutPath == null || this.checkOutPath.equals("")) {
            this.checkOutPath = "/";
        }
    }

    public int getAddedCount() {
        return this.addedCount;
    }

    public int getOverwrittenCount() {
        return this.overwrittenCount;
    }

    public int getNonOverwrittenCount() {
        return this.nonOverwrittenCount;
    }

    public boolean execute(Registry registry, UserInputCallback callback) throws SynchronizationException {
        if (this.outputFile != null) {
            this.dumpToFile(registry);
        } else {
            this.dumpToFileSystem(registry, callback);
        }
        return true;
    }

    public boolean execute(Registry registry) throws SynchronizationException {
        return this.execute(registry, null);
    }

    private void dumpToFile(Registry registry) throws SynchronizationException {
        String outputXml = this.outputFile + ".xml";
        if (this.workingDir != null) {
            this.outputFile = this.workingDir + File.separator + this.outputFile;
        }
        try {
            if (!registry.resourceExists(this.checkOutPath)) {
                throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING_NO_RESOURCE_OR_NO_PERMISSION, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new SynchronizationException(MessageCode.ERROR_IN_CONNECTING_REGISTRY, e, new String[]{" registry url:" + this.registryUrl});
            }
            throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING_AUTHORIZATION_FAILED, e, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.outputFile));
            ZipEntry ze = new ZipEntry(outputXml);
            ze.setMethod(8);
            zos.putNextEntry(ze);
            OutputStreamWriter zipWriter = new OutputStreamWriter(zos);
            registry.dump(this.checkOutPath, zipWriter);
            zos.close();
        }
        catch (Exception e) {
            throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING, e, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
        }
        if (this.cleanRegistry && this.registryUrl == null) {
            Utils.cleanEmbeddedRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpToFileSystem(Registry registry, UserInputCallback callback) throws SynchronizationException {
        boolean deleteTempFileFailed;
        File tempFile;
        block31: {
            Resource r;
            this.addedCount = 0;
            try {
                r = registry.get(this.checkOutPath);
            }
            catch (Exception e) {
                throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING_NO_RESOURCE_OR_NO_PERMISSION, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
            }
            if (!(r instanceof Collection)) {
                throw new SynchronizationException(MessageCode.DUMPING_NON_COLLECTION, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
            }
            tempFile = null;
            deleteTempFileFailed = false;
            FileWriter writer = null;
            try {
                try {
                    tempFile = File.createTempFile("dump", ".xml");
                    try {
                        writer = new FileWriter(tempFile);
                        registry.dump(this.checkOutPath, writer);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (RegistryException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_DUMPING_NO_RESOURCE_OR_NO_PERMISSION, new String[]{"path: " + this.checkOutPath, "username: " + this.username});
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_CREATING_TEMP_FILE_FOR_DUMP, (Throwable)e);
                }
                XMLStreamReader xmlReader = null;
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(tempFile);
                        xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                        this.checkOutRecursively(xmlReader, this.workingDir, this.checkOutPath, callback);
                    }
                    finally {
                        try {
                            if (xmlReader != null) {
                                xmlReader.close();
                            }
                        }
                        finally {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_READING_TEMP_FILE_OF_DUMP, (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new SynchronizationException(MessageCode.ERROR_IN_READING_STREAM_OF_TEMP_FILE_OF_DUMP, (Throwable)e);
                }
                if (tempFile == null) break block31;
            }
            catch (Throwable throwable) {
                if (tempFile != null) {
                    deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
                }
                throw throwable;
            }
            boolean bl = deleteTempFileFailed = !FileUtils.deleteQuietly((File)tempFile);
        }
        if (deleteTempFileFailed) {
            throw new SynchronizationException(MessageCode.ERROR_IN_CLEANING_UP, new String[]{"file path: " + tempFile.getAbsolutePath()});
        }
        if (this.cleanRegistry && this.registryUrl == null) {
            Utils.cleanEmbeddedRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOutRecursively(XMLStreamReader xmlReader, String filePath, String path, UserInputCallback callback) throws SynchronizationException, XMLStreamException {
        File metaDirectory;
        String metaFilePath;
        String metaDirectoryName;
        OMElement root = Utils.readMetaElement(xmlReader);
        root.addAttribute("path", path, null);
        if (this.registryUrl != null) {
            root.addAttribute("registryUrl", this.registryUrl, null);
        }
        String isCollectionString = root.getAttributeValue(new QName("isCollection"));
        boolean isCollection = isCollectionString.equals("true");
        String name = root.getAttributeValue(new QName("name"));
        byte[] contentBytes = new byte[]{};
        File file = new File(filePath);
        boolean overwrite = true;
        boolean fileAlreadyExist = false;
        String parentDirName = file.getAbsoluteFile().getParent();
        if (isCollection) {
            metaDirectoryName = filePath + File.separator + ".meta";
            metaFilePath = filePath + File.separator + ".meta" + File.separator + "~" + ".xml";
        } else {
            metaDirectoryName = parentDirName + File.separator + ".meta";
            metaFilePath = parentDirName + File.separator + ".meta" + File.separator + "~" + Utils.encodeResourceName(name) + ".xml";
        }
        if (file.exists()) {
            fileAlreadyExist = true;
        }
        if (!isCollection && fileAlreadyExist && (!Utils.resourceUpdated(metaFilePath, root) || callback != null && !callback.getConfirmation(new Message(MessageCode.FILE_OVERWRITE_CONFIRMATION, new String[]{filePath}), "overwrite"))) {
            overwrite = false;
        }
        try {
            boolean ignore;
            if (isCollection) {
                if (!fileAlreadyExist && Utils.resourceUpdated(metaFilePath, root)) {
                    ignore = file.mkdir();
                } else {
                    overwrite = false;
                }
            } else if (overwrite) {
                ignore = file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new SynchronizationException(MessageCode.FILE_CREATION_FAILED, e, new String[]{"file: " + filePath});
        }
        Iterator children = root.getChildren();
        while (children.hasNext()) {
            OMText text;
            OMElement child = (OMElement)children.next();
            String localName = child.getLocalName();
            if (localName.equals("lastModified")) {
                text = (OMText)child.getFirstOMChild();
                if (text == null) continue;
                long date = Long.parseLong(text.getText());
                boolean ignore = file.setLastModified(date);
                continue;
            }
            if (!localName.equals("content")) continue;
            text = (OMText)child.getFirstOMChild();
            if (text != null) {
                contentBytes = Base64.decode((String)text.getText());
            }
            String md5 = Utils.getMD5(contentBytes);
            root.addAttribute("md5", md5, null);
            child.detach();
        }
        if (!isCollection && overwrite) {
            try {
                FileOutputStream fileStream = null;
                try {
                    fileStream = new FileOutputStream(file);
                    fileStream.write(contentBytes);
                    fileStream.flush();
                }
                finally {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new SynchronizationException(MessageCode.PROBLEM_IN_CREATING_CONTENT, e, new String[]{"file: " + filePath});
            }
        }
        if (!(metaDirectory = new File(metaDirectoryName)).exists() && !metaDirectory.mkdir()) {
            throw new SynchronizationException(MessageCode.ERROR_CREATING_META_FILE, new String[]{"file: " + metaDirectoryName});
        }
        Utils.createMetaFile(metaFilePath, root);
        if (!fileAlreadyExist) {
            if (callback != null) {
                callback.displayMessage(new Message(MessageCode.ADDED, new String[]{filePath}));
            }
            ++this.addedCount;
        } else if (overwrite) {
            if (callback != null) {
                callback.displayMessage(new Message(MessageCode.OVERWRITTEN, new String[]{filePath}));
            }
            ++this.overwrittenCount;
        } else {
            if (callback != null) {
                callback.displayMessage(new Message(MessageCode.NON_OVERWRITTEN, new String[]{filePath}));
            }
            ++this.nonOverwrittenCount;
        }
        if (!(xmlReader.hasNext() && xmlReader.isStartElement() && xmlReader.getLocalName().equals("children"))) {
            while (!(!xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("resource"))) {
                xmlReader.next();
            }
            return;
        }
        do {
            xmlReader.next();
            if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("children")) continue;
            if (xmlReader.hasNext()) {
                do {
                    xmlReader.next();
                } while (xmlReader.hasNext() && (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("resource")));
            }
            return;
        } while (!xmlReader.isStartElement() && xmlReader.hasNext());
        while (xmlReader.hasNext() && xmlReader.isStartElement() && xmlReader.getLocalName().equals("resource")) {
            String childName;
            String fileResourceName = childName = xmlReader.getAttributeValue(null, "name");
            String childFilePath = filePath + File.separator + fileResourceName;
            String childPath = (path.equals("/") ? "" : path) + "/" + childName;
            this.checkOutRecursively(xmlReader, childFilePath, childPath, callback);
            while (!(xmlReader.isStartElement() || !xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("children"))) {
                xmlReader.next();
            }
            if (!xmlReader.isEndElement() || !xmlReader.getLocalName().equals("children")) continue;
            break;
        }
        while (!(!xmlReader.hasNext() || xmlReader.isEndElement() && xmlReader.getLocalName().equals("resource"))) {
            xmlReader.next();
        }
    }
}

