/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.servlet;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.clustering.NodeGroupLock;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.servlet.FileUploadUtil;
import org.wso2.carbon.registry.core.servlet.ResourceRequestProcessor;
import org.wso2.carbon.registry.core.servlet.utils.Utils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;

@Deprecated
public class RegistryServlet
extends HttpServlet {
    private static final long serialVersionUID = 2000065602498609086L;
    private static final Log log = LogFactory.getLog(RegistryServlet.class);
    protected transient ServletConfig servletConfig;
    private String contextRoot = null;

    public void init(final ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InputStream configStream;
            String configPath = config.getInitParameter("registry.config.path");
            if (configPath != null) {
                try {
                    configStream = new FileInputStream(configPath);
                }
                catch (FileNotFoundException e) {
                    throw new ServletException("Couldn't find specified config file '" + configPath + "'", (Throwable)e);
                }
            } else {
                configStream = config.getServletContext().getResourceAsStream("/WEB-INF/registry.xml");
            }
            RegistryContext registryContext = RegistryContext.getBaseInstance(configStream, new RegistryContext.RegURLSupplier(){

                @Override
                public String getURL() {
                    return config.getServletContext().getRealPath("/WEB-INF");
                }
            });
            EmbeddedRegistryService embeddedRegistryService = registryContext.getEmbeddedRegistryService();
            UserRegistry systemRegistry = embeddedRegistryService.getConfigSystemRegistry();
            NodeGroupLock.lock("INITIALIZE");
            if (log.isTraceEnabled()) {
                log.trace((Object)"Creating system collections used in WSO2 Registry server.");
            }
            if (!systemRegistry.resourceExists("/system")) {
                try {
                    boolean inTransaction = Transaction.isStarted();
                    if (!inTransaction) {
                        systemRegistry.beginTransaction();
                    }
                    Collection systemCollection = systemRegistry.newCollection();
                    String systemDesc = "This collection is used to store system data of the WSO2 Registry server. User nor the admins of the registry are not expected to edit any content of this collection. Changing content of this collection may result in unexpected behaviors.";
                    systemCollection.setDescription(systemDesc);
                    systemRegistry.put("/system", systemCollection);
                    Collection advancedQueryCollection = systemRegistry.newCollection();
                    String advaceDesc = "This collection is used to store auto generated queries to support various combinations of advanced search criteria. This is initialy empty and gets filled as advanced search is executed from the web UI.";
                    advancedQueryCollection.setDescription(advaceDesc);
                    systemRegistry.put("/system/queries/advanced", advancedQueryCollection);
                    if (!inTransaction) {
                        systemRegistry.commitTransaction();
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to setup system collections used by the Carbon server.";
                    log.error((Object)msg, (Throwable)e);
                    systemRegistry.rollbackTransaction();
                    throw new RegistryException(e.getMessage(), e);
                }
            }
            try {
                AuthorizationManager ac = systemRegistry.getUserRealm().getAuthorizationManager();
                RealmConfiguration realmConfig = registryContext.getRealmService().getBootstrapRealmConfiguration();
                String systemUserName = "wso2.system.user";
                ac.clearResourceAuthorizations("/system");
                ac.authorizeUser(systemUserName, "/system", "http://www.wso2.org/projects/registry/actions/get");
                ac.authorizeUser(systemUserName, "/system", "http://www.wso2.org/projects/registry/actions/add");
                ac.authorizeUser(systemUserName, "/system", "http://www.wso2.org/projects/registry/actions/delete");
                ac.authorizeUser(systemUserName, "/system", "authorize");
                String adminUserName = "wso2.system.user";
                ac.authorizeUser(adminUserName, "/system", "http://www.wso2.org/projects/registry/actions/get");
                String adminRoleName = realmConfig.getAdminRoleName();
                ac.authorizeRole(adminRoleName, "/system", "http://www.wso2.org/projects/registry/actions/get");
                String everyoneRoleName = realmConfig.getEveryOneRoleName();
                ac.authorizeRole(everyoneRoleName, "/system/queries/advanced", "http://www.wso2.org/projects/registry/actions/get");
            }
            catch (UserStoreException e) {
                String msg = "Failed to set permissions for the system collection.";
                log.fatal((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"System collections for WSO2 Registry server created successfully.");
            }
            NodeGroupLock.unlock("INITIALIZE");
            config.getServletContext().setAttribute("CoreRegistry", (Object)embeddedRegistryService);
            System.getProperties().put("CoreRegistry", embeddedRegistryService);
            System.getProperties().put("SystemRegistry", systemRegistry);
        }
        catch (RegistryException e) {
            String msg = "Registry initialization failed. " + e.getMessage();
            log.fatal((Object)msg, (Throwable)((Object)e));
            throw new ServletException(msg, (Throwable)((Object)e));
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.initContextRoot(httpServletRequest);
        String uri = httpServletRequest.getRequestURI();
        String p1 = uri.substring(this.contextRoot.length(), uri.length());
        if (p1.equals("/web/addResource")) {
            this.handleFileUpload(httpServletRequest, httpServletResponse);
        }
    }

    private void handleFileUpload(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            UserRegistry registry = Utils.getSecureRegistry(request);
            ResourceImpl fileElement = FileUploadUtil.processUpload(request);
            String path = fileElement.getPath();
            registry.put(path, fileElement);
            request.getSession().setAttribute("edit_status", (Object)("Resource " + path + " was successfully added to the registry."));
            response.setContentType("text/html");
            request.getRequestDispatcher("/admin/resources.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (RegistryException e) {
            request.getSession().setAttribute("edit_status", (Object)e.getMessage());
            response.setContentType("text/html");
            request.getRequestDispatcher("/admin/resources.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        String uri = URLDecoder.decode(request.getRequestURI(), "utf-8");
        String controlPart = uri.substring(this.contextRoot.length());
        if (controlPart.startsWith("/resources")) {
            String path = uri.equals("") || uri.endsWith("resources/") ? "/" : uri.substring((this.contextRoot + "/" + "resources").length(), uri.length());
            ResourceRequestProcessor.processResourceGET(request, response, path);
        }
    }

    public void initContextRoot(HttpServletRequest req) {
        if (this.contextRoot != null && this.contextRoot.trim().length() != 0) {
            return;
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && contextPath.length() == 0) {
            contextPath = "/";
        }
        this.contextRoot = contextPath;
    }

    protected void renderView(String jspName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        httpServletRequest.getRequestDispatcher(jspName).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

