/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.CommentsDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class CommentURLHandler
extends Handler {
    private static final Log log = LogFactory.getLog(CommentURLHandler.class);

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        CommentsDAO commentsDAO = registryContext.getDataAccessManager().getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        ResourcePath resourcePath = requestContext.getResourcePath();
        String commentID = resourcePath.getParameterValue("comments");
        if (commentID != null) {
            long cID;
            try {
                cID = Long.parseLong(commentID);
            }
            catch (NumberFormatException e) {
                return null;
            }
            Comment comment = commentsDAO.getComment(cID, resourcePath.getPath());
            if (comment == null) {
                String msg = "Requested comment with ID: " + cID + " is not available.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            requestContext.setProcessingComplete(true);
            return comment;
        }
        return null;
    }

    @Override
    public void delete(RequestContext requestContext) throws RegistryException {
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        CommentsDAO commentsDAO = registryContext.getDataAccessManager().getDAOManager().getCommentsDAO(StaticConfiguration.isVersioningComments());
        requestContext.setProcessingComplete(false);
        ResourcePath resourcePath = requestContext.getResourcePath();
        String commentID = resourcePath.getParameterValue("comments");
        if (commentID != null) {
            long cID;
            try {
                cID = Long.parseLong(commentID);
            }
            catch (NumberFormatException e) {
                return;
            }
            String userID = CurrentSession.getUser();
            String authorizationPath = AuthorizationUtils.getAuthorizationPath(resourcePath.getPath());
            Comment comment = commentsDAO.getComment(cID, resourcePath.getPath());
            String commentAuthor = comment.getUser();
            try {
                UserRealm realm = CurrentSession.getUserRealm();
                if (!userID.equals(commentAuthor) && !realm.getAuthorizationManager().isUserAuthorized(userID, authorizationPath, "http://www.wso2.org/projects/registry/actions/add")) {
                    String msg = "User: " + userID + " is not authorized to delete the comment on the resource: " + authorizationPath;
                    log.warn((Object)msg);
                    throw new AuthorizationFailedException(msg);
                }
            }
            catch (UserStoreException e) {
                // empty catch block
            }
            commentsDAO.deleteComment(cID);
            requestContext.setProcessingComplete(true);
        }
    }
}

