/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.component.xml.builder;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.utils.component.xml.builder.ComponentConfigBuilder;
import org.wso2.carbon.utils.component.xml.config.ComponentConfig;
import org.wso2.carbon.utils.component.xml.config.DeployerConfig;

public class DeployerConfigBuilder
extends ComponentConfigBuilder {
    @Override
    public ComponentConfig[] build(OMElement deployersElement) throws CarbonException {
        ArrayList<DeployerConfig> deployerConfigList = new ArrayList<DeployerConfig>();
        Iterator iterator = deployersElement.getChildrenWithName(new QName("http://products.wso2.org/carbon", "deployer"));
        while (iterator.hasNext()) {
            OMElement deployerElement = (OMElement)iterator.next();
            OMElement directoryElement = deployerElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "directory"));
            String directory = null;
            if (directoryElement != null) {
                directory = directoryElement.getText().trim();
            }
            if (directory == null) {
                throw new CarbonException("Mandatory attribute deployer/directory entry does not exist or is empty in the component.xml");
            }
            OMElement extensionElement = deployerElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "extension"));
            String extension = null;
            if (extensionElement != null) {
                extension = extensionElement.getText().trim();
            }
            OMElement classElement = deployerElement.getFirstChildWithName(new QName("http://products.wso2.org/carbon", "class"));
            String classString = null;
            if (classElement != null) {
                classString = classElement.getText().trim();
            }
            if (classString == null) {
                throw new CarbonException("Mandatory attribute deployer/class entry does not exist or is empty in the component.xml");
            }
            DeployerConfig deployerConfig = new DeployerConfig();
            deployerConfig.setClassStr(classString);
            deployerConfig.setDirectory(directory);
            deployerConfig.setExtension(extension);
            deployerConfigList.add(deployerConfig);
        }
        if (deployerConfigList.size() == 0) {
            return null;
        }
        DeployerConfig[] deployerConfigs = new DeployerConfig[deployerConfigList.size()];
        return deployerConfigList.toArray(deployerConfigs);
    }

    @Override
    public String getLocalNameOfComponentConfigElement() {
        return "deployers";
    }
}

