/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.SFTPEngine;

public class PathHelper {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private final SFTPEngine engine;
    private final String pathSep;
    private String dotDir;

    public PathHelper(SFTPEngine engine, String pathSep) {
        this.engine = engine;
        this.pathSep = pathSep;
    }

    public String adjustForParent(String parent, String path) {
        return PathComponents.adjustForParent(parent, path, this.pathSep);
    }

    public String trimTrailingSeparator(String path) {
        return PathComponents.trimTrailingSeparator(path, this.pathSep);
    }

    public String getPathSeparator() {
        return this.pathSep;
    }

    public PathComponents getComponents(String parent, String name) {
        return new PathComponents(parent, name, this.pathSep);
    }

    public PathComponents getComponents(String path) throws IOException {
        if (path.isEmpty() || path.equals(".")) {
            return this.getComponents(this.getDotDir());
        }
        int lastSlash = path.lastIndexOf(this.pathSep);
        if (lastSlash == -1) {
            if (path.equals("..")) {
                return this.getComponents(this.canon(path));
            }
            return this.getComponents(this.getDotDir(), path);
        }
        String name = path.substring(lastSlash + this.pathSep.length());
        if (name.equals(".") || name.equals("..")) {
            return this.getComponents(this.canon(path));
        }
        String parent = path.substring(0, lastSlash);
        return this.getComponents(parent, name);
    }

    private synchronized String getDotDir() throws IOException {
        return this.dotDir != null ? this.dotDir : (this.dotDir = this.canon("."));
    }

    private String canon(String path) throws IOException {
        return this.engine.canonicalize(path);
    }
}

