/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.MyProxyLogon;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.inject.Provider;
import javax.net.ssl.KeyManagerFactory;

public class MPCProvider
implements Provider<MyProxyConnectable> {
    String username;
    String hostname;
    String password;
    int port;
    long lifetime;
    KeyManagerFactory keyManagerFactory;

    public MPCProvider(String username, String password, String hostname, int port, long lifetime, KeyManagerFactory keyManagerFactory) {
        this.username = username;
        this.password = password == null ? "" : password;
        this.port = port;
        this.lifetime = lifetime;
        this.hostname = hostname;
        this.keyManagerFactory = keyManagerFactory;
    }

    public MyProxyConnectable get() {
        MyProxyLogon myProxyLogon = new MyProxyLogon();
        myProxyLogon.setHost(this.hostname);
        myProxyLogon.setLifetime((int)this.lifetime / 1000);
        myProxyLogon.setPort(this.port);
        myProxyLogon.setUsername(this.username);
        myProxyLogon.setPassphrase(this.password);
        myProxyLogon.setKeyManagerFactory(this.keyManagerFactory);
        return new MyProxyLogonConnection(myProxyLogon);
    }

    public static class MyProxyLogonConnection
    implements MyProxyConnectable {
        MyProxyLogon myProxyLogon;
        Identifier identifier;

        public MyProxyLogonConnection(MyProxyLogon myProxyLogon) {
            this.myProxyLogon = myProxyLogon;
        }

        @Override
        public void close() {
            try {
                this.myProxyLogon.disconnect();
            }
            catch (Throwable e) {
                throw new ConnectionException("Error: disconnecting from myproxy", e);
            }
        }

        @Override
        public void open() {
            try {
                this.myProxyLogon.connect();
                this.myProxyLogon.logon();
            }
            catch (Throwable e) {
                throw new ConnectionException("Error: connecting to myproxy", e);
            }
        }

        @Override
        public LinkedList<X509Certificate> getCerts(MyPKCS10CertRequest pkcs10CertRequest) {
            try {
                this.myProxyLogon.getCredentials(pkcs10CertRequest.getEncoded());
                LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
                certList.addAll(this.myProxyLogon.getCertificates());
                return certList;
            }
            catch (Throwable e) {
                throw new GeneralException("Error: getting certs from myproxy", e);
            }
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public String getIdentifierString() {
            if (this.identifier == null) {
                return null;
            }
            return this.identifier.toString();
        }

        public void setIdentifier(Identifier identifier) {
            this.identifier = identifier;
        }
    }
}

