/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.DozerBeanMapper;
import org.dozer.DozerEventListener;
import org.dozer.Mapper;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DozerBeanMapperFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    DozerBeanMapper beanMapper;
    private Resource[] mappingFiles;
    private List<CustomConverter> customConverters;
    private Map<String, CustomConverter> customConvertersWithId;
    private List<DozerEventListener> eventListeners;
    private Map<String, BeanFactory> factories;

    public final void setMappingFiles(Resource[] mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public final void setCustomConverters(List<CustomConverter> customConverters) {
        this.customConverters = customConverters;
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.customConvertersWithId = customConvertersWithId;
    }

    public final void setEventListeners(List<DozerEventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public final void setFactories(Map<String, BeanFactory> factories) {
        this.factories = factories;
    }

    public final Object getObject() throws Exception {
        return this.beanMapper;
    }

    public final Class<Mapper> getObjectType() {
        return Mapper.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        this.beanMapper = new DozerBeanMapper();
        if (this.mappingFiles != null) {
            ArrayList<String> mappings = new ArrayList<String>(this.mappingFiles.length);
            for (Resource mappingFile : this.mappingFiles) {
                mappings.add(mappingFile.getURL().toString());
            }
            this.beanMapper.setMappingFiles(mappings);
        }
        if (this.customConverters != null) {
            this.beanMapper.setCustomConverters(this.customConverters);
        }
        if (this.customConvertersWithId != null) {
            this.beanMapper.setCustomConvertersWithId(this.customConvertersWithId);
        }
        if (this.eventListeners != null) {
            this.beanMapper.setEventListeners(this.eventListeners);
        }
        if (this.factories != null) {
            this.beanMapper.setFactories(this.factories);
        }
    }

    public void destroy() throws Exception {
        if (this.beanMapper != null) {
            this.beanMapper.destroy();
        }
    }
}

