/*
 * Decompiled with CFR 0.152.
 */
package org.dozer;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.dozer.config.BeanContainer;
import org.dozer.config.GlobalSettings;
import org.dozer.jmx.DozerAdminController;
import org.dozer.jmx.DozerStatisticsController;
import org.dozer.jmx.JMXPlatform;
import org.dozer.jmx.JMXPlatformImpl;
import org.dozer.loader.xml.ELEngine;
import org.dozer.loader.xml.ExpressionElementReader;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.DozerProxyResolver;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DozerInitializer {
    private static final Logger log = LoggerFactory.getLogger(DozerInitializer.class);
    private static final String DOZER_STATISTICS_CONTROLLER = "org.dozer.jmx:type=DozerStatisticsController";
    private static final String DOZER_ADMIN_CONTROLLER = "org.dozer.jmx:type=DozerAdminController";
    private static final DozerInitializer instance = new DozerInitializer();
    private volatile boolean isInitialized = false;

    private DozerInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (this.isInitialized) {
                log.debug("Tried to perform initialization when Dozer was already started.");
                return;
            }
            log.info("Initializing Dozer. Version: {}, Thread Name: {}", (Object)"5.4.0", (Object)Thread.currentThread().getName());
            GlobalSettings globalSettings = GlobalSettings.getInstance();
            this.initialize(globalSettings);
            this.isInitialized = true;
        }
    }

    void initialize(GlobalSettings globalSettings) {
        if (globalSettings.isAutoregisterJMXBeans()) {
            try {
                this.registerJMXBeans(new JMXPlatformImpl());
            }
            catch (Throwable t) {
                log.warn("Unable to register Dozer JMX MBeans with the PlatformMBeanServer.  Dozer will still function normally, but management via JMX may not be available", t);
            }
        }
        String classLoaderName = globalSettings.getClassLoaderName();
        String proxyResolverName = globalSettings.getProxyResolverName();
        DefaultClassLoader defaultClassLoader = new DefaultClassLoader();
        BeanContainer beanContainer = BeanContainer.getInstance();
        Class<DozerClassLoader> classLoaderType = this.loadBeanType(classLoaderName, defaultClassLoader, DozerClassLoader.class);
        Class<DozerProxyResolver> proxyResolverType = this.loadBeanType(proxyResolverName, defaultClassLoader, DozerProxyResolver.class);
        DozerClassLoader classLoaderBean = ReflectionUtils.newInstance(classLoaderType);
        DozerProxyResolver proxyResolverBean = ReflectionUtils.newInstance(proxyResolverType);
        beanContainer.setClassLoader(classLoaderBean);
        beanContainer.setProxyResolver(proxyResolverBean);
        if (globalSettings.isElEnabled()) {
            ELEngine engine = new ELEngine();
            engine.init();
            beanContainer.setElEngine(engine);
            beanContainer.setElementReader(new ExpressionElementReader(engine));
        }
    }

    private <T> Class<? extends T> loadBeanType(String classLoaderName, DefaultClassLoader classLoader, Class<T> iface) {
        Class<?> beanType = classLoader.loadClass(classLoaderName);
        if (beanType != null && !iface.isAssignableFrom(beanType)) {
            MappingUtils.throwMappingException("Incompatible types: " + iface.getName() + " and " + classLoaderName);
        }
        return beanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DozerInitializer dozerInitializer = this;
        synchronized (dozerInitializer) {
            if (!this.isInitialized) {
                log.debug("Tried to destroy when no Dozer instance started.");
                return;
            }
            try {
                this.unregisterJMXBeans(new JMXPlatformImpl());
            }
            catch (Throwable e) {
                log.warn("Exception caught while disposing Dozer JMX MBeans.", e);
            }
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private void registerJMXBeans(JMXPlatform platform) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        if (platform.isAvailable()) {
            platform.registerMBean(DOZER_STATISTICS_CONTROLLER, new DozerStatisticsController());
            platform.registerMBean(DOZER_ADMIN_CONTROLLER, new DozerAdminController());
        } else {
            log.warn("jdk1.5 jmx management classes unavailable. Dozer JMX MBeans will not be auto registered.");
        }
    }

    private void unregisterJMXBeans(JMXPlatform platform) throws MBeanRegistrationException, MalformedObjectNameException {
        if (platform.isAvailable()) {
            platform.unregisterMBean(DOZER_ADMIN_CONTROLLER);
            platform.unregisterMBean(DOZER_STATISTICS_CONTROLLER);
        } else {
            log.warn("jdk1.5 jmx management classes unavailable.");
        }
    }

    public static DozerInitializer getInstance() {
        return instance;
    }
}

