/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.globus.util.Util;

public class GlobusURL {
    protected String protocol = null;
    protected String host = null;
    protected String urlPath = null;
    protected String user = null;
    protected String pwd = null;
    protected String url = null;
    protected int port = -1;

    public GlobusURL(String url) throws MalformedURLException {
        url = url.trim();
        int p1 = url.indexOf("://");
        if (p1 == -1) {
            throw new MalformedURLException("Missing '[protocol]://'");
        }
        this.protocol = url.substring(0, p1).toLowerCase();
        String base = null;
        int p2 = url.indexOf(47, p1 += 3);
        if (p2 == -1) {
            base = url.substring(p1);
            this.urlPath = null;
        } else {
            base = url.substring(p1, p2);
            this.urlPath = ++p2 != url.length() ? url.substring(p2) : null;
        }
        p1 = base.indexOf(64);
        if (p1 == -1) {
            this.parseHostPort(base);
        } else {
            this.parseUserPwd(base.substring(0, p1));
            this.parseHostPort(base.substring(p1 + 1));
        }
        if (this.port == -1) {
            this.port = GlobusURL.getPort(this.protocol);
        }
        if (this.protocol.equals("ftp") && this.user == null && this.pwd == null) {
            this.user = "anonymous";
            this.pwd = "anon@anon.com";
        }
        this.url = url;
    }

    public GlobusURL(URL url) {
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        this.urlPath = url.getFile();
    }

    public static int getPort(String protocol) {
        if (protocol.equals("ftp")) {
            return 21;
        }
        if (protocol.equals("gsiftp") || protocol.equals("gridftp")) {
            return 2811;
        }
        if (protocol.equals("http")) {
            return 80;
        }
        if (protocol.equals("https")) {
            return 443;
        }
        if (protocol.equals("ldap")) {
            return 389;
        }
        if (protocol.equals("ldaps")) {
            return 636;
        }
        return -1;
    }

    private void parseHostPort(String str) throws MalformedURLException {
        int start = 0;
        if (str.length() > 0 && str.charAt(0) == '[' && (start = str.indexOf(93)) == -1) {
            throw new MalformedURLException("Missing ']' in IPv6 address: " + str);
        }
        int p1 = str.indexOf(58, start);
        if (p1 == -1) {
            this.host = str;
        } else {
            this.host = str.substring(0, p1);
            String pp = str.substring(p1 + 1);
            try {
                this.port = Integer.parseInt(pp);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Invalid port number: " + pp);
            }
        }
    }

    private void parseUserPwd(String str) {
        int p1 = str.indexOf(58);
        if (p1 == -1) {
            this.user = Util.decode(str);
        } else {
            this.user = Util.decode(str.substring(0, p1));
            this.pwd = Util.decode(str.substring(p1 + 1));
        }
    }

    public String getURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.urlPath;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public boolean equals(Object obj) {
        GlobusURL cUrl = null;
        if (obj instanceof String) {
            try {
                cUrl = new GlobusURL((String)obj);
            }
            catch (MalformedURLException e) {
                return false;
            }
        } else if (obj instanceof GlobusURL) {
            cUrl = (GlobusURL)obj;
        } else {
            return false;
        }
        if (this.getPort() != cUrl.getPort()) {
            return false;
        }
        if (!this.compare(this.getProtocol(), cUrl.getProtocol(), false)) {
            return false;
        }
        if (!this.compare(this.getHost(), cUrl.getHost(), false)) {
            return false;
        }
        if (!this.compare(this.urlPath, cUrl.urlPath, false)) {
            return false;
        }
        if (!this.compare(this.getUser(), cUrl.getUser(), false)) {
            return false;
        }
        return this.compare(this.getPwd(), cUrl.getPwd(), false);
    }

    private boolean compare(String s1, String s2, boolean ignoreCase) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public int hashCode() {
        int value = this.port;
        if (this.protocol != null) {
            value += this.protocol.hashCode();
        }
        if (this.host != null) {
            value += this.host.hashCode();
        }
        if (this.urlPath != null) {
            value += this.urlPath.hashCode();
        }
        if (this.user != null) {
            value += this.user.hashCode();
        }
        if (this.pwd != null) {
            value += this.pwd.hashCode();
        }
        return value;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("Protocol    : " + this.protocol + "\n");
        info.append("Host name   : " + this.host + "\n");
        info.append("Port number : " + this.port + "\n");
        info.append("Url path    : " + this.urlPath + "\n");
        info.append("User        : " + this.user + "\n");
        info.append("Pwd         : " + this.pwd + "\n");
        return info.toString();
    }
}

