/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.common.CoGProperties;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.KeyUsage;
import org.globus.gsi.util.Oid;
import org.globus.gsi.util.ProxyCertificateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertificateUtil {
    private static String provider;
    private static Log logger;
    private static final Map<String, String> KEYWORD_MAP;
    private static final Map<String, String> OID_MAP;

    private CertificateUtil() {
    }

    public static void init() {
        CertificateLoadUtil.init();
    }

    public static void setProvider(String providerName) {
        provider = providerName;
    }

    public static void installSecureRandomProvider() {
        CoGProperties props = CoGProperties.getDefault();
        String providerName = props.getSecureRandomProvider();
        try {
            Class<?> providerClass = Class.forName(providerName);
            Security.insertProviderAt((Provider)providerClass.newInstance(), 1);
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to install PRNG. Using default PRNG.", (Throwable)e);
        }
    }

    public static int getCAPathConstraint(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return -1;
        }
        X509Extension proxyExtension = extensions.getExtension(X509Extension.basicConstraints);
        if (proxyExtension != null) {
            BasicConstraints basicExt = CertificateUtil.getBasicConstraints(proxyExtension);
            if (basicExt.isCA()) {
                BigInteger pathLen = basicExt.getPathLenConstraint();
                return pathLen == null ? Integer.MAX_VALUE : pathLen.intValue();
            }
            return -1;
        }
        return -1;
    }

    public static KeyPair generateKeyPair(String algorithm, int bits) throws GeneralSecurityException {
        KeyPairGenerator generator = null;
        generator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize(bits);
        return generator.generateKeyPair();
    }

    public static GSIConstants.CertificateType getCertificateType(TBSCertificateStructure crt) throws CertificateException, IOException {
        BasicConstraints basicExt;
        X509Extensions extensions = crt.getExtensions();
        X509Extension ext = null;
        if (extensions != null && (ext = extensions.getExtension(X509Extension.basicConstraints)) != null && (basicExt = CertificateUtil.getBasicConstraints(ext)).isCA()) {
            return GSIConstants.CertificateType.CA;
        }
        GSIConstants.CertificateType type = GSIConstants.CertificateType.EEC;
        X500Name subject = crt.getSubject();
        ASN1Set entry = X509NameHelper.getLastNameEntry(subject);
        ASN1Sequence ava = (ASN1Sequence)entry.getObjectAt(0);
        if (BCStyle.CN.equals((Object)ava.getObjectAt(0))) {
            type = CertificateUtil.processCN(extensions, type, ava);
        }
        return type;
    }

    private static GSIConstants.CertificateType processCN(X509Extensions extensions, GSIConstants.CertificateType type, ASN1Sequence ava) throws CertificateException {
        String value = ((ASN1String)ava.getObjectAt(1)).getString();
        GSIConstants.CertificateType certType = type;
        if (value.equalsIgnoreCase("proxy")) {
            certType = GSIConstants.CertificateType.GSI_2_PROXY;
        } else if (value.equalsIgnoreCase("limited proxy")) {
            certType = GSIConstants.CertificateType.GSI_2_LIMITED_PROXY;
        } else if (extensions != null) {
            boolean gsi4 = true;
            X509Extension ext = extensions.getExtension(ProxyCertInfo.OID);
            if (ext == null) {
                ext = extensions.getExtension(ProxyCertInfo.OLD_OID);
                gsi4 = false;
            }
            if (ext != null) {
                if (ext.isCritical()) {
                    certType = CertificateUtil.processCriticalExtension(ext, gsi4);
                } else {
                    String err = "proxyCertCritical";
                    throw new CertificateException(err);
                }
            }
        }
        return certType;
    }

    private static GSIConstants.CertificateType processCriticalExtension(X509Extension ext, boolean gsi4) {
        ProxyCertInfo proxyCertExt = ProxyCertificateUtil.getProxyCertInfo(ext);
        ProxyPolicy proxyPolicy = proxyCertExt.getProxyPolicy();
        DERObjectIdentifier oid = proxyPolicy.getPolicyLanguage();
        GSIConstants.CertificateType type = ProxyPolicy.IMPERSONATION.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY : GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY) : (ProxyPolicy.INDEPENDENT.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY : GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY) : (ProxyPolicy.LIMITED.equals((Object)oid) ? (gsi4 ? GSIConstants.CertificateType.GSI_4_LIMITED_PROXY : GSIConstants.CertificateType.GSI_3_LIMITED_PROXY) : (gsi4 ? GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY : GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY)));
        return type;
    }

    public static BasicConstraints getBasicConstraints(X509Extension ext) throws IOException {
        ASN1Primitive object = X509Extension.convertValueToObject((X509Extension)ext);
        return BasicConstraints.getInstance((Object)object);
    }

    public static ASN1Primitive toASN1Primitive(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
        return derInputStream.readObject();
    }

    public static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) throws CertificateEncodingException, IOException {
        ASN1Primitive obj = CertificateUtil.toASN1Primitive(cert.getTBSCertificate());
        return TBSCertificateStructure.getInstance((Object)obj);
    }

    public static EnumSet<KeyUsage> getKeyUsage(TBSCertificateStructure crt) throws IOException {
        X509Extensions extensions = crt.getExtensions();
        if (extensions == null) {
            return null;
        }
        X509Extension extension = extensions.getExtension(X509Extension.keyUsage);
        return extension != null ? CertificateUtil.getKeyUsage(extension) : null;
    }

    public static EnumSet<KeyUsage> getKeyUsage(X509Extension ext) throws IOException {
        DERBitString bits = (DERBitString)CertificateUtil.getExtensionObject(ext);
        EnumSet<KeyUsage> keyUsage = EnumSet.noneOf(KeyUsage.class);
        for (KeyUsage bit : KeyUsage.values()) {
            if (!bit.isSet(bits)) continue;
            keyUsage.add(bit);
        }
        return keyUsage;
    }

    public static ASN1Primitive getExtensionObject(X509Extension ext) throws IOException {
        return CertificateUtil.toASN1Primitive(ext.getValue().getOctets());
    }

    public static String toGlobusID(String dn) {
        return CertificateUtil.toGlobusID(dn, true);
    }

    public static String toGlobusID(String dn, boolean noreverse) {
        if (dn == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] tokens = dn.split(",");
        if (noreverse) {
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i].trim();
                if (token.isEmpty()) continue;
                buf.append("/");
                buf.append(token.trim());
            }
        } else {
            for (int i = tokens.length - 1; i >= 0; --i) {
                String token = tokens[i].trim();
                if (token.isEmpty()) continue;
                buf.append("/");
                buf.append(token.trim());
            }
        }
        return buf.toString();
    }

    public static String toGlobusID(Principal name) {
        if (name instanceof X509Name) {
            return X509NameHelper.toString((X509Name)name);
        }
        if (name instanceof X500Principal) {
            return CertificateUtil.toGlobusID((X500Principal)name);
        }
        return CertificateUtil.toGlobusID(name.getName());
    }

    public static String toGlobusID(X500Principal principal) {
        if (principal == null) {
            return null;
        }
        String dn = principal.getName("RFC2253", OID_MAP);
        StringBuilder buf = new StringBuilder();
        boolean IDLE = false;
        boolean VALUE = true;
        int KEY = 2;
        int state = 0;
        int cEnd = 0;
        char[] asChars = dn.toCharArray();
        block4: for (int i = asChars.length - 1; i >= 0; --i) {
            char c = asChars[i];
            switch (state) {
                case 2: {
                    if (c != ',') continue block4;
                    String s = dn.substring(i + 1, cEnd + 1);
                    buf.append('/').append(s);
                    state = 0;
                    continue block4;
                }
                case 1: {
                    if (c != '=') continue block4;
                    state = 2;
                    continue block4;
                }
                default: {
                    cEnd = i;
                    state = 1;
                }
            }
        }
        String s = dn.substring(0, cEnd + 1);
        buf.append('/').append(s);
        return buf.toString().replace("\\,", ",");
    }

    public static X500Principal toPrincipal(String globusID) {
        if (globusID == null) {
            return null;
        }
        String id = globusID.trim();
        StringBuilder buf = new StringBuilder(id.length());
        if (!id.isEmpty()) {
            boolean IDLE = false;
            boolean VALUE = true;
            int KEY = 2;
            int state = 0;
            int cEnd = 0;
            char[] asChars = id.toCharArray();
            block4: for (int i = asChars.length - 1; i >= 0; --i) {
                char c = asChars[i];
                switch (state) {
                    case 2: {
                        if (c != '/' && c != ' ') continue block4;
                        String s = id.substring(i + 1, cEnd + 1);
                        int commaIndex = s.indexOf(44);
                        if (commaIndex != -1) {
                            s = s.substring(0, commaIndex) + "\\" + s.substring(commaIndex);
                        }
                        buf.append(s).append(',');
                        state = 0;
                        continue block4;
                    }
                    case 1: {
                        if (c != '=') continue block4;
                        state = 2;
                        continue block4;
                    }
                    default: {
                        if (c == '/' || c == ' ') continue block4;
                        cEnd = i;
                        state = 1;
                    }
                }
            }
            buf.deleteCharAt(buf.length() - 1);
        }
        String dn = buf.toString();
        return new X500Principal(dn, KEYWORD_MAP);
    }

    public static CertPath getCertPath(X509Certificate[] certs) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCertPath(Arrays.asList(certs));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateUtil.setProvider("BC");
        logger = LogFactory.getLog((String)CertificateLoadUtil.class.getCanonicalName());
        CertificateUtil.installSecureRandomProvider();
        KEYWORD_MAP = new HashMap<String, String>();
        OID_MAP = new HashMap<String, String>();
        KEYWORD_MAP.put("SN", Oid.SERIALNUMBER.oid);
        KEYWORD_MAP.put("E", Oid.EmailAddress.oid);
        KEYWORD_MAP.put("EMAIL", Oid.EmailAddress.oid);
        KEYWORD_MAP.put("UNSTRUCTUREDADDRESS", Oid.UnstructuredAddress.oid);
        KEYWORD_MAP.put("UNSTRUCTUREDNAME", Oid.UnstructuredName.oid);
        KEYWORD_MAP.put("UNIQUEIDENTIFIER", Oid.UNIQUE_IDENTIFIER.oid);
        KEYWORD_MAP.put("DN", Oid.DN_QUALIFIER.oid);
        KEYWORD_MAP.put("PSEUDONYM", Oid.PSEUDONYM.oid);
        KEYWORD_MAP.put("POSTALADDRESS", Oid.POSTAL_ADDRESS.oid);
        KEYWORD_MAP.put("NAMEOFBIRTH", Oid.NAME_AT_BIRTH.oid);
        KEYWORD_MAP.put("COUNTRYOFCITIZENSHIP", Oid.COUNTRY_OF_CITIZENSHIP.oid);
        KEYWORD_MAP.put("COUNTRYOFRESIDENCE", Oid.COUNTRY_OF_RESIDENCE.oid);
        KEYWORD_MAP.put("GENDER", Oid.GENDER.oid);
        KEYWORD_MAP.put("PLACEOFBIRTH", Oid.PLACE_OF_BIRTH.oid);
        KEYWORD_MAP.put("DATEOFBIRTH", Oid.DATE_OF_BIRTH.oid);
        KEYWORD_MAP.put("POSTALCODE", Oid.POSTAL_CODE.oid);
        KEYWORD_MAP.put("BUSINESSCATEGORY", Oid.BUSINESS_CATEGORY.oid);
        KEYWORD_MAP.put("TELEPHONENUMBER", Oid.TELEPHONE_NUMBER.oid);
        KEYWORD_MAP.put("NAME", Oid.NAME.oid);
        KEYWORD_MAP.put("S", Oid.ST.oid);
        KEYWORD_MAP.put("DNQUALIFIER", Oid.DN_QUALIFIER.oid);
        KEYWORD_MAP.put("IP", Oid.IP.oid);
        OID_MAP.put(Oid.UnstructuredAddress.oid, "unstructuredAddress");
        OID_MAP.put(Oid.UnstructuredName.oid, "unstructuredName");
        OID_MAP.put(Oid.UNIQUE_IDENTIFIER.oid, "UniqueIdentifier");
        OID_MAP.put(Oid.PSEUDONYM.oid, "Pseudonym");
        OID_MAP.put(Oid.POSTAL_ADDRESS.oid, "PostalAddress");
        OID_MAP.put(Oid.NAME_AT_BIRTH.oid, "NameAtBirth");
        OID_MAP.put(Oid.COUNTRY_OF_CITIZENSHIP.oid, "CountryOfCitizenship");
        OID_MAP.put(Oid.COUNTRY_OF_RESIDENCE.oid, "CountryOfResidence");
        OID_MAP.put(Oid.GENDER.oid, "Fender");
        OID_MAP.put(Oid.PLACE_OF_BIRTH.oid, "PlaceOfBirth");
        OID_MAP.put(Oid.DATE_OF_BIRTH.oid, "DateOfBirth");
        OID_MAP.put(Oid.POSTAL_CODE.oid, "PostalCode");
        OID_MAP.put(Oid.BUSINESS_CATEGORY.oid, "BusinessCategory");
        OID_MAP.put(Oid.TELEPHONE_NUMBER.oid, "TelephoneNumber");
        OID_MAP.put(Oid.NAME.oid, "Name");
        OID_MAP.put(Oid.IP.oid, "IP");
        OID_MAP.put(Oid.T.oid, "T");
        OID_MAP.put(Oid.DN_QUALIFIER.oid, "DNQUALIFIER");
        OID_MAP.put(Oid.SURNAME.oid, "SURNAME");
        OID_MAP.put(Oid.GIVENNAME.oid, "GIVENNAME");
        OID_MAP.put(Oid.INITIALS.oid, "INITIALS");
        OID_MAP.put(Oid.GENERATION.oid, "GENERATION");
        OID_MAP.put(Oid.EmailAddress.oid, "EMAILADDRESS");
        OID_MAP.put(Oid.SERIALNUMBER.oid, "SERIALNUMBER");
    }
}

