/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.globus.gsi.CertificateRevocationLists;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509ProxyCertPathParameters;
import org.globus.gsi.X509ProxyCertPathValidatorResult;
import org.globus.gsi.provider.SigningPolicyStore;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.trustmanager.CRLChecker;
import org.globus.gsi.trustmanager.CertificateChecker;
import org.globus.gsi.trustmanager.DateValidityChecker;
import org.globus.gsi.trustmanager.IdentityChecker;
import org.globus.gsi.trustmanager.SigningPolicyChecker;
import org.globus.gsi.trustmanager.TrustedCertPathFinder;
import org.globus.gsi.trustmanager.UnsupportedCriticalExtensionChecker;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.KeyUsage;
import org.globus.gsi.util.ProxyCertificateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ProxyCertPathValidator
extends CertPathValidatorSpi {
    public static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    public static final String KEY_USAGE_OID = "2.5.29.15";
    protected KeyStore keyStore;
    protected CertStore certStore;
    protected SigningPolicyStore policyStore;
    private X509Certificate identityCert;
    private boolean limited;
    private boolean rejectLimitedProxy;
    private Map<String, ProxyPolicyHandler> policyHandlers;

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters params) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (certPath == null) {
            throw new IllegalArgumentException("Certificate path cannot be null");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        if (list.size() < 1) {
            throw new IllegalArgumentException("Certificate path cannot be empty");
        }
        this.parseParameters(params);
        CertPath trustedCertPath = TrustedCertPathFinder.findTrustedCertPath(this.keyStore, certPath);
        return this.validate(trustedCertPath);
    }

    public void clear() {
        this.identityCert = null;
        this.limited = false;
    }

    protected void parseParameters(CertPathParameters params) throws InvalidAlgorithmParameterException {
        if (!(params instanceof X509ProxyCertPathParameters)) {
            throw new IllegalArgumentException("Parameter of type " + X509ProxyCertPathParameters.class.getName() + " required");
        }
        X509ProxyCertPathParameters parameters = (X509ProxyCertPathParameters)params;
        this.keyStore = parameters.getTrustStore();
        this.certStore = parameters.getCrlStore();
        this.policyStore = parameters.getSigningPolicyStore();
        this.rejectLimitedProxy = parameters.isRejectLimitedProxy();
        this.policyHandlers = parameters.getPolicyHandlers();
    }

    protected CertPathValidatorResult validate(CertPath certPath) throws CertPathValidatorException {
        GSIConstants.CertificateType certType;
        TBSCertificateStructure tbsCert;
        List<? extends Certificate> certificates = certPath.getCertificates();
        if (certificates.size() == 0) {
            return null;
        }
        int proxyDepth = 0;
        X509Certificate cert = (X509Certificate)certificates.get(0);
        try {
            tbsCert = this.getTBSCertificateStructure(cert);
            certType = this.getCertificateType(tbsCert);
            this.checkCertificate(cert, certType);
            boolean isProxy = ProxyCertificateUtil.isProxy(certType);
            if (isProxy) {
                ++proxyDepth;
            }
        }
        catch (CertPathValidatorException e) {
            throw new CertPathValidatorException("Path validation failed for " + cert.getSubjectDN() + ": " + e.getMessage(), (Throwable)e, certPath, 0);
        }
        for (int i = 1; i < certificates.size(); ++i) {
            boolean certIsProxy = ProxyCertificateUtil.isProxy(certType);
            X509Certificate issuerCert = (X509Certificate)certificates.get(i);
            TBSCertificateStructure issuerTbsCert = this.getTBSCertificateStructure(issuerCert);
            GSIConstants.CertificateType issuerCertType = this.getCertificateType(issuerTbsCert);
            proxyDepth = this.validateCert(cert, certType, issuerCert, issuerTbsCert, issuerCertType, proxyDepth, i, certIsProxy);
            if (certIsProxy) {
                try {
                    this.checkProxyConstraints(certPath, cert, tbsCert, certType, issuerTbsCert, i);
                }
                catch (CertPathValidatorException e) {
                    throw new CertPathValidatorException("Path validation failed for " + cert.getSubjectDN() + ": " + e.getMessage(), (Throwable)e, certPath, i - 1);
                }
            }
            try {
                this.checkKeyUsage(issuerTbsCert);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("Key usage check failed on " + issuerCert.getSubjectDN() + ": " + e.getMessage(), (Throwable)e, certPath, i);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("Path validation failed for " + issuerCert.getSubjectDN() + ": " + e.getMessage(), (Throwable)e, certPath, i);
            }
            try {
                this.checkCertificate(issuerCert, issuerCertType);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("Path validation failed for " + issuerCert.getSubjectDN() + ": " + e.getMessage(), (Throwable)e, certPath, i);
            }
            cert = issuerCert;
            certType = issuerCertType;
            tbsCert = issuerTbsCert;
        }
        return new X509ProxyCertPathValidatorResult(this.identityCert, this.limited);
    }

    private GSIConstants.CertificateType getCertificateType(TBSCertificateStructure issuerTbsCert) throws CertPathValidatorException {
        GSIConstants.CertificateType issuerCertType;
        try {
            issuerCertType = CertificateUtil.getCertificateType(issuerTbsCert);
        }
        catch (CertificateException e) {
            throw new CertPathValidatorException("Error obtaining certificate type", e);
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Error obtaining certificate type", e);
        }
        return issuerCertType;
    }

    private TBSCertificateStructure getTBSCertificateStructure(X509Certificate issuerCert) throws CertPathValidatorException {
        TBSCertificateStructure issuerTbsCert;
        try {
            issuerTbsCert = CertificateUtil.getTBSCertificateStructure(issuerCert);
        }
        catch (CertificateException e) {
            throw new CertPathValidatorException("Error converting certificate", e);
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Error converting certificate", e);
        }
        return issuerTbsCert;
    }

    private int validateCert(X509Certificate cert, GSIConstants.CertificateType certType, X509Certificate issuerCert, TBSCertificateStructure issuerTbsCert, GSIConstants.CertificateType issuerCertType, int proxyDepth, int i, boolean certIsProxy) throws CertPathValidatorException {
        if (issuerCertType == GSIConstants.CertificateType.CA) {
            this.validateCACert(cert, issuerCert, issuerTbsCert, proxyDepth, i, certIsProxy);
        } else {
            if (ProxyCertificateUtil.isGsi3Proxy(issuerCertType) || ProxyCertificateUtil.isGsi4Proxy(issuerCertType)) {
                return this.validateGsiProxyCert(cert, certType, issuerCert, issuerTbsCert, issuerCertType, proxyDepth);
            }
            if (ProxyCertificateUtil.isGsi2Proxy(issuerCertType)) {
                return this.validateGsi2ProxyCert(cert, certType, issuerCert, proxyDepth);
            }
            if (issuerCertType == GSIConstants.CertificateType.EEC) {
                this.validateEECCert(cert, certType, issuerCert);
            } else {
                throw new CertPathValidatorException("UNknown issuer type " + (Object)((Object)issuerCertType) + " for certificate " + issuerCert.getSubjectDN());
            }
        }
        return proxyDepth;
    }

    private void checkProxyConstraints(CertPath certPath, X509Certificate cert, TBSCertificateStructure tbsCert, GSIConstants.CertificateType certType, TBSCertificateStructure issuerTbsCert, int i) throws CertPathValidatorException {
        if (ProxyCertificateUtil.isGsi3Proxy(certType) || ProxyCertificateUtil.isGsi4Proxy(certType)) {
            try {
                this.checkProxyConstraints(tbsCert, issuerTbsCert, cert);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("Proxy constraint check failed on " + cert.getSubjectDN(), e);
            }
            if (certType == GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY || certType == GSIConstants.CertificateType.GSI_4_RESTRICTED_PROXY) {
                try {
                    this.checkRestrictedProxy(tbsCert, certPath, i);
                }
                catch (IOException e) {
                    throw new CertPathValidatorException("Restricted proxy check failed on " + cert.getSubjectDN(), e);
                }
            }
        }
    }

    private void validateEECCert(X509Certificate cert, GSIConstants.CertificateType certType, X509Certificate issuerCert) throws CertPathValidatorException {
        if (!ProxyCertificateUtil.isProxy(certType)) {
            throw new CertPathValidatorException("EEC can only sign another proxy certificate. Violated by " + issuerCert.getSubjectDN() + " issuing " + cert.getSubjectDN());
        }
    }

    private int validateGsi2ProxyCert(X509Certificate cert, GSIConstants.CertificateType certType, X509Certificate issuerCert, int proxyDepth) throws CertPathValidatorException {
        if (!ProxyCertificateUtil.isGsi2Proxy(certType)) {
            throw new CertPathValidatorException("Proxy certificate can only sign another proxy certificate of same type. Violated by " + issuerCert.getSubjectDN() + " issuing " + cert.getSubjectDN());
        }
        return proxyDepth + 1;
    }

    private int validateGsiProxyCert(X509Certificate cert, GSIConstants.CertificateType certType, X509Certificate issuerCert, TBSCertificateStructure issuerTbsCert, GSIConstants.CertificateType issuerCertType, int proxyDepth) throws CertPathValidatorException {
        int pathLen;
        if (ProxyCertificateUtil.isGsi3Proxy(issuerCertType) ? !ProxyCertificateUtil.isGsi3Proxy(certType) : ProxyCertificateUtil.isGsi4Proxy(issuerCertType) && !ProxyCertificateUtil.isGsi4Proxy(certType)) {
            throw new CertPathValidatorException("Proxy certificate can only sign another proxy certificate of same type. Violated by " + issuerCert.getSubjectDN() + " issuing " + cert.getSubjectDN());
        }
        try {
            pathLen = ProxyCertificateUtil.getProxyPathConstraint(issuerTbsCert);
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Error obtaining proxy path constraint", e);
        }
        if (pathLen == 0) {
            throw new CertPathValidatorException("Proxy path length constraint violated of certificate " + issuerCert.getSubjectDN());
        }
        if (pathLen < Integer.MAX_VALUE && proxyDepth > pathLen) {
            throw new CertPathValidatorException("Proxy path length constraint violated of certificate " + issuerCert.getSubjectDN());
        }
        return proxyDepth + 1;
    }

    private void validateCACert(X509Certificate cert, X509Certificate issuerCert, TBSCertificateStructure issuerTbsCert, int proxyDepth, int i, boolean certIsProxy) throws CertPathValidatorException {
        if (certIsProxy) {
            throw new CertPathValidatorException("Proxy certificate can be signed only by EEC or Proxy Certificate. Certificate " + cert.getSubjectDN() + " violates this.");
        }
        try {
            int pathLen = CertificateUtil.getCAPathConstraint(issuerTbsCert);
            if (pathLen < Integer.MAX_VALUE && i - proxyDepth - 1 > pathLen) {
                throw new CertPathValidatorException("Path length constraint of certificate " + issuerCert.getSubjectDN() + " violated");
            }
        }
        catch (IOException e) {
            throw new CertPathValidatorException("Error obtaining CA Path constraint", e);
        }
    }

    protected void checkRestrictedProxy(TBSCertificateStructure proxy, CertPath certPath, int index) throws CertPathValidatorException, IOException {
        ProxyCertInfo info = ProxyCertificateUtil.getProxyCertInfo(proxy);
        ProxyPolicy policy = info.getProxyPolicy();
        String pl = policy.getPolicyLanguage().getId();
        ProxyPolicyHandler handler = null;
        if (this.policyHandlers != null) {
            handler = this.policyHandlers.get(pl);
        }
        if (handler == null) {
            throw new CertPathValidatorException("Unknown policy, no handler registered to validate policy " + pl);
        }
        handler.validate(info, certPath, index);
    }

    protected void checkKeyUsage(TBSCertificateStructure issuer) throws CertPathValidatorException, IOException {
        EnumSet<KeyUsage> issuerKeyUsage = CertificateUtil.getKeyUsage(issuer);
        if (issuerKeyUsage != null && !issuerKeyUsage.contains((Object)KeyUsage.KEY_CERTSIGN)) {
            throw new CertPathValidatorException("Certificate " + issuer.getSubject() + " violated key usage policy.");
        }
    }

    protected List<CertificateChecker> getCertificateCheckers() {
        ArrayList<CertificateChecker> checkers = new ArrayList<CertificateChecker>();
        checkers.add(new DateValidityChecker());
        checkers.add(new UnsupportedCriticalExtensionChecker());
        checkers.add(new IdentityChecker(this));
        CertificateRevocationLists crlsList = CertificateRevocationLists.getDefaultCertificateRevocationLists();
        checkers.add(new CRLChecker(crlsList, this.keyStore, true));
        checkers.add(new SigningPolicyChecker(this.policyStore));
        return checkers;
    }

    private void checkCertificate(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        for (CertificateChecker checker : this.getCertificateCheckers()) {
            checker.invoke(cert, certType);
        }
    }

    protected void checkProxyConstraints(TBSCertificateStructure proxy, TBSCertificateStructure issuer, X509Certificate checkedProxy) throws CertPathValidatorException, IOException {
        X509Extension proxyExtension;
        DERObjectIdentifier oid;
        Enumeration e;
        X509Extension proxyKeyUsage = null;
        X509Extensions extensions = proxy.getExtensions();
        if (extensions != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                proxyExtension = extensions.getExtension(oid);
                if (oid.equals((Object)X509Extension.subjectAlternativeName) || oid.equals((Object)X509Extension.issuerAlternativeName)) {
                    throw new CertPathValidatorException("Proxy violation: no Subject or Issuer Alternative Name");
                }
                if (oid.equals((Object)X509Extension.basicConstraints)) {
                    BasicConstraints basicExt = CertificateUtil.getBasicConstraints(proxyExtension);
                    if (!basicExt.isCA()) continue;
                    throw new CertPathValidatorException("Proxy violation: Basic Constraint CA is set to true");
                }
                if (!oid.equals((Object)X509Extension.keyUsage)) continue;
                proxyKeyUsage = proxyExtension;
                this.checkKeyUsage(issuer, proxyExtension);
            }
        }
        if ((extensions = issuer.getExtensions()) != null) {
            e = extensions.oids();
            while (e.hasMoreElements()) {
                oid = (DERObjectIdentifier)e.nextElement();
                proxyExtension = extensions.getExtension(oid);
                this.checkExtension(oid, proxyExtension, proxyKeyUsage);
            }
        }
    }

    private void checkKeyUsage(TBSCertificateStructure issuer, X509Extension proxyExtension) throws IOException, CertPathValidatorException {
        EnumSet<KeyUsage> keyUsage = CertificateUtil.getKeyUsage(proxyExtension);
        if (keyUsage.contains((Object)KeyUsage.NON_REPUDIATION) || keyUsage.contains((Object)KeyUsage.KEY_CERTSIGN)) {
            throw new CertPathValidatorException("Proxy violation: Key usage is asserted.");
        }
    }

    private void checkExtension(DERObjectIdentifier oid, X509Extension proxyExtension, X509Extension proxyKeyUsage) throws CertPathValidatorException {
        if (oid.equals((Object)X509Extension.keyUsage)) {
            if (proxyKeyUsage == null) {
                throw new CertPathValidatorException("Proxy violation: Issuer has key usage, but proxy does not");
            }
            if (proxyExtension.isCritical() && !proxyKeyUsage.isCritical()) {
                throw new CertPathValidatorException("Proxy voilation: issuer key usage is critical, but proxy certificate's is not");
            }
        }
    }

    public X509Certificate getIdentityCertificate() {
        return this.identityCert;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setIdentityCert(X509Certificate identityCert) {
        this.identityCert = identityCert;
    }

    public boolean isRejectLimitedProxy() {
        return this.rejectLimitedProxy;
    }
}

