/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateIOUtil;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTrustAnchor
extends AbstractResourceSecurityWrapper<TrustAnchor> {
    public ResourceTrustAnchor(String fileName) throws ResourceStoreException {
        super(false);
        this.init(this.globusResolver.getResource(fileName));
    }

    public ResourceTrustAnchor(boolean inMemory, GlobusResource globusResource) throws ResourceStoreException {
        super(inMemory);
        this.init(globusResource);
    }

    public ResourceTrustAnchor(String fileName, TrustAnchor cachedAnchor) throws ResourceStoreException {
        super(false);
        this.init(this.globusResolver.getResource(fileName), cachedAnchor);
    }

    public ResourceTrustAnchor(boolean inMemory, GlobusResource globusResource, TrustAnchor cachedAnchor) throws ResourceStoreException {
        super(inMemory);
        this.init(globusResource, cachedAnchor);
    }

    public TrustAnchor getTrustAnchor() throws ResourceStoreException {
        return (TrustAnchor)super.getSecurityObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TrustAnchor create(GlobusResource globusResource) throws ResourceStoreException {
        X509Certificate certificate;
        try {
            InputStream inputStream = globusResource.getInputStream();
            try {
                certificate = CertificateLoadUtil.loadCertificate(new BufferedInputStream(inputStream));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (GeneralSecurityException e) {
            throw new ResourceStoreException(e);
        }
        return new TrustAnchor(certificate, null);
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            CertificateIOUtil.writeCertificate(this.getTrustAnchor().getTrustedCert(), this.globusResource.getFile());
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }
}

