/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ContainsAllOperation
extends CollectionKeyBasedOperation {
    Set<Data> dataSet;

    public ContainsAllOperation() {
    }

    public ContainsAllOperation(CollectionProxyId proxyId, Data dataKey, Set<Data> dataSet) {
        super(proxyId, dataKey);
        this.dataSet = dataSet;
    }

    @Override
    public void run() throws Exception {
        CollectionWrapper wrapper = this.getCollectionWrapper();
        if (wrapper != null) {
            HashSet<CollectionRecord> recordSet = new HashSet<CollectionRecord>(this.dataSet.size());
            for (Data data : this.dataSet) {
                recordSet.add(new CollectionRecord(this.isBinary() ? data : this.toObject(data)));
            }
            this.response = wrapper.getCollection().containsAll(recordSet);
        } else {
            this.response = false;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.dataSet.size());
        for (Data data : this.dataSet) {
            data.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.dataSet = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataSet.add(data);
        }
    }

    @Override
    public int getId() {
        return 6;
    }
}

