/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.UseWhenStaticContext;
import net.sf.saxon.sxpath.SimpleContainer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class UseWhenFilter
extends ProxyReceiver {
    private StartTagBuffer startTag;
    private int depthOfHole = 0;
    private boolean emptyStylesheetElement = false;
    private Stack<String> defaultNamespaceStack = new Stack();
    private DateTimeValue currentDateTime = DateTimeValue.getCurrentDateTime(null);
    private Compilation compilation;
    private Stack<String> systemIdStack = new Stack();
    private Stack<URI> baseUriStack = new Stack();
    private NestedIntegerValue precedence;
    private int importCount = 0;

    public UseWhenFilter(Compilation compilation, Receiver next, NestedIntegerValue precedence) {
        super(next);
        this.compilation = compilation;
        this.precedence = precedence;
    }

    public void setStartTagBuffer(StartTagBuffer startTag) {
        this.startTag = startTag;
    }

    public void open() throws XPathException {
        this.nextReceiver.open();
        try {
            String sysId = this.getSystemId();
            if (sysId == null) {
                sysId = "";
            }
            this.systemIdStack.push(sysId);
            this.baseUriStack.push(new URI(sysId));
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid URI for stylesheet: " + this.getSystemId());
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        boolean inXsltNamespace = elemName.hasURI("http://www.w3.org/1999/XSL/Transform");
        String stdAttUri = inXsltNamespace ? "" : "http://www.w3.org/1999/XSL/Transform";
        this.defaultNamespaceStack.push(this.startTag.getAttribute(stdAttUri, "xpath-default-namespace"));
        if (this.emptyStylesheetElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            URI baseUri;
            LocationProvider lp;
            block54: {
                boolean isStylesheetElement;
                String baseUriAtt;
                lp = this.getPipelineConfiguration().getLocationProvider();
                String systemId = lp.getSystemId(locationId);
                if (systemId == null) {
                    systemId = "";
                }
                if ((baseUriAtt = this.startTag.getAttribute("http://www.w3.org/XML/1998/namespace", "base")) != null) {
                    if (systemId.equals(this.systemIdStack.peek())) {
                        baseUri = this.baseUriStack.peek().resolve(baseUriAtt);
                    } else {
                        try {
                            baseUri = new URI(systemId).resolve(baseUriAtt);
                        }
                        catch (URISyntaxException e) {
                            throw new XPathException("Invalid URI for stylesheet entity: " + systemId);
                        }
                    }
                } else if (systemId.equals(this.systemIdStack.peek())) {
                    baseUri = this.baseUriStack.peek();
                } else {
                    try {
                        baseUri = new URI(systemId);
                    }
                    catch (URISyntaxException e) {
                        throw new XPathException("Invalid URI for stylesheet entity: " + systemId);
                    }
                }
                this.baseUriStack.push(baseUri);
                this.systemIdStack.push(systemId);
                DecimalValue cVersion = this.compilation.getVersion();
                if (inXsltNamespace && (cVersion == null || DecimalValue.THREE.equals(cVersion))) {
                    AttributeCollection atts = this.startTag.getAllAttributes();
                    for (int a = 0; a < atts.getLength(); ++a) {
                        String local = atts.getLocalName(a);
                        if (!local.startsWith("_") || !atts.getURI(a).equals("") || local.length() < 2) continue;
                        if (cVersion == null) {
                            cVersion = DecimalValue.THREE;
                            this.compilation.setVersion(cVersion);
                        }
                        String value = atts.getValue(a);
                        String newValue = this.processShadowAttribute(value, baseUri.toString(), lp.getLineNumber(locationId));
                        String plainName = local.substring(1);
                        NoNamespaceName newName = new NoNamespaceName(plainName);
                        int index = atts.getIndex("", plainName);
                        if (index == -1) {
                            index = a;
                        }
                        ((AttributeCollectionImpl)atts).setAttribute(index, newName, BuiltInAtomicType.UNTYPED_ATOMIC, newValue, atts.getLocationId(a), 0);
                    }
                }
                String useWhen = this.startTag.getAttribute(stdAttUri, "use-when");
                boolean bl = isStylesheetElement = inXsltNamespace && (elemName.getLocalPart().equals("stylesheet") || elemName.getLocalPart().equals("transform") || elemName.getLocalPart().equals("package"));
                if (this.compilation.getVersion() == null || this.compilation.getVersion().equals(DecimalValue.ZERO)) {
                    String version;
                    if (isStylesheetElement) {
                        version = this.startTag.getAttribute("", "version");
                        this.processVersionAttribute(version);
                    } else {
                        version = this.startTag.getAttribute("http://www.w3.org/1999/XSL/Transform", "version");
                        this.processVersionAttribute(version);
                    }
                }
                if (useWhen != null) {
                    try {
                        boolean use = this.evaluateUseWhen(useWhen, lp.getLineNumber(locationId), baseUri.toString());
                        if (use) break block54;
                        if (isStylesheetElement) {
                            this.emptyStylesheetElement = true;
                            break block54;
                        }
                        this.depthOfHole = 1;
                        return;
                    }
                    catch (XPathException e) {
                        XPathException err = this.createXPathException("Error in use-when expression. " + e.getMessage(), e.getErrorCodeLocalPart(), lp, locationId);
                        err.setErrorCodeQName(e.getErrorCodeQName());
                        throw err;
                    }
                }
            }
            if (inXsltNamespace && DecimalValue.THREE.equals(this.compilation.getVersion())) {
                boolean isVariable = elemName.getLocalPart().equals("variable");
                boolean isParam = elemName.getLocalPart().equals("param");
                String staticStr = Whitespace.trim(this.startTag.getAttribute("", "static"));
                if ((isVariable || isParam) && this.defaultNamespaceStack.size() == 2 && "yes".equals(staticStr) || "true".equals(staticStr) || "1".equals(staticStr)) {
                    boolean isSupplied;
                    StructuredQName varName;
                    String nameStr = this.startTag.getAttribute("", "name");
                    String asStr = this.startTag.getAttribute("", "as");
                    String requiredStr = Whitespace.trim(this.startTag.getAttribute("", "required"));
                    boolean isRequired = "yes".equals(requiredStr) || "true".equals(requiredStr) || "1".equals(requiredStr);
                    UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
                    staticContext.setBaseURI(baseUri.toString());
                    SequenceType requiredType = SequenceType.ANY_SEQUENCE;
                    if (asStr != null) {
                        XPathParser parser = new XPathParser();
                        requiredType = parser.parseSequenceType(asStr, staticContext);
                    }
                    try {
                        varName = StructuredQName.fromLexicalQName(nameStr, false, true, this.startTag);
                    }
                    catch (XPathException err) {
                        throw this.createXPathException("Invalid variable name:" + nameStr + ". " + err.getMessage(), err.getErrorCodeLocalPart(), lp, locationId);
                    }
                    boolean bl = isSupplied = isParam && this.compilation.getCompilerInfo().getParameters().containsKey(varName);
                    if (isParam) {
                        if (isRequired && !isSupplied) {
                            throw this.createXPathException("No value was supplied for the required static parameter $" + varName.getDisplayName(), "XTDE0050", lp, locationId);
                        }
                        if (isSupplied) {
                            Sequence suppliedValue = this.compilation.getCompilerInfo().getParameters().convertParameterValue(varName, requiredType, true, staticContext.makeEarlyEvaluationContext());
                            this.compilation.declareStaticVariable(varName, SequenceTool.toGroundedValue(suppliedValue), this.precedence);
                        }
                    }
                    if (isVariable || !isSupplied) {
                        Sequence value;
                        String selectStr = this.startTag.getAttribute("", "select");
                        if (selectStr == null) {
                            if (isVariable) {
                                throw this.createXPathException("The select attribute is required for a static global variable", "XTSE0010", lp, locationId);
                            }
                            value = EmptySequence.getInstance();
                            this.compilation.declareStaticVariable(varName, EmptySequence.getInstance(), this.precedence);
                        } else {
                            try {
                                value = this.evaluateStatic(selectStr, lp.getLineNumber(locationId), staticContext);
                            }
                            catch (XPathException e) {
                                throw this.createXPathException("Error in " + elemName.getLocalPart() + " expression. " + e.getMessage(), e.getErrorCodeLocalPart(), lp, locationId);
                            }
                        }
                        RoleLocator role = new RoleLocator(3, varName, 0);
                        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                        value = th.applyFunctionConversionRules(value, requiredType, role, new SimpleContainer(this.compilation.getPackageData()));
                        try {
                            this.compilation.declareStaticVariable(varName, SequenceTool.toGroundedValue(value), this.precedence);
                        }
                        catch (XPathException e) {
                            throw this.createXPathException(e.getMessage(), e.getErrorCodeLocalPart(), lp, locationId);
                        }
                    }
                }
            }
            if (inXsltNamespace) {
                boolean isInclude = elemName.getLocalPart().equals("include");
                boolean isImport = elemName.getLocalPart().equals("import");
                if (isInclude || isImport) {
                    Map<DocumentURI, DocumentInfo> map;
                    Source source;
                    String href = Whitespace.trim(this.startTag.getAttribute("", "href"));
                    if (href == null) {
                        throw new XPathException("Missing href attribute on " + elemName.getDisplayName(), "XPST0020");
                    }
                    URIResolver resolver = this.compilation.getCompilerInfo().getURIResolver();
                    String baseUriStr = baseUri.toString();
                    DocumentURI key = DocumentFn.computeDocumentKey(href, baseUriStr, resolver);
                    try {
                        source = resolver.resolve(href, baseUriStr);
                    }
                    catch (TransformerException e) {
                        throw XPathException.makeXPathException(e);
                    }
                    if (source == null) {
                        source = this.getConfiguration().getSystemURIResolver().resolve(href, baseUriStr);
                    }
                    if ((map = this.compilation.getStylesheetModules()).containsKey(key)) {
                        NodeInfo next;
                        DocumentImpl module = (DocumentImpl)map.get(key);
                        ElementImpl outer = module.getDocumentElement();
                        AxisIterator top = outer.iterateAxis((byte)3, NodeKindTest.ELEMENT);
                        while ((next = top.next()) != null) {
                            String staticStr = Whitespace.trim(next.getAttributeValue("", "static"));
                            if (next.getURI().equals("http://www.w3.org/1999/XSL/Transform") && (next.getLocalPart().equals("param") || next.getLocalPart().equals("variable")) && !"yes".equals(staticStr) && !"true".equals(staticStr) && !"1".equals(staticStr)) continue;
                        }
                    } else {
                        NestedIntegerValue newPrecedence = this.precedence;
                        if (isImport) {
                            newPrecedence = this.precedence.getStem().append(this.precedence.getLeaf() - 1).append(2 * ++this.importCount);
                        }
                        try {
                            DocumentImpl includedDoc = StylesheetModule.loadStylesheetModule(source, false, this.compilation, newPrecedence);
                            map.put(key, includedDoc);
                        }
                        catch (XPathException e) {
                            e.setLocator(this.getPipelineConfiguration().getSourceLocation(locationId));
                            e.maybeSetErrorCode("XTSE0165");
                            if ("XTSE0180".equals(e.getErrorCodeLocalPart()) && isImport) {
                                e.setErrorCode("XTSE0210");
                            }
                            throw e;
                        }
                    }
                }
            }
            this.nextReceiver.startElement(elemName, typeCode, locationId, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    private void processVersionAttribute(String version) throws XPathException {
        if (version != null) {
            ConversionResult cr = DecimalValue.makeDecimalValue(version, true);
            if (cr instanceof ValidationFailure) {
                throw new XPathException("Invalid version number: " + version, "XTSE0110");
            }
            this.compilation.setVersion((DecimalValue)cr.asAtomic());
        }
    }

    private String processShadowAttribute(String expression, String baseUri, int lineNumber) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        this.setNamespaceBindings(staticContext);
        Expression expr = AttributeValueTemplate.make(expression, lineNumber, staticContext, staticContext);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext();
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.evaluateAsString(dynamicContext).toString();
    }

    public XPathException createXPathException(String message, String errorCode, LocationProvider lp, int locationId) throws XPathException {
        XPathException err = new XPathException(message);
        err.setErrorCode(errorCode);
        err.setIsStaticError(true);
        ExpressionLocation loc = new ExpressionLocation();
        loc.setSystemId(lp.getSystemId(locationId));
        loc.setLineNumber(lp.getLineNumber(locationId));
        err.setLocator(loc);
        this.getPipelineConfiguration().getErrorListener().fatalError(err);
        err.setHasBeenReported(true);
        return err;
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.namespace(namespaceBinding, properties);
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (!(this.depthOfHole != 0 || attName.getLocalPart().startsWith("_") && attName.hasURI(""))) {
            this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        this.defaultNamespaceStack.pop();
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.systemIdStack.pop();
            this.baseUriStack.pop();
            this.nextReceiver.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) {
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
    }

    public boolean evaluateUseWhen(String expression, int locationId, String baseUri) throws XPathException {
        UseWhenStaticContext staticContext = new UseWhenStaticContext(this.compilation, this.startTag);
        staticContext.setBaseURI(baseUri);
        LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, lp.getLineNumber(locationId), null);
        expr.setContainer(staticContext);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.allocateSlots(expression, expr);
        XPathContext dynamicContext = this.makeDynamicContext();
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return expr.effectiveBooleanValue(dynamicContext);
    }

    private SlotManager allocateSlots(String expression, Expression expr) {
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        if (expression.indexOf(36) >= 0) {
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        }
        return stackFrameMap;
    }

    private void setNamespaceBindings(UseWhenStaticContext staticContext) {
        staticContext.setDefaultElementNamespace("");
        for (int i = this.defaultNamespaceStack.size() - 1; i >= 0; --i) {
            String uri = (String)this.defaultNamespaceStack.get(i);
            if (uri == null) continue;
            staticContext.setDefaultElementNamespace(uri);
            break;
        }
    }

    private Expression typeCheck(Expression expr, UseWhenStaticContext staticContext) throws XPathException {
        ItemType contextItemType = Type.ITEM_TYPE;
        ContextItemStaticInfo cit = new ContextItemStaticInfo(contextItemType, true);
        ExpressionVisitor visitor = ExpressionVisitor.make(staticContext);
        expr = visitor.typeCheck(expr, cit);
        return expr;
    }

    private XPathContext makeDynamicContext() throws XPathException {
        Controller controller = new Controller(this.getConfiguration());
        controller.setURIResolver(new URIPreventer());
        controller.setCurrentDateTime(this.currentDateTime);
        XPathContextMajor dynamicContext = controller.newXPathContext();
        dynamicContext = dynamicContext.newCleanContext();
        return dynamicContext;
    }

    public Sequence evaluateStatic(String expression, int locationId, UseWhenStaticContext staticContext) throws XPathException {
        LocationProvider lp = this.getPipelineConfiguration().getLocationProvider();
        this.setNamespaceBindings(staticContext);
        Expression expr = ExpressionTool.make(expression, staticContext, staticContext, 0, 0, lp.getLineNumber(locationId), null);
        expr.setContainer(staticContext);
        expr = this.typeCheck(expr, staticContext);
        SlotManager stackFrameMap = this.getPipelineConfiguration().getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
        XPathContext dynamicContext = this.makeDynamicContext();
        ((XPathContextMajor)dynamicContext).openStackFrame(stackFrameMap);
        return SequenceExtent.makeSequenceExtent(expr.iterate(dynamicContext));
    }

    private static class URIPreventer
    implements URIResolver {
        private URIPreventer() {
        }

        public Source resolve(String href, String base) throws XPathException {
            throw new XPathException("No external documents are available within an [xsl]use-when expression");
        }
    }
}

