/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

public class Config {
    private String serverUrl;
    private String realm;
    private String username;
    private String password;
    private String clientId;
    private String clientSecret;
    private String grantType;

    public Config(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        this(serverUrl, realm, username, password, clientId, clientSecret, "password");
    }

    public Config(String serverUrl, String realm, String username, String password, String clientId, String clientSecret, String grantType) {
        this.serverUrl = serverUrl;
        this.realm = realm;
        this.username = username;
        this.password = password;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.grantType = grantType;
        Config.checkGrantType(grantType);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isPublicClient() {
        return this.clientSecret == null;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
        Config.checkGrantType(grantType);
    }

    public static void checkGrantType(String grantType) {
        if (grantType != null && !"password".equals(grantType) && !"client_credentials".equals(grantType)) {
            throw new IllegalArgumentException("Unsupported grantType: " + grantType + " (only " + "password" + " and " + "client_credentials" + " are supported)");
        }
    }
}

