/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.SecuritySessionUtils;
import eu.unicore.security.wsutil.client.Configurable;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.SessionIDProvider;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class SessionIDInHandler
extends AbstractSoapInterceptor
implements Configurable {
    private static final Logger log = Log.getLogger("unicore.client", SessionIDInHandler.class);
    private static final ThreadLocal<String> currentSessionID = new ThreadLocal();
    private IClientConfiguration configuration;

    public SessionIDInHandler() {
        super("invoke");
    }

    public synchronized void handleMessage(SoapMessage message) {
        String lifetime;
        log.trace("SessionIDInHandler invoked");
        currentSessionID.remove();
        Header header = message.getHeader(SecuritySessionUtils.headerQName);
        if (header == null) {
            return;
        }
        Element hdr = (Element)header.getObject();
        Element id = DOMUtils.getFirstChildWithName((Element)hdr, (QName)SecuritySessionUtils.idQName);
        String sessionID = id != null ? id.getTextContent() : null;
        Element lt = DOMUtils.getFirstChildWithName((Element)hdr, (QName)SecuritySessionUtils.ltQName);
        String string = lifetime = lt != null ? lt.getTextContent() : null;
        if (sessionID != null && lifetime != null) {
            log.debug("Server returned security session id=" + sessionID + " lifetime=" + lifetime);
            String targetUrl = (String)message.getContextualProperty("unicore-security-session-target-url");
            SessionIDProvider idProvider = this.configuration.getSessionIDProvider();
            if (idProvider != null) {
                log.debug("Registering session in the session provider");
                idProvider.registerSession(sessionID, targetUrl, Long.valueOf(lifetime), this.configuration);
                currentSessionID.set(sessionID);
            }
        }
    }

    public static String getSessionID() {
        return currentSessionID.get();
    }

    @Override
    public void configure(IClientConfiguration properties) {
        this.configuration = properties;
    }
}

