/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.util.Log;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class ConditionalGetServerInHandler
extends AbstractSoapInterceptor {
    private static final Logger logger = Log.getLogger("unicore.services", ConditionalGetServerInHandler.class);
    private static final ThreadLocal<String> etag = new ThreadLocal();
    private static final ThreadLocal<String> lastModified = new ThreadLocal();
    public static final String CG_HEADER_NS = "http://www.unicore.eu/unicore/ws";
    public static final String CG_HEADER = "ConditionalGet";
    private static final String ETAG_HEADER = "IfNoneMatch";
    private static final String LASTMODIFIED_HEADER = "IfModifiedSince";
    private static final QName headerQName = new QName("http://www.unicore.eu/unicore/ws", "ConditionalGet");
    private static final QName inmQName = new QName("http://www.unicore.eu/unicore/ws", "IfNoneMatch");
    private static final QName imsQName = new QName("http://www.unicore.eu/unicore/ws", "IfModifiedSince");

    public ConditionalGetServerInHandler() {
        super("pre-invoke");
    }

    public void handleMessage(SoapMessage ctx) {
        String ims;
        Header header = ctx.getHeader(headerQName);
        if (header == null) {
            return;
        }
        etag.remove();
        lastModified.remove();
        Element hdr = (Element)header.getObject();
        Element inmEl = DOMUtils.getFirstChildWithName((Element)hdr, (QName)inmQName);
        String inm = inmEl != null ? inmEl.getTextContent() : null;
        Element imsEl = DOMUtils.getFirstChildWithName((Element)hdr, (QName)imsQName);
        String string = ims = imsEl != null ? imsEl.getTextContent() : null;
        if (logger.isDebugEnabled()) {
            logger.debug("Extracted IfNoneMatch=" + inm + " IfModifiedSince=" + ims);
        }
        etag.set(inm);
        lastModified.set(ims);
    }

    public static String getIfNoneMatch() {
        return etag.get();
    }

    public static String getIfModifiedSince() {
        return lastModified.get();
    }
}

