/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.utils.deployment.Axis2ServiceRegistry;

public class OSGiAxis2ServiceDeployer
implements Deployer,
BundleListener {
    private BundleContext context;
    private Axis2ServiceRegistry registry;

    public OSGiAxis2ServiceDeployer(ConfigurationContext configCtx, BundleContext context) {
        this.context = context;
        this.registry = new Axis2ServiceRegistry(configCtx);
    }

    public void registerBundleListener() {
        this.context.addBundleListener((BundleListener)this);
    }

    public void init(ConfigurationContext configCtx) {
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        for (Bundle bundle : this.context.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.registry.register(bundle);
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
    }

    public void cleanup() throws DeploymentException {
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 2: {
                if (this.context.getBundle() == bundle) break;
                this.registry.register(event.getBundle());
                break;
            }
            case 4: {
                if (this.context.getBundle() == bundle) break;
                this.registry.unregister(event.getBundle());
            }
        }
    }
}

