/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.airavata.security.UserStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordDigester {
    protected static Logger log = LoggerFactory.getLogger(PasswordDigester.class);
    private String hashMethod;

    public PasswordDigester(String method) throws UserStoreException {
        this.hashMethod = method;
        this.validateHashAlgorithm();
    }

    public String getPasswordHashValue(String password) throws UserStoreException {
        if (this.hashMethod.equals("PLAINTEXT")) {
            return password;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.hashMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UserStoreException("Error creating message digest with hash algorithm - " + this.hashMethod, e);
        }
        try {
            return new String(messageDigest.digest(password.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new UserStoreException("Unable to create password digest", e);
        }
    }

    private void validateHashAlgorithm() throws UserStoreException {
        if (this.hashMethod == null) {
            log.warn("Password hash method is not configured. Setting default to plaintext.");
            this.hashMethod = "PLAINTEXT";
        } else if (!this.hashMethod.equals("PLAINTEXT")) {
            try {
                MessageDigest.getInstance(this.hashMethod);
            }
            catch (NoSuchAlgorithmException e) {
                String msg = "Invalid hash algorithm - " + this.hashMethod + ". Use Java style way of specifying hash algorithm. E.g :- MD5";
                log.error(msg);
                throw new UserStoreException(msg, e);
            }
        }
    }

    public String getHashMethod() {
        return this.hashMethod;
    }

    public void setHashMethod(String hashMethod) {
        this.hashMethod = hashMethod;
    }
}

