/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public final class Bindery {
    private Sequence[] globals;
    private long[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;
    private Map<GlobalVariable, Set<GlobalVariable>> dependencies = new HashMap<GlobalVariable, Set<GlobalVariable>>();
    private boolean applyConversionRules = true;

    public void allocateGlobals(SlotManager map) {
        this.globalVariableMap = map;
        int n = map.getNumberOfVariables() + 1;
        this.globals = new Sequence[n];
        this.busy = new long[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = null;
            this.busy[i] = -1L;
        }
    }

    public boolean areGlobalsInitialized() {
        return this.globals != null;
    }

    public void setApplyFunctionConversionRulesToExternalVariables(boolean convert) {
        this.applyConversionRules = convert;
    }

    public boolean isApplyFunctionConversionRulesToExternalVariables() {
        return this.applyConversionRules;
    }

    public void defineGlobalParameters(GlobalParameterSet params) {
        this.globalParameters = params;
        Arrays.fill(this.globals, null);
    }

    public boolean useGlobalParameter(StructuredQName qName, int slot, SequenceType requiredType, XPathContext context) throws XPathException {
        Item next;
        if (this.globals != null && this.globals[slot] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Sequence val = this.globalParameters.convertParameterValue(qName, requiredType, this.applyConversionRules, context);
        if (val == null) {
            return false;
        }
        Configuration config = context.getConfiguration();
        SequenceIterator iter = val.iterate();
        while ((next = iter.next()) != null) {
            if (!(next instanceof NodeInfo) || config.isCompatible(((NodeInfo)next).getConfiguration())) continue;
            throw new XPathException("A node supplied in a global parameter must be built using the same Configuration that was used to compile the stylesheet or query", "SXXP0004");
        }
        if (val instanceof DocumentInfo) {
            String systemId = ((DocumentInfo)val).getSystemId();
            try {
                if (systemId != null && new URI(systemId).isAbsolute()) {
                    Controller controller = context.getController();
                    assert (controller != null);
                    DocumentPool pool = controller.getDocumentPool();
                    if (pool.find(systemId) == null) {
                        pool.add((DocumentInfo)val, systemId);
                    }
                }
            }
            catch (URISyntaxException err) {
                // empty catch block
            }
        }
        if (!(val instanceof GroundedValue)) {
            val = new SequenceExtent(val.iterate());
        }
        this.globals[slot] = val;
        return true;
    }

    public void setGlobalVariable(GlobalVariable binding, Sequence value) {
        this.globals[binding.getBinderySlotNumber()] = value;
    }

    public boolean setExecuting(GlobalVariable binding) throws XPathException {
        long thisThread = Thread.currentThread().getId();
        int slot = binding.getBinderySlotNumber();
        long busyThread = this.busy[slot];
        if (busyThread != -1L) {
            if (busyThread == thisThread) {
                throw new XPathException.Circularity("Circular definition of variable " + binding.getVariableQName().getDisplayName());
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(20 * i);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.busy[slot] != -1L) continue;
                return false;
            }
            return true;
        }
        this.busy[slot] = thisThread;
        return true;
    }

    public void setNotExecuting(GlobalVariable binding) {
        int slot = binding.getBinderySlotNumber();
        this.busy[slot] = -1L;
    }

    public synchronized Sequence saveGlobalVariableValue(GlobalVariable binding, Sequence value) {
        int slot = binding.getBinderySlotNumber();
        if (this.globals[slot] != null) {
            return this.globals[slot];
        }
        this.busy[slot] = -1L;
        this.globals[slot] = value;
        return value;
    }

    public Sequence getGlobalVariableValue(GlobalVariable binding) {
        return this.globals[binding.getBinderySlotNumber()];
    }

    public Sequence getGlobalVariable(int slot) {
        return this.globals[slot];
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public Sequence[] getGlobalVariables() {
        return this.globals;
    }

    public synchronized void registerDependency(GlobalVariable one, GlobalVariable two) throws XPathException {
        Set<GlobalVariable> existingDependencies;
        if (one == two) {
            throw new XPathException.Circularity("Circular dependency among global variables: " + one.getVariableQName().getDisplayName() + " depends on its own value");
        }
        Set<GlobalVariable> transitiveDependencies = this.dependencies.get(two);
        if (transitiveDependencies != null) {
            if (transitiveDependencies.contains(one)) {
                throw new XPathException.Circularity("Circular dependency among variables: " + one.getVariableQName().getDisplayName() + " depends on the value of " + two.getVariableQName().getDisplayName() + ", which depends directly or indirectly on the value of " + one.getVariableQName().getDisplayName());
            }
            for (GlobalVariable var : transitiveDependencies) {
                this.registerDependency(one, var);
            }
        }
        if ((existingDependencies = this.dependencies.get(one)) == null) {
            existingDependencies = new HashSet<GlobalVariable>();
            this.dependencies.put(one, existingDependencies);
        }
        existingDependencies.add(two);
    }
}

