/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.IOException;
import org.fontbox.afm.FontMetric;
import org.fontbox.util.BoundingBox;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.font.PDFontDescriptor;

public class PDFontDescriptorAFM
extends PDFontDescriptor {
    private FontMetric afm;

    public PDFontDescriptorAFM(FontMetric afmFile) {
        this.afm = afmFile;
    }

    public String getFontName() {
        return this.afm.getFontName();
    }

    public void setFontName(String fontName) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public String getFontFamily() {
        return this.afm.getFamilyName();
    }

    public void setFontFamily(String fontFamily) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getFontWeight() {
        String weight = this.afm.getWeight();
        float retval = 500.0f;
        if (weight != null && weight.equalsIgnoreCase("bold")) {
            retval = 900.0f;
        } else if (weight != null && weight.equalsIgnoreCase("light")) {
            retval = 100.0f;
        }
        return retval;
    }

    public void setFontWeight(float fontWeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public String getFontStretch() {
        return null;
    }

    public void setFontStretch(String fontStretch) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public int getFlags() {
        return this.afm.isFixedPitch() ? 1 : 0;
    }

    public void setFlags(int flags) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public PDRectangle getFontBoundingBox() {
        BoundingBox box = this.afm.getFontBBox();
        PDRectangle retval = null;
        if (box != null) {
            retval = new PDRectangle(box);
        }
        return retval;
    }

    public void setFontBoundingBox(PDRectangle rect) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getItalicAngle() {
        return this.afm.getItalicAngle();
    }

    public void setItalicAngle(float angle) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getAscent() {
        return this.afm.getAscender();
    }

    public void setAscent(float ascent) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getDescent() {
        return this.afm.getDescender();
    }

    public void setDescent(float descent) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getLeading() {
        return 0.0f;
    }

    public void setLeading(float leading) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getCapHeight() {
        return this.afm.getCapHeight();
    }

    public void setCapHeight(float capHeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getXHeight() {
        return this.afm.getXHeight();
    }

    public void setXHeight(float xHeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getStemV() {
        return 0.0f;
    }

    public void setStemV(float stemV) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getStemH() {
        return 0.0f;
    }

    public void setStemH(float stemH) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getAverageWidth() throws IOException {
        return this.afm.getAverageCharacterWidth();
    }

    public void setAverageWidth(float averageWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getMaxWidth() {
        return 0.0f;
    }

    public void setMaxWidth(float maxWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getMissingWidth() {
        return 0.0f;
    }

    public void setMissingWidth(float missingWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public String getCharSet() {
        return this.afm.getCharacterSet();
    }

    public void setCharacterSet(String charSet) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }
}

