/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.config.CompassSettings;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

public class TransactionFactoryFactory {
    private static final Log log = LogFactory.getLog(TransactionFactoryFactory.class);

    public static TransactionFactory createTransactionFactory(Compass compass, CompassSettings settings) {
        TransactionFactory transactionFactory = (TransactionFactory)settings.getSettingAsInstance("compass.transaction.factory", LocalTransactionFactory.class.getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transaction factory [" + transactionFactory + "]"));
        }
        transactionFactory.configure(compass, settings);
        return transactionFactory;
    }

    public static LocalTransactionFactory createLocalTransactionFactory(Compass compass, CompassSettings settings) {
        LocalTransactionFactory localTransactionFactory = new LocalTransactionFactory();
        localTransactionFactory.configure(compass, settings);
        return localTransactionFactory;
    }
}

