/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.xsem;

import java.io.Reader;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.converter.xsem.XmlContentConverterUtils;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.XmlObject;

public class PoolXmlContentConverterWrapper
implements XmlContentConverter,
CompassConfigurable {
    private CompassSettings settings;
    private int initialPoolSize;
    private int maxPoolSize;
    private transient XmlContentConverter[] pool;
    private int nextAvailable = 0;
    private final Object mutex = new Object();

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
        this.initialPoolSize = settings.getSettingAsInt("xmlContentConverter.minPoolSize", 10);
        this.maxPoolSize = settings.getSettingAsInt("xmlContentConverter.maxPoolSize", 30);
        XmlContentConverter converter = this.fetchFromPool();
        this.putInPool(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXml(XmlObject xmlObject) throws ConversionException {
        XmlContentConverter converter = this.fetchFromPool();
        try {
            String string = converter.toXml(xmlObject);
            return string;
        }
        finally {
            this.putInPool(converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        XmlContentConverter converter = this.fetchFromPool();
        try {
            AliasedXmlObject aliasedXmlObject = converter.fromXml(alias, xml);
            return aliasedXmlObject;
        }
        finally {
            this.putInPool(converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlContentConverter fetchFromPool() {
        XmlContentConverter result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new XmlContentConverter[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(XmlContentConverterUtils.createXmlContentConverter(this.settings));
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new ConversionException("Interrupted whilst waiting for a free item in the pool", e);
                }
            }
            result = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (result == null) {
            result = XmlContentConverterUtils.createXmlContentConverter(this.settings);
            this.putInPool(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(XmlContentConverter converter) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = converter;
            this.mutex.notify();
        }
    }
}

