/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.logging.appenders;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.logging.appenders.CircularBuffer;

public class MemoryAppender
extends AppenderSkeleton {
    private CircularBuffer circularBuffer;
    private int bufferSize = -1;

    public MemoryAppender() {
    }

    public MemoryAppender(CircularBuffer circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    @Override
    protected void append(LoggingEvent loggingEvent) {
        if (this.circularBuffer != null) {
            this.circularBuffer.append(loggingEvent);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public CircularBuffer getCircularQueue() {
        return this.circularBuffer;
    }

    public void setCircularBuffer(CircularBuffer circularBuffer) {
        this.circularBuffer = circularBuffer;
    }

    @Override
    public void activateOptions() {
        if (this.bufferSize < 0) {
            if (this.circularBuffer == null) {
                this.circularBuffer = new CircularBuffer();
            }
        } else {
            this.circularBuffer = new CircularBuffer(this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

