/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.DescriptionConstants;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.ParameterObserver;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AxisDescription
implements ParameterInclude,
DescriptionConstants {
    protected AxisDescription parent = null;
    private ParameterInclude parameterInclude;
    private PolicyInclude policyInclude = null;
    private PolicySubject policySubject = null;
    private Map<Object, AxisDescription> children;
    protected Map<String, AxisModule> engagedModules;
    protected List<ParameterObserver> parameterObservers = null;
    private OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private OMNode documentation;
    private static Log log = LogFactory.getLog(AxisDescription.class);
    static Collection<AxisModule> NULL_MODULES = new ArrayList<AxisModule>(0);

    public AxisDescription() {
        this.parameterInclude = new ParameterIncludeImpl();
        this.children = new ConcurrentHashMap<Object, AxisDescription>();
        this.policySubject = new PolicySubject();
    }

    public void addParameterObserver(ParameterObserver observer) {
        if (this.parameterObservers == null) {
            this.parameterObservers = new ArrayList<ParameterObserver>();
        }
        this.parameterObservers.add(observer);
    }

    public void removeParameterObserver(ParameterObserver observer) {
        if (this.parameterObservers != null) {
            this.parameterObservers.remove(observer);
        }
    }

    @Override
    public void addParameter(Parameter param) throws AxisFault {
        if (param == null) {
            return;
        }
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.addParameter(param);
        if (this.parameterObservers != null) {
            Iterator<ParameterObserver> i$ = this.parameterObservers.iterator();
            while (i$.hasNext()) {
                ParameterObserver parameterObserver;
                ParameterObserver observer = parameterObserver = i$.next();
                observer.parameterChanged(param.getName(), param.getValue());
            }
        }
    }

    public void addParameter(String name, Object value) throws AxisFault {
        this.addParameter(new Parameter(name, value));
    }

    @Override
    public void removeParameter(Parameter param) throws AxisFault {
        this.parameterInclude.removeParameter(param);
    }

    @Override
    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    @Override
    public Parameter getParameter(String name) {
        Parameter parameter = this.parameterInclude.getParameter(name);
        if (parameter != null) {
            parameter.setEditable(true);
            return parameter;
        }
        if (this.parent != null) {
            parameter = this.parent.getParameter(name);
            if (parameter != null) {
                parameter.setEditable(false);
            }
            return parameter;
        }
        return null;
    }

    public Object getParameterValue(String name) {
        Parameter param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        return param.getValue();
    }

    public boolean isParameterTrue(String name) {
        Parameter param = this.getParameter(name);
        return param != null && JavaUtils.isTrue(param.getValue());
    }

    @Override
    public ArrayList<Parameter> getParameters() {
        return this.parameterInclude.getParameters();
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        if (this.parent != null && this.parent.isParameterLocked(parameterName)) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public String getDocumentation() {
        if (this.documentation != null) {
            if (this.documentation instanceof OMText) {
                return ((OMText)this.documentation).getText();
            }
            if (this.documentation instanceof OMElement) {
                StringWriter writer = new StringWriter();
                this.documentation.build();
                try {
                    ((OMElement)this.documentation).serialize((Writer)writer);
                }
                catch (XMLStreamException e) {
                    log.error((Object)e);
                }
                writer.flush();
                return writer.toString();
            }
        }
        return null;
    }

    public OMNode getDocumentationNode() {
        return this.documentation;
    }

    public void setDocumentation(OMNode documentation) {
        this.documentation = documentation;
    }

    public void setDocumentation(String documentation) {
        if (!"".equals(documentation)) {
            this.documentation = this.omFactory.createOMText(documentation);
        }
    }

    public void setParent(AxisDescription parent) {
        this.parent = parent;
    }

    public AxisDescription getParent() {
        return this.parent;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        if (this.policyInclude == null) {
            this.policyInclude = new PolicyInclude(this);
        }
        return this.policyInclude;
    }

    public void addChild(AxisDescription child) {
        if (child.getKey() != null) {
            this.children.put(child.getKey(), child);
        }
    }

    public void addChild(Object key, AxisDescription child) {
        this.children.put(key, child);
    }

    public Iterator<? extends AxisDescription> getChildren() {
        return this.children.values().iterator();
    }

    public AxisDescription getChild(Object key) {
        if (key == null) {
            return null;
        }
        return this.children.get(key);
    }

    public void removeChild(Object key) {
        this.children.remove(key);
    }

    public void applyPolicy(Policy policy) throws AxisFault {
        this.getPolicySubject().clear();
        this.getPolicySubject().attachPolicy(policy);
        this.applyPolicy();
    }

    public void applyPolicy() throws AxisFault {
        AxisConfiguration configuration = this.getAxisConfiguration();
        if (configuration == null) {
            return;
        }
        Policy applicablePolicy = this.getApplicablePolicy(this);
        if (applicablePolicy != null) {
            this.engageModulesForPolicy(applicablePolicy, configuration);
        }
        Iterator<? extends AxisDescription> children = this.getChildren();
        while (children.hasNext()) {
            AxisDescription child = children.next();
            child.applyPolicy();
        }
    }

    private boolean canSupportAssertion(Assertion assertion, List<AxisModule> moduleList) {
        for (AxisModule axisModule : moduleList) {
            Module module = axisModule.getModule();
            if (module == null || module.canSupportAssertion(assertion)) continue;
            log.debug((Object)(axisModule.getName() + " says it can't support " + assertion.getName()));
            return false;
        }
        return true;
    }

    private void engageModulesForPolicy(Policy policy, AxisConfiguration axisConfiguration) throws AxisFault {
        Iterator iterator = policy.getAlternatives();
        if (!iterator.hasNext()) {
            throw new AxisFault("Policy doesn't contain any policy alternatives");
        }
        List assertionList = (List)iterator.next();
        ArrayList<String> namespaceList = new ArrayList<String>();
        ArrayList<AxisModule> modulesToEngage = new ArrayList<AxisModule>();
        for (Object anAssertionList : assertionList) {
            Assertion assertion = (Assertion)anAssertionList;
            String namespaceURI = assertion.getName().getNamespaceURI();
            List<AxisModule> moduleList = axisConfiguration.getModulesForPolicyNamesapce(namespaceURI);
            if (moduleList == null) {
                log.debug((Object)("can't find any module to process " + assertion.getName() + " type assertions"));
                continue;
            }
            if (!this.canSupportAssertion(assertion, moduleList)) {
                throw new AxisFault("atleast one module can't support " + assertion.getName());
            }
            if (namespaceList.contains(namespaceURI)) continue;
            namespaceList.add(namespaceURI);
            modulesToEngage.addAll(moduleList);
        }
        this.engageModulesToAxisDescription(modulesToEngage, this);
    }

    private void engageModulesToAxisDescription(List<AxisModule> moduleList, AxisDescription description) throws AxisFault {
        for (AxisModule aModuleList : moduleList) {
            AxisModule axisModule = aModuleList;
            Module module = axisModule.getModule();
            if (module == null || description.isEngaged(axisModule.getName())) continue;
            description.engageModule(axisModule);
            axisModule.getModule().engageNotify(description);
        }
    }

    public AxisConfiguration getAxisConfiguration() {
        if (this instanceof AxisConfiguration) {
            return (AxisConfiguration)this;
        }
        if (this.parent != null) {
            return this.parent.getAxisConfiguration();
        }
        return null;
    }

    public abstract Object getKey();

    public void engageModule(AxisModule axisModule) throws AxisFault {
        this.engageModule(axisModule, this);
        AxisConfiguration config = this.getAxisConfiguration();
        config.notifyObservers(new AxisEvent(6, this), axisModule);
    }

    public void engageModule(AxisModule axisModule, AxisDescription source) throws AxisFault {
        if (this.engagedModules == null) {
            this.engagedModules = new ConcurrentHashMap<String, AxisModule>();
        }
        String moduleName = axisModule.getName();
        for (AxisModule o : this.engagedModules.values()) {
            AxisModule tempAxisModule = o;
            String tempModuleName = tempAxisModule.getName();
            if (!moduleName.equals(tempModuleName)) continue;
            Version existing = tempAxisModule.getVersion();
            if (Utils.checkVersion(axisModule.getVersion(), existing)) continue;
            throw new AxisFault(Messages.getMessage("mismatchedModuleVersions", this.getClass().getName(), moduleName, String.valueOf(existing)));
        }
        Module module = axisModule.getModule();
        if (module != null) {
            module.engageNotify(this);
        }
        this.onEngage(axisModule, source);
        this.engagedModules.put(axisModule.getArchiveName(), axisModule);
    }

    protected void onEngage(AxisModule module, AxisDescription engager) throws AxisFault {
    }

    public Collection<AxisModule> getEngagedModules() {
        return this.engagedModules == null ? NULL_MODULES : this.engagedModules.values();
    }

    public boolean isEngaged(String moduleName) {
        return this.engagedModules != null && this.engagedModules.keySet().contains(moduleName);
    }

    public boolean isEngaged(AxisModule axisModule) {
        String id = axisModule.getArchiveName();
        return this.engagedModules != null && this.engagedModules.keySet().contains(id);
    }

    public void disengageModule(AxisModule module) throws AxisFault {
        if (module == null || this.engagedModules == null) {
            return;
        }
        if (this.isEngaged(module)) {
            this.onDisengage(module);
            this.engagedModules.remove(module.getArchiveName());
            this.getAxisConfiguration().notifyObservers(new AxisEvent(7, this), module);
        }
    }

    protected void onDisengage(AxisModule module) throws AxisFault {
    }

    private Policy getApplicablePolicy(AxisDescription axisDescription) {
        if (axisDescription instanceof AxisMessage) {
            AxisEndpoint axisEndpoint;
            AxisService axisService;
            AxisMessage axisMessage = (AxisMessage)axisDescription;
            AxisOperation axisOperation = axisMessage.getAxisOperation();
            if (axisOperation != null && (axisService = axisOperation.getAxisService()) != null && axisService.getEndpointName() != null && (axisEndpoint = axisService.getEndpoint(axisService.getEndpointName())) != null) {
                AxisBinding axisBinding = axisEndpoint.getBinding();
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBinding.getChild(axisOperation.getName());
                String direction = axisMessage.getDirection();
                if ("in".equals(direction) && WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                    AxisBindingMessage axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild("In");
                    return axisBindingMessage.getEffectivePolicy();
                }
                if ("out".equals(direction) && WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) {
                    AxisBindingMessage axisBindingMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out");
                    return axisBindingMessage.getEffectivePolicy();
                }
            }
            return ((AxisMessage)axisDescription).getEffectivePolicy();
        }
        return null;
    }

    public PolicySubject getPolicySubject() {
        return this.policySubject;
    }
}

