/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.Hash;

public class PasswordMatcher
implements CredentialsMatcher {
    private PasswordService passwordService = new DefaultPasswordService();

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        PasswordService service = this.ensurePasswordService();
        Object submittedPassword = this.getSubmittedPassword(token);
        Object storedCredentials = this.getStoredPassword(info);
        this.assertStoredCredentialsType(storedCredentials);
        if (storedCredentials instanceof Hash) {
            Hash hashedPassword = (Hash)storedCredentials;
            HashingPasswordService hashingService = this.assertHashingPasswordService(service);
            return hashingService.passwordsMatch(submittedPassword, hashedPassword);
        }
        String formatted = (String)storedCredentials;
        return this.passwordService.passwordsMatch(submittedPassword, formatted);
    }

    private HashingPasswordService assertHashingPasswordService(PasswordService service) {
        if (service instanceof HashingPasswordService) {
            return (HashingPasswordService)service;
        }
        String msg = "AuthenticationInfo's stored credentials are a Hash instance, but the configured passwordService is not a " + HashingPasswordService.class.getName() + " instance.  This is required to perform Hash " + "object password comparisons.";
        throw new IllegalStateException(msg);
    }

    private PasswordService ensurePasswordService() {
        PasswordService service = this.getPasswordService();
        if (service == null) {
            String msg = "Required PasswordService has not been configured.";
            throw new IllegalStateException(msg);
        }
        return service;
    }

    protected Object getSubmittedPassword(AuthenticationToken token) {
        return token != null ? token.getCredentials() : null;
    }

    private void assertStoredCredentialsType(Object credentials) {
        if (credentials instanceof String || credentials instanceof Hash) {
            return;
        }
        String msg = "Stored account credentials are expected to be either a " + Hash.class.getName() + " instance or a formatted hash String.";
        throw new IllegalArgumentException(msg);
    }

    protected Object getStoredPassword(AuthenticationInfo storedAccountInfo) {
        Object stored;
        Object object = stored = storedAccountInfo != null ? storedAccountInfo.getCredentials() : null;
        if (stored instanceof char[]) {
            stored = new String((char[])stored);
        }
        return stored;
    }

    public PasswordService getPasswordService() {
        return this.passwordService;
    }

    public void setPasswordService(PasswordService passwordService) {
        this.passwordService = passwordService;
    }
}

