/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic;

import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.topic.TopicEvent;
import com.hazelcast.topic.proxy.TopicProxy;
import com.hazelcast.topic.proxy.TotalOrderedTopicProxy;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TopicService
implements ManagedService,
RemoteService,
EventPublishingService {
    public static final String SERVICE_NAME = "hz:impl:topicService";
    private final Lock[] orderingLocks = new Lock[1000];
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, LocalTopicStatsImpl> statsMap = new ConcurrentHashMap<String, LocalTopicStatsImpl>();
    private final ConstructorFunction<String, LocalTopicStatsImpl> localTopicStatsConstructorFunction = new ConstructorFunction<String, LocalTopicStatsImpl>(){

        @Override
        public LocalTopicStatsImpl createNew(String mapName) {
            return new LocalTopicStatsImpl();
        }
    };

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        for (int i = 0; i < this.orderingLocks.length; ++i) {
            this.orderingLocks[i] = new ReentrantLock();
        }
    }

    @Override
    public void reset() {
        this.statsMap.clear();
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    public Lock getOrderLock(String key) {
        int hash = key.hashCode();
        return this.orderingLocks[hash != Integer.MIN_VALUE ? Math.abs(hash) % this.orderingLocks.length : 0];
    }

    @Override
    public TopicProxy createDistributedObject(Object objectId) {
        String name = String.valueOf(objectId);
        TopicConfig topicConfig = this.nodeEngine.getConfig().getTopicConfig(name);
        TopicProxy proxy = topicConfig.isGlobalOrderingEnabled() ? new TotalOrderedTopicProxy(name, this.nodeEngine, this) : new TopicProxy(name, this.nodeEngine, this);
        return proxy;
    }

    @Override
    public void destroyDistributedObject(Object objectId) {
        this.statsMap.remove(String.valueOf(objectId));
    }

    public void dispatchEvent(Object event, Object listener) {
        TopicEvent topicEvent = (TopicEvent)event;
        Message message = new Message(topicEvent.name, this.nodeEngine.toObject(topicEvent.data), topicEvent.publishTime, topicEvent.publishingMember);
        this.incrementReceivedMessages(topicEvent.name);
        ((MessageListener)listener).onMessage(message);
    }

    public LocalTopicStatsImpl getLocalTopicStats(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.statsMap, name, this.statsMap, this.localTopicStatsConstructorFunction);
    }

    public void incrementPublishes(String topicName) {
        this.getLocalTopicStats(topicName).incrementPublishes();
    }

    public void incrementReceivedMessages(String topicName) {
        this.getLocalTopicStats(topicName).incrementReceives();
    }

    public void publishEvent(String name, TopicEvent event) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, name);
        eventService.publishEvent(SERVICE_NAME, registrations, (Object)event, name.hashCode());
    }

    public String addMessageListener(String name, MessageListener listener) {
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration eventRegistration = eventService.registerListener(SERVICE_NAME, name, listener);
        return eventRegistration.getId();
    }

    public boolean removeMessageListener(String name, String registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }
}

