/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.IndexOfOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class IndexOfRequest
extends CollectionKeyBasedRequest
implements RetryableRequest {
    Data value;
    boolean last;

    public IndexOfRequest() {
    }

    public IndexOfRequest(CollectionProxyId proxyId, Data key, Data value, boolean last) {
        super(proxyId, key);
        this.value = value;
        this.last = last;
    }

    @Override
    protected Operation prepareOperation() {
        return new IndexOfOperation(this.proxyId, this.key, this.value, this.last);
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeBoolean("l", this.last);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.value.writeData(out);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.last = reader.readBoolean("l");
        ObjectDataInput in = reader.getRawDataInput();
        this.value = new Data();
        this.value.readData(in);
        super.readPortable(reader);
    }
}

