/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreatePlatformEndpointRequestMarshaller
implements Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {
    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        if (createPlatformEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformEndpointRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformEndpointRequest.getPlatformApplicationArn() != null) {
            request.addParameter("PlatformApplicationArn", StringUtils.fromString((String)createPlatformEndpointRequest.getPlatformApplicationArn()));
        }
        if (createPlatformEndpointRequest.getToken() != null) {
            request.addParameter("Token", StringUtils.fromString((String)createPlatformEndpointRequest.getToken()));
        }
        if (createPlatformEndpointRequest.getCustomUserData() != null) {
            request.addParameter("CustomUserData", StringUtils.fromString((String)createPlatformEndpointRequest.getCustomUserData()));
        }
        if (createPlatformEndpointRequest != null && createPlatformEndpointRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : createPlatformEndpointRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

