/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreateQueueRequestMarshaller
implements Marshaller<Request<CreateQueueRequest>, CreateQueueRequest> {
    public Request<CreateQueueRequest> marshall(CreateQueueRequest createQueueRequest) {
        if (createQueueRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createQueueRequest, "AmazonSQS");
        request.addParameter("Action", "CreateQueue");
        request.addParameter("Version", "2012-11-05");
        if (createQueueRequest.getQueueName() != null) {
            request.addParameter("QueueName", StringUtils.fromString((String)createQueueRequest.getQueueName()));
        }
        if (createQueueRequest != null && createQueueRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : createQueueRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

