/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.task.utils.StreamData;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamingTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(DataStreamingTask.class);
    private String userName;
    private String hostName;
    private String inputPath;

    public void init(Map<String, String> propertyMap) throws TaskException {
        this.inputPath = propertyMap.get("inputPath");
        this.hostName = propertyMap.get("hostName");
        this.userName = propertyMap.get("userName");
    }

    public TaskStatus execute(TaskContext taskContext) {
        ProcessState processState = taskContext.getParentProcessContext().getProcessState();
        try {
            TaskStatus status = new TaskStatus(TaskState.EXECUTING);
            DataStagingTaskModel subTaskModel = (DataStagingTaskModel)ThriftUtils.getSubTaskModel((TaskModel)taskContext.getTaskModel());
            if (processState == ProcessState.OUTPUT_DATA_STAGING) {
                ComputationalResourceSchedulingModel resourceSchedule;
                int wallTimeLimit;
                OutputDataObjectType processOutput = taskContext.getProcessOutput();
                if (processOutput != null && processOutput.getValue() == null) {
                    log.error("expId: {}, processId:{}, taskId: {}:- Couldn't stage file {} , file name shouldn't be null", new Object[]{taskContext.getExperimentId(), taskContext.getProcessId(), taskContext.getTaskId(), processOutput.getName()});
                    status = new TaskStatus(TaskState.FAILED);
                    if (processOutput.isIsRequired()) {
                        status.setReason("File name is null, but this output's isRequired bit is not set");
                    } else {
                        status.setReason("File name is null");
                    }
                    return status;
                }
                if (processOutput != null && processOutput.isOutputStreaming() && (wallTimeLimit = (resourceSchedule = taskContext.getParentProcessContext().getProcessModel().getProcessResourceSchedule()).getWallTimeLimit()) > 10) {
                    int period = wallTimeLimit / 10;
                    Timer timer = new Timer();
                    StreamData streamData = new StreamData(this.userName, this.hostName, this.inputPath, taskContext, subTaskModel);
                    timer.schedule((TimerTask)streamData, 0L, (long)(60000 * period));
                    status.setState(TaskState.COMPLETED);
                }
            }
            return null;
        }
        catch (TException e) {
            log.error("Error while creating data streaming task", (Throwable)e);
            return null;
        }
    }

    public TaskStatus recover(TaskContext taskContext) {
        return null;
    }

    public TaskTypes getType() {
        return null;
    }
}

