/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.authentication.SSHKeyAuthentication;
import org.apache.airavata.gfac.core.cluster.AbstractRemoteCluster;
import org.apache.airavata.gfac.core.cluster.CommandInfo;
import org.apache.airavata.gfac.core.cluster.CommandOutput;
import org.apache.airavata.gfac.core.cluster.JobSubmissionOutput;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.cluster.ServerInfo;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.SSHUtils;
import org.apache.airavata.gfac.impl.StandardOutReader;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HPCRemoteCluster
extends AbstractRemoteCluster {
    private static final Logger log = LoggerFactory.getLogger(HPCRemoteCluster.class);
    private static final int MAX_RETRY_COUNT = 3;
    private final SSHKeyAuthentication authentication;
    private final JSch jSch;

    public HPCRemoteCluster(ServerInfo serverInfo, JobManagerConfiguration jobManagerConfiguration, AuthenticationInfo authenticationInfo) throws AiravataException, GFacException {
        super(serverInfo, jobManagerConfiguration, authenticationInfo);
        try {
            if (!(authenticationInfo instanceof SSHKeyAuthentication)) {
                throw new AiravataException("Support ssh key authentication only");
            }
            this.authentication = (SSHKeyAuthentication)authenticationInfo;
            this.jSch = new JSch();
            this.jSch.addIdentity(UUID.randomUUID().toString(), this.authentication.getPrivateKey(), this.authentication.getPublicKey(), this.authentication.getPassphrase().getBytes());
        }
        catch (JSchException e) {
            throw new AiravataException("JSch initialization error ", (Throwable)e);
        }
    }

    private Session getOpenSession() throws JSchException {
        Session newSession = this.jSch.getSession(this.serverInfo.getUserName(), this.serverInfo.getHost(), this.serverInfo.getPort());
        newSession.setUserInfo((UserInfo)new DefaultUserInfo(this.serverInfo.getUserName(), null, this.authentication.getPassphrase()));
        if (this.authentication.getStrictHostKeyChecking().equals("yes")) {
            this.jSch.setKnownHosts(this.authentication.getKnownHostsFilePath());
        } else {
            newSession.setConfig("StrictHostKeyChecking", "no");
        }
        newSession.connect();
        return newSession;
    }

    public JobSubmissionOutput submitBatchJob(String jobScriptFilePath, String workingDirectory) throws GFacException {
        JobSubmissionOutput jsoutput = new JobSubmissionOutput();
        this.copyTo(jobScriptFilePath, workingDirectory);
        RawCommandInfo submitCommand = this.jobManagerConfiguration.getSubmitCommand(workingDirectory, jobScriptFilePath);
        submitCommand.setRawCommand("cd " + workingDirectory + "; " + submitCommand.getRawCommand());
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand((CommandInfo)submitCommand, reader);
        jsoutput.setJobId(this.outputParser.parseJobSubmission(reader.getStdOutputString()));
        if (jsoutput.getJobId() == null && this.outputParser.isJobSubmissionFailed(reader.getStdOutputString())) {
            jsoutput.setJobSubmissionFailed(true);
            jsoutput.setFailureReason("stdout : " + reader.getStdOutputString() + "\n stderr : " + reader.getStdErrorString());
        }
        jsoutput.setExitCode(reader.getExitCode());
        if (jsoutput.getExitCode() != 0) {
            jsoutput.setJobSubmissionFailed(true);
            jsoutput.setFailureReason("stdout : " + reader.getStdOutputString() + "\n stderr : " + reader.getStdErrorString());
        }
        jsoutput.setStdOut(reader.getStdOutputString());
        jsoutput.setStdErr(reader.getStdErrorString());
        return jsoutput;
    }

    public void copyTo(String localFile, String remoteFile) throws GFacException {
        int retry = 3;
        while (retry > 0) {
            try {
                log.info("Transferring localhost:" + localFile + " to " + this.serverInfo.getHost() + ":" + remoteFile);
                SSHUtils.scpTo(localFile, remoteFile, this.getSshSession());
                retry = 0;
            }
            catch (Exception e) {
                if (--retry == 0) {
                    throw new GFacException("Failed to scp localhost:" + localFile + " to " + this.serverInfo.getHost() + ":" + remoteFile, (Throwable)e);
                }
                log.info("Retry transfer localhost:" + localFile + " to " + this.serverInfo.getHost() + ":" + remoteFile);
            }
        }
    }

    private Session getSshSession() throws GFacException {
        return Factory.getSSHSession(this.authenticationInfo, this.serverInfo);
    }

    public void copyFrom(String remoteFile, String localFile) throws GFacException {
        int retry = 3;
        while (retry > 0) {
            try {
                log.info("Transferring " + this.serverInfo.getHost() + ":" + remoteFile + " To localhost:" + localFile);
                SSHUtils.scpFrom(remoteFile, localFile, this.getSession());
                retry = 0;
            }
            catch (Exception e) {
                if (--retry == 0) {
                    throw new GFacException("Failed to scp " + this.serverInfo.getHost() + ":" + remoteFile + " to localhost:" + localFile, (Throwable)e);
                }
                log.info("Retry transfer " + this.serverInfo.getHost() + ":" + remoteFile + "  to localhost:" + localFile);
            }
        }
    }

    public void scpThirdParty(String sourceFile, Session srcSession, String destinationFile, Session destSession, RemoteCluster.DIRECTION direction, boolean ignoreEmptyFile) throws GFacException {
        try {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                log.info("Transferring from:" + sourceFile + " To: " + destinationFile);
                try {
                    SSHUtils.scpThirdParty(sourceFile, srcSession, destinationFile, destSession, ignoreEmptyFile);
                    break;
                }
                catch (JSchException e) {
                    if (retryCount == 3) {
                        log.error("Retry count 3 exceeded for  transferring from:" + sourceFile + " To: " + destinationFile, (Throwable)e);
                        throw e;
                    }
                    log.error("Issue with jsch, Retry transferring from:" + sourceFile + " To: " + destinationFile, (Throwable)e);
                    continue;
                }
            }
        }
        catch (JSchException | IOException e) {
            throw new GFacException("Failed scp file:" + sourceFile + " to remote file " + destinationFile, e);
        }
    }

    public List<String> getFileNameFromExtension(String fileRegex, String parentPath, Session session) throws GFacException {
        try {
            List<String> fileNames = SSHUtils.listDirectory(parentPath, session);
            log.info("All files that are available in the path " + parentPath + " : " + fileNames.toString());
            ArrayList<String> matchingNames = new ArrayList<String>();
            Iterator<String> iterator = fileNames.iterator();
            while (iterator.hasNext()) {
                String fileName;
                String tempFileName = fileName = iterator.next();
                String[] splits = fileRegex.split("\\*");
                boolean matching = true;
                for (String split : splits) {
                    if (!tempFileName.contains(split)) {
                        matching = false;
                        break;
                    }
                    int idx = tempFileName.indexOf(split);
                    tempFileName = tempFileName.substring(idx + split.length());
                }
                if (!matching) continue;
                matchingNames.add(fileName);
            }
            if (matchingNames.isEmpty()) {
                log.warn("No matching file found for extension: " + fileRegex + " in the " + parentPath + " directory");
            }
            return matchingNames;
        }
        catch (Exception e) {
            log.error("Failed to list directory " + parentPath, (Throwable)e);
            throw new GFacException("Failed to list directory " + parentPath, (Throwable)e);
        }
    }

    public void makeDirectory(String directoryPath) throws GFacException {
        try {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                log.info("Creating directory: " + this.serverInfo.getHost() + ":" + directoryPath);
                try {
                    SSHUtils.makeDirectory(directoryPath, this.getSession());
                    break;
                }
                catch (JSchException e) {
                    if (retryCount == 3) {
                        log.error("Retry count 3 exceeded for creating directory: " + this.serverInfo.getHost() + ":" + directoryPath, (Throwable)e);
                        throw e;
                    }
                    log.error("Issue with jsch, Retry creating directory: " + this.serverInfo.getHost() + ":" + directoryPath);
                    continue;
                }
            }
        }
        catch (JSchException | IOException e) {
            throw new GFacException("Failed to create directory " + this.serverInfo.getHost() + ":" + directoryPath, e);
        }
    }

    public long getFileSize(String filePath) throws GFacException {
        return SSHUtils.getFileSize(filePath, this.getSession());
    }

    public JobStatus cancelJob(String jobId) throws GFacException {
        JobStatus oldStatus = this.getJobStatus(jobId);
        RawCommandInfo cancelCommand = this.jobManagerConfiguration.getCancelCommand(jobId);
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand((CommandInfo)cancelCommand, reader);
        this.throwExceptionOnError(reader, cancelCommand);
        return oldStatus;
    }

    public JobStatus getJobStatus(String jobId) throws GFacException {
        RawCommandInfo monitorCommand = this.jobManagerConfiguration.getMonitorCommand(jobId);
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand((CommandInfo)monitorCommand, reader);
        this.throwExceptionOnError(reader, monitorCommand);
        return this.outputParser.parseJobStatus(jobId, reader.getStdOutputString());
    }

    public String getJobIdByJobName(String jobName, String userName) throws GFacException {
        RawCommandInfo jobIdMonitorCommand = this.jobManagerConfiguration.getJobIdMonitorCommand(jobName, userName);
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand((CommandInfo)jobIdMonitorCommand, reader);
        this.throwExceptionOnError(reader, jobIdMonitorCommand);
        return this.outputParser.parseJobId(jobName, reader.getStdOutputString());
    }

    public void getJobStatuses(String userName, Map<String, JobStatus> jobStatusMap) throws GFacException {
        RawCommandInfo userBasedMonitorCommand = this.jobManagerConfiguration.getUserBasedMonitorCommand(userName);
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand((CommandInfo)userBasedMonitorCommand, reader);
        this.throwExceptionOnError(reader, userBasedMonitorCommand);
        this.outputParser.parseJobStatuses(userName, jobStatusMap, reader.getStdOutputString());
    }

    public List<String> listDirectory(String directoryPath) throws GFacException {
        try {
            log.info("Creating directory: " + this.serverInfo.getHost() + ":" + directoryPath);
            return SSHUtils.listDirectory(directoryPath, this.getSession());
        }
        catch (JSchException | IOException e) {
            throw new GFacException("Failed to list directory " + this.serverInfo.getHost() + ":" + directoryPath, e);
        }
    }

    public boolean execute(CommandInfo commandInfo) throws GFacException {
        StandardOutReader reader = new StandardOutReader();
        this.executeCommand(commandInfo, reader);
        return true;
    }

    public Session getSession() throws GFacException {
        return this.getSshSession();
    }

    public void disconnect() throws GFacException {
        Factory.disconnectSSHSession(this.serverInfo);
    }

    private void throwExceptionOnError(StandardOutReader reader, RawCommandInfo submitCommand) throws GFacException {
        String stdErrorString = reader.getStdErrorString();
        String command = submitCommand.getCommand().substring(submitCommand.getCommand().lastIndexOf(File.separator) + 1);
        if (stdErrorString != null && (stdErrorString.contains(command.trim()) && !stdErrorString.contains("Warning") || stdErrorString.contains("error"))) {
            log.error("Command {} , Standard Error output {}", (Object)command, (Object)stdErrorString);
            throw new GFacException("Error running command " + command + "  on remote cluster. StandardError: " + stdErrorString);
        }
    }

    private void executeCommand(CommandInfo commandInfo, CommandOutput commandOutput) throws GFacException {
        String command = commandInfo.getCommand();
        ChannelExec channelExec = null;
        try {
            for (int retryCount = 0; retryCount < 3; ++retryCount) {
                try {
                    Session session = this.getSshSession();
                    channelExec = (ChannelExec)session.openChannel("exec");
                    channelExec.setCommand(command);
                    channelExec.setInputStream(null);
                    channelExec.setErrStream(commandOutput.getStandardError());
                    channelExec.connect();
                    log.info("Executing command {}", (Object)commandInfo.getCommand());
                    commandOutput.onOutput((Channel)channelExec);
                    break;
                }
                catch (JSchException e) {
                    if (retryCount == 3) {
                        log.error("Retry count 3 exceeded for executing command : " + command, (Throwable)e);
                        throw e;
                    }
                    log.error("Issue with jsch, Retry executing command : " + command, (Throwable)e);
                    continue;
                }
            }
        }
        catch (JSchException e) {
            throw new GFacException("Unable to execute command - " + command, (Throwable)e);
        }
        finally {
            if (channelExec != null) {
                commandOutput.exitCode(channelExec.getExitStatus());
                channelExec.disconnect();
            }
        }
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public AuthenticationInfo getAuthentication() {
        return this.authentication;
    }

    private class DefaultUserInfo
    implements UserInfo {
        private String userName;
        private String password;
        private String passphrase;

        public DefaultUserInfo(String userName, String password, String passphrase) {
            this.userName = userName;
            this.password = password;
            this.passphrase = passphrase;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassword(String s) {
            return false;
        }

        public boolean promptPassphrase(String s) {
            return false;
        }

        public boolean promptYesNo(String s) {
            return false;
        }

        public void showMessage(String s) {
        }
    }
}

