/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile;
import org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.ComputeResourceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserComputeHostPreferenceResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserResourceProfileResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserStoragePreferenceResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogThriftConversion;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.UsrResourceProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsrResourceProfileImpl
implements UsrResourceProfile {
    private static final Logger logger = LoggerFactory.getLogger(UsrResourceProfileImpl.class);

    public String addUserResourceProfile(UserResourceProfile userResourceProfile) throws AppCatalogException {
        try {
            List dataStoragePreferences;
            UserResourceProfileResource profileResource = new UserResourceProfileResource();
            if (!userResourceProfile.getUserId().equals("")) {
                profileResource.setUserId(userResourceProfile.getUserId());
            }
            if (!userResourceProfile.getGatewayID().equals("")) {
                profileResource.setGatewayID(userResourceProfile.getGatewayID());
            }
            if (userResourceProfile.getCredentialStoreToken() != null) {
                profileResource.setCredentialStoreToken(userResourceProfile.getCredentialStoreToken());
            }
            if (userResourceProfile.getIdentityServerTenant() != null) {
                profileResource.setIdentityServerTenant(userResourceProfile.getIdentityServerTenant());
            }
            if (userResourceProfile.getIdentityServerPwdCredToken() != null) {
                profileResource.setIdentityServerPwdCredToken(userResourceProfile.getIdentityServerPwdCredToken());
            }
            profileResource.setUserId(userResourceProfile.getUserId());
            profileResource.setGatewayID(userResourceProfile.getGatewayID());
            profileResource.save();
            List userComputeResourcePreferences = userResourceProfile.getUserComputeResourcePreferences();
            if (userComputeResourcePreferences != null && !userComputeResourcePreferences.isEmpty()) {
                for (UserComputeResourcePreference preference : userComputeResourcePreferences) {
                    UserComputeHostPreferenceResource resource = new UserComputeHostPreferenceResource();
                    resource.setUserResourceProfileResource(profileResource);
                    resource.setResourceId(preference.getComputeResourceId());
                    ComputeResourceResource computeHostResource = new ComputeResourceResource();
                    resource.setComputeHostResource((ComputeResourceResource)computeHostResource.get(preference.getComputeResourceId()));
                    resource.setGatewayId(profileResource.getGatewayID());
                    resource.setUserId(profileResource.getUserId());
                    resource.setLoginUserName(preference.getLoginUserName());
                    resource.setResourceCSToken(preference.getResourceSpecificCredentialStoreToken());
                    resource.setBatchQueue(preference.getPreferredBatchQueue());
                    resource.setProjectNumber(preference.getAllocationProjectNumber());
                    resource.setScratchLocation(preference.getScratchLocation());
                    resource.setQualityOfService(preference.getQualityOfService());
                    resource.setReservation(preference.getReservation());
                    if (preference.getReservationStartTime() > 0L) {
                        resource.setReservationStartTime(AiravataUtils.getTime((long)preference.getReservationStartTime()));
                    }
                    if (preference.getReservationEndTime() > 0L) {
                        resource.setReservationEndTime(AiravataUtils.getTime((long)preference.getReservationEndTime()));
                    }
                    resource.setValidated(preference.isValidated());
                    resource.save();
                }
            }
            if ((dataStoragePreferences = userResourceProfile.getUserStoragePreferences()) != null && !dataStoragePreferences.isEmpty()) {
                for (UserStoragePreference storagePreference : dataStoragePreferences) {
                    UserStoragePreferenceResource resource = new UserStoragePreferenceResource();
                    resource.setStorageResourceId(storagePreference.getStorageResourceId());
                    resource.setGatewayId(profileResource.getGatewayID());
                    resource.setUserId(profileResource.getUserId());
                    resource.setFsRootLocation(storagePreference.getFileSystemRootLocation());
                    resource.setLoginUserName(storagePreference.getLoginUserName());
                    resource.setResourceCSToken(storagePreference.getResourceSpecificCredentialStoreToken());
                    resource.setUserResourceProfileResource(profileResource);
                    resource.save();
                }
            }
            return profileResource.getGatewayID();
        }
        catch (Exception e) {
            logger.error("Error while saving gateway profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public void updateUserResourceProfile(String userId, String gatewayId, UserResourceProfile updatedProfile) throws AppCatalogException {
        try {
            List dataStoragePreferences;
            UserResourceProfileResource profileResource = new UserResourceProfileResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            UserResourceProfileResource existingUP = (UserResourceProfileResource)profileResource.get(ids);
            existingUP.setCredentialStoreToken(updatedProfile.getCredentialStoreToken());
            existingUP.setIdentityServerTenant(updatedProfile.getIdentityServerTenant());
            existingUP.setIdentityServerPwdCredToken(updatedProfile.getIdentityServerPwdCredToken());
            existingUP.save();
            List userComputeResourcePreferences = updatedProfile.getUserComputeResourcePreferences();
            if (userComputeResourcePreferences != null && !userComputeResourcePreferences.isEmpty()) {
                for (UserComputeResourcePreference preference : userComputeResourcePreferences) {
                    UserComputeHostPreferenceResource resource = new UserComputeHostPreferenceResource();
                    resource.setUserResourceProfileResource(existingUP);
                    resource.setResourceId(preference.getComputeResourceId());
                    ComputeResourceResource computeHostResource = new ComputeResourceResource();
                    resource.setComputeHostResource((ComputeResourceResource)computeHostResource.get(preference.getComputeResourceId()));
                    resource.setUserId(userId);
                    resource.setGatewayId(gatewayId);
                    resource.setLoginUserName(preference.getLoginUserName());
                    resource.setBatchQueue(preference.getPreferredBatchQueue());
                    resource.setProjectNumber(preference.getAllocationProjectNumber());
                    resource.setScratchLocation(preference.getScratchLocation());
                    resource.setResourceCSToken(preference.getResourceSpecificCredentialStoreToken());
                    resource.setQualityOfService(preference.getQualityOfService());
                    resource.setReservation(preference.getReservation());
                    if (preference.getReservationStartTime() > 0L) {
                        resource.setReservationStartTime(AiravataUtils.getTime((long)preference.getReservationStartTime()));
                    }
                    if (preference.getReservationEndTime() > 0L) {
                        resource.setReservationEndTime(AiravataUtils.getTime((long)preference.getReservationEndTime()));
                    }
                    resource.setValidated(preference.isValidated());
                    resource.save();
                }
            }
            if ((dataStoragePreferences = updatedProfile.getUserStoragePreferences()) != null && !dataStoragePreferences.isEmpty()) {
                for (UserStoragePreference storagePreference : dataStoragePreferences) {
                    UserStoragePreferenceResource resource = new UserStoragePreferenceResource();
                    resource.setStorageResourceId(storagePreference.getStorageResourceId());
                    resource.setGatewayId(existingUP.getGatewayID());
                    resource.setUserId(existingUP.getUserId());
                    resource.setFsRootLocation(storagePreference.getFileSystemRootLocation());
                    resource.setLoginUserName(storagePreference.getLoginUserName());
                    resource.setResourceCSToken(storagePreference.getResourceSpecificCredentialStoreToken());
                    resource.setUserResourceProfileResource(existingUP);
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating User Resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public UserResourceProfile getUserResourceProfile(String userId, String gatewayId) throws AppCatalogException {
        try {
            UserResourceProfileResource resource = new UserResourceProfileResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            UserResourceProfileResource uResource = (UserResourceProfileResource)resource.get(ids);
            UserComputeHostPreferenceResource prefResource = new UserComputeHostPreferenceResource();
            List<AppCatalogResource> usercomputePrefList = prefResource.get("userId", ids);
            List<UserComputeResourcePreference> userComputeResourcePreferences = AppCatalogThriftConversion.getUserComputeResourcePreferences(usercomputePrefList);
            List<UserStoragePreference> dataStoragePreferences = this.getAllUserStoragePreferences(userId, gatewayId);
            if (uResource != null) {
                return AppCatalogThriftConversion.getUserResourceProfile(uResource, userComputeResourcePreferences, dataStoragePreferences);
            }
            return AppCatalogThriftConversion.createNullUserResourceProfile(userId, gatewayId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving user resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeUserResourceProfile(String userId, String gatewayId) throws AppCatalogException {
        try {
            UserResourceProfileResource resource = new UserResourceProfileResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            resource.remove(ids);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting user resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeUserComputeResourcePreferenceFromGateway(String userId, String gatewayId, String preferenceId) throws AppCatalogException {
        try {
            UserComputeHostPreferenceResource resource = new UserComputeHostPreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)preferenceId, (Object)userId, (Object)gatewayId);
            resource.remove(ids);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting user resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean removeUserDataStoragePreferenceFromGateway(String userId, String gatewayId, String preferenceId) throws AppCatalogException {
        try {
            UserStoragePreferenceResource resource = new UserStoragePreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)preferenceId, (Object)userId, (Object)gatewayId);
            resource.remove(ids);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while deleting user resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public boolean isUserResourceProfileExists(String userId, String gatewayId) throws AppCatalogException {
        try {
            UserResourceProfileResource resource = new UserResourceProfileResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            return resource.isExists(ids);
        }
        catch (Exception e) {
            logger.error("Error while retrieving user resource profile...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public UserComputeResourcePreference getUserComputeResourcePreference(String userId, String gatewayId, String hostId) throws AppCatalogException {
        try {
            UserComputeHostPreferenceResource prefResource = new UserComputeHostPreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            List<AppCatalogResource> computePrefList = prefResource.get("userId", ids);
            for (AppCatalogResource resource : computePrefList) {
                UserComputeHostPreferenceResource cmP = (UserComputeHostPreferenceResource)resource;
                if (cmP.getResourceId() == null || cmP.getResourceId().equals("") || !cmP.getResourceId().equals(hostId)) continue;
                return AppCatalogThriftConversion.getUserComputeResourcePreference(cmP);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving user compute resource preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return null;
    }

    public UserStoragePreference getUserStoragePreference(String userId, String gatewayId, String storageId) throws AppCatalogException {
        try {
            UserStoragePreferenceResource prefResource = new UserStoragePreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayId);
            List<AppCatalogResource> computePrefList = prefResource.get("userId", ids);
            for (AppCatalogResource resource : computePrefList) {
                UserStoragePreferenceResource dsP = (UserStoragePreferenceResource)resource;
                if (dsP.getStorageResourceId() == null || dsP.getStorageResourceId().equals("") || !dsP.getStorageResourceId().equals(storageId)) continue;
                return AppCatalogThriftConversion.getUserDataStoragePreference(dsP);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving user data storage preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        return null;
    }

    public List<UserComputeResourcePreference> getAllUserComputeResourcePreferences(String userId, String gatewayID) throws AppCatalogException {
        try {
            UserComputeHostPreferenceResource prefResource = new UserComputeHostPreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayID);
            List<AppCatalogResource> computePrefList = prefResource.get("userId", ids);
            return AppCatalogThriftConversion.getUserComputeResourcePreferences(computePrefList);
        }
        catch (Exception e) {
            logger.error("Error while retrieving compute resource preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<UserStoragePreference> getAllUserStoragePreferences(String userId, String gatewayID) throws AppCatalogException {
        try {
            UserStoragePreferenceResource prefResource = new UserStoragePreferenceResource();
            CompositeIdentifier ids = new CompositeIdentifier((Object)userId, (Object)gatewayID);
            List<AppCatalogResource> dataStoragePrefList = prefResource.get("userId", ids);
            return AppCatalogThriftConversion.getUserDataStoragePreferences(dataStoragePrefList);
        }
        catch (Exception e) {
            logger.error("Error while retrieving data storage preference...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public List<String> getGatewayProfileIds(String gatewayName) throws AppCatalogException {
        try {
            UserResourceProfileResource profileResource = new UserResourceProfileResource();
            List<AppCatalogResource> resourceList = profileResource.get("gatewayID", gatewayName);
            ArrayList<String> gatewayIds = new ArrayList<String>();
            if (resourceList != null && !resourceList.isEmpty()) {
                for (AppCatalogResource resource : resourceList) {
                    gatewayIds.add(((UserResourceProfileResource)resource).getGatewayID());
                }
            }
            return gatewayIds;
        }
        catch (Exception e) {
            logger.error("Error while retrieving gateway ids...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public String getUserNamefromID(String userId, String gatewayID) throws AppCatalogException {
        return null;
    }

    public List<UserResourceProfile> getAllUserResourceProfiles() throws AppCatalogException {
        try {
            ArrayList<UserResourceProfile> gatewayResourceProfileList = new ArrayList<UserResourceProfile>();
            UserResourceProfileResource profileResource = new UserResourceProfileResource();
            List<AppCatalogResource> resourceList = profileResource.getAll();
            if (resourceList != null && !resourceList.isEmpty()) {
                for (AppCatalogResource resource : resourceList) {
                    UserResourceProfileResource userProfileResource = (UserResourceProfileResource)resource;
                    List<UserComputeResourcePreference> computeResourcePreferences = this.getAllUserComputeResourcePreferences(userProfileResource.getUserId(), userProfileResource.getGatewayID());
                    List<UserStoragePreference> dataStoragePreferences = this.getAllUserStoragePreferences(userProfileResource.getUserId(), userProfileResource.getGatewayID());
                    UserResourceProfile gatewayResourceProfile = AppCatalogThriftConversion.getUserResourceProfile(userProfileResource, computeResourcePreferences, dataStoragePreferences);
                    gatewayResourceProfileList.add(gatewayResourceProfile);
                }
            }
            return gatewayResourceProfileList;
        }
        catch (Exception e) {
            logger.error("Error while retrieving user resource profiles...", (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
    }

    public static Logger getLogger() {
        return logger;
    }
}

