/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.ProxyCollection;

public class ProxyCollections
extends Proxies {
    public static void beforeAdd(ProxyCollection coll, int index, Object value) {
        ProxyCollections.assertAllowedType(value, coll.getElementType());
        ProxyCollections.dirty(coll, true);
    }

    public static void beforeInsertElementAt(ProxyCollection coll, Object value, int index) {
        ProxyCollections.beforeAdd(coll, index, value);
    }

    public static void beforeAdd(ProxyCollection coll, Object value) {
        ProxyCollections.assertAllowedType(value, coll.getElementType());
        ProxyCollections.dirty(coll, false);
    }

    public static boolean afterAdd(ProxyCollection coll, Object value, boolean added) {
        if (added && coll.getChangeTracker() != null) {
            ((CollectionChangeTracker)coll.getChangeTracker()).added(value);
        }
        return added;
    }

    public static void beforeAddElement(ProxyCollection coll, Object value) {
        ProxyCollections.beforeAdd(coll, value);
    }

    public static void afterAddElement(ProxyCollection coll, Object value) {
        ProxyCollections.afterAdd(coll, value, true);
    }

    public static void beforeAddFirst(ProxyCollection coll, Object value) {
        ProxyCollections.beforeAdd(coll, 0, value);
    }

    public static void beforeAddLast(ProxyCollection coll, Object value) {
        ProxyCollections.beforeAdd(coll, value);
    }

    public static void afterAddLast(ProxyCollection coll, Object value) {
        ProxyCollections.afterAdd(coll, value, true);
    }

    public static void beforeOffer(ProxyCollection coll, Object value) {
        ProxyCollections.beforeAdd(coll, value);
    }

    public static boolean afterOffer(ProxyCollection coll, Object value, boolean added) {
        return ProxyCollections.afterAdd(coll, value, added);
    }

    public static boolean addAll(ProxyCollection coll, int index, Collection values) {
        List list = (List)((Object)coll);
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            list.add(index, itr.next());
            ++index;
        }
        return values.size() > 0;
    }

    public static boolean addAll(ProxyCollection coll, Collection values) {
        boolean added = false;
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            added |= coll.add(itr.next());
        }
        return added;
    }

    public static void beforeClear(ProxyCollection coll) {
        ProxyCollections.dirty(coll, true);
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            ProxyCollections.removed(coll, itr.next(), false);
        }
    }

    public static void beforeRemoveAllElements(ProxyCollection coll) {
        ProxyCollections.beforeClear(coll);
    }

    public static Iterator afterIterator(final ProxyCollection coll, final Iterator itr) {
        if (itr instanceof ProxyIterator) {
            return itr;
        }
        return new ProxyIterator(){
            private Object _last = null;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            public Object next() {
                this._last = itr.next();
                return this._last;
            }

            @Override
            public void remove() {
                Proxies.dirty(coll, false);
                itr.remove();
                if (coll.getChangeTracker() != null) {
                    ((CollectionChangeTracker)coll.getChangeTracker()).removed(this._last);
                }
                Proxies.removed(coll, this._last, false);
            }
        };
    }

    public static ListIterator afterListIterator(ProxyCollection coll, int idx, ListIterator itr) {
        return ProxyCollections.afterListIterator(coll, itr);
    }

    public static ListIterator afterListIterator(final ProxyCollection coll, final ListIterator itr) {
        if (itr instanceof ProxyListIterator) {
            return itr;
        }
        return new ProxyListIterator(){
            private Object _last = null;

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public int nextIndex() {
                return itr.nextIndex();
            }

            @Override
            public Object next() {
                this._last = itr.next();
                return this._last;
            }

            @Override
            public boolean hasPrevious() {
                return itr.hasPrevious();
            }

            @Override
            public int previousIndex() {
                return itr.previousIndex();
            }

            public Object previous() {
                this._last = itr.previous();
                return this._last;
            }

            public void set(Object o) {
                Proxies.assertAllowedType(o, coll.getElementType());
                Proxies.dirty(coll, false);
                itr.set(o);
                if (coll.getChangeTracker() != null) {
                    coll.getChangeTracker().stopTracking();
                }
                Proxies.removed(coll, this._last, false);
                this._last = o;
            }

            public void add(Object o) {
                Proxies.assertAllowedType(o, coll.getElementType());
                Proxies.dirty(coll, false);
                itr.add(o);
                if (coll.getChangeTracker() != null) {
                    if (this.hasNext()) {
                        coll.getChangeTracker().stopTracking();
                    } else {
                        ((CollectionChangeTracker)coll.getChangeTracker()).added(o);
                    }
                }
                this._last = o;
            }

            @Override
            public void remove() {
                Proxies.dirty(coll, false);
                itr.remove();
                if (coll.getChangeTracker() != null) {
                    ((CollectionChangeTracker)coll.getChangeTracker()).removed(this._last);
                }
                Proxies.removed(coll, this._last, false);
            }
        };
    }

    public static void beforeRemove(ProxyCollection coll, int index) {
        ProxyCollections.dirty(coll, false);
    }

    public static Object afterRemove(ProxyCollection coll, int index, Object removed) {
        if (coll.getChangeTracker() != null) {
            ((CollectionChangeTracker)coll.getChangeTracker()).removed(removed);
        }
        ProxyCollections.removed(coll, removed, false);
        return removed;
    }

    public static void beforeRemoveElementAt(ProxyCollection coll, int index) {
        ProxyCollections.beforeRemove(coll, index);
    }

    public static void beforeRemove(ProxyCollection coll, Object o) {
        ProxyCollections.dirty(coll, false);
    }

    public static boolean afterRemove(ProxyCollection coll, Object o, boolean removed) {
        if (!removed) {
            return false;
        }
        if (coll.getChangeTracker() != null) {
            ((CollectionChangeTracker)coll.getChangeTracker()).removed(o);
        }
        ProxyCollections.removed(coll, o, false);
        return true;
    }

    public static void beforeRemoveElement(ProxyCollection coll, Object o) {
        ProxyCollections.beforeRemove(coll, o);
    }

    public static boolean afterRemoveElement(ProxyCollection coll, Object o, boolean removed) {
        return ProxyCollections.afterRemove(coll, o, removed);
    }

    public static void beforeRemoveFirst(ProxyCollection coll) {
        ProxyCollections.beforeRemove(coll, 0);
    }

    public static Object afterRemoveFirst(ProxyCollection coll, Object removed) {
        return ProxyCollections.afterRemove(coll, 0, removed);
    }

    public static void beforeRemoveLast(ProxyCollection coll) {
        ProxyCollections.beforeRemove(coll, coll.size() - 1);
    }

    public static Object afterRemoveLast(ProxyCollection coll, Object removed) {
        return ProxyCollections.afterRemove(coll, coll.size(), removed);
    }

    public static void beforeRemove(ProxyCollection coll) {
        ProxyCollections.beforeRemove(coll, 0);
    }

    public static Object afterRemove(ProxyCollection coll, Object removed) {
        return ProxyCollections.afterRemove(coll, 0, removed);
    }

    public static void beforePoll(ProxyCollection coll) {
        if (!coll.isEmpty()) {
            ProxyCollections.beforeRemove(coll, 0);
        }
    }

    public static Object afterPoll(ProxyCollection coll, Object removed) {
        if (removed != null) {
            ProxyCollections.afterRemove(coll, 0, removed);
        }
        return removed;
    }

    public static boolean removeAll(ProxyCollection coll, Collection vals) {
        boolean removed = false;
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            removed |= coll.remove(itr.next());
        }
        return removed;
    }

    public static boolean retainAll(ProxyCollection coll, Collection vals) {
        int size = coll.size();
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            if (vals.contains(itr.next())) continue;
            itr.remove();
        }
        return coll.size() < size;
    }

    public static void beforeSet(ProxyCollection coll, int index, Object element) {
        ProxyCollections.assertAllowedType(element, coll.getElementType());
        ProxyCollections.dirty(coll, true);
    }

    public static Object afterSet(ProxyCollection coll, int index, Object element, Object replaced) {
        if (replaced != element) {
            ProxyCollections.removed(coll, replaced, false);
        }
        return replaced;
    }

    public static void beforeSetElementAt(ProxyCollection coll, Object element, int index) {
        ProxyCollections.beforeSet(coll, index, element);
    }

    public static Object afterSetElementAt(ProxyCollection coll, Object element, int index, Object replaced) {
        return ProxyCollections.afterSet(coll, index, element, replaced);
    }

    public static interface ProxyListIterator
    extends ProxyIterator,
    ListIterator {
    }

    public static interface ProxyIterator
    extends Iterator {
    }
}

