/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.util.UnsupportedException;

public class MergedResult
implements Result {
    private static final byte NEXT = 0;
    private static final byte CURRENT = 1;
    private static final byte DONE = 2;
    private final Result[] _res;
    private final byte[] _status;
    private final ResultComparator _comp;
    private final Object[] _order;
    private int _idx = 0;
    private boolean _pushedBack = false;

    public MergedResult(Result[] res) {
        this(res, null);
    }

    public MergedResult(Result[] res, ResultComparator comp) {
        this._res = res;
        this._comp = comp;
        this._order = comp == null ? null : new Object[res.length];
        this._status = comp == null ? null : new byte[res.length];
    }

    @Override
    public Object getEager(FieldMapping key) {
        return this._res[this._idx].getEager(key);
    }

    @Override
    public void putEager(FieldMapping key, Object res) {
        this._res[this._idx].putEager(key, res);
    }

    @Override
    public Joins newJoins() {
        return this._res[this._idx].newJoins();
    }

    @Override
    public void close() {
        for (int i = 0; i < this._res.length; ++i) {
            this._res[i].close();
        }
    }

    @Override
    public void setLocking(boolean locking) {
        this._res[this._idx].setLocking(locking);
    }

    @Override
    public boolean isLocking() {
        return this._res[this._idx].isLocking();
    }

    @Override
    public boolean supportsRandomAccess() throws SQLException {
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedException();
    }

    @Override
    public boolean next() throws SQLException {
        if (this._pushedBack) {
            this._pushedBack = false;
            return true;
        }
        if (this._comp == null) {
            while (!this._res[this._idx].next()) {
                if (this._idx == this._res.length - 1) {
                    return false;
                }
                ++this._idx;
            }
            return true;
        }
        boolean hasValue = false;
        block5: for (int i = 0; i < this._status.length; ++i) {
            switch (this._status[i]) {
                case 0: {
                    if (this._res[i].next()) {
                        hasValue = true;
                        this._status[i] = 1;
                        this._order[i] = this._comp.getOrderingValue(this._res[i], i);
                        continue block5;
                    }
                    this._status[i] = 2;
                    continue block5;
                }
                case 1: {
                    hasValue = true;
                }
            }
        }
        if (!hasValue) {
            return false;
        }
        int least = -1;
        Object orderVal = null;
        for (int i = 0; i < this._order.length; ++i) {
            if (this._status[i] != 1 || least != -1 && this._comp.compare(this._order[i], orderVal) >= 0) continue;
            least = i;
            orderVal = this._order[i];
        }
        this._idx = least;
        this._order[least] = null;
        this._status[least] = 0;
        return true;
    }

    @Override
    public void pushBack() throws SQLException {
        this._pushedBack = true;
    }

    @Override
    public int size() throws SQLException {
        int size = 0;
        for (int i = 0; i < this._res.length; ++i) {
            size += this._res[i].size();
        }
        return size;
    }

    @Override
    public boolean contains(Object obj) throws SQLException {
        return this._res[this._idx].contains(obj);
    }

    @Override
    public boolean containsAll(Object[] objs) throws SQLException {
        return this._res[this._idx].containsAll(objs);
    }

    @Override
    public boolean contains(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].contains(col, joins);
    }

    @Override
    public boolean containsAll(Column[] cols, Joins joins) throws SQLException {
        return this._res[this._idx].containsAll(cols, joins);
    }

    @Override
    public ClassMapping getBaseMapping() {
        return this._res[this._idx].getBaseMapping();
    }

    @Override
    public void setBaseMapping(ClassMapping mapping) {
        this._res[this._idx].setBaseMapping(mapping);
    }

    @Override
    public FieldMapping getMappedByFieldMapping() {
        return this._res[this._idx].getMappedByFieldMapping();
    }

    @Override
    public void setMappedByFieldMapping(FieldMapping fieldMapping) {
        this._res[this._idx].setMappedByFieldMapping(fieldMapping);
    }

    @Override
    public Object getMappedByValue() {
        return this._res[this._idx].getMappedByValue();
    }

    @Override
    public void setMappedByValue(Object mappedByValue) {
        this._res[this._idx].setMappedByValue(mappedByValue);
    }

    @Override
    public int indexOf() {
        return this._res[this._idx].indexOf();
    }

    @Override
    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        return this._res[this._idx].load(mapping, store, fetch);
    }

    @Override
    public Object load(ClassMapping mapping, JDBCStore store, JDBCFetchConfiguration fetch, Joins joins) throws SQLException {
        return this._res[this._idx].load(mapping, store, fetch, joins);
    }

    @Override
    public Array getArray(Object obj) throws SQLException {
        return this._res[this._idx].getArray(obj);
    }

    @Override
    public InputStream getAsciiStream(Object obj) throws SQLException {
        return this._res[this._idx].getAsciiStream(obj);
    }

    @Override
    public BigDecimal getBigDecimal(Object obj) throws SQLException {
        return this._res[this._idx].getBigDecimal(obj);
    }

    @Override
    public BigInteger getBigInteger(Object obj) throws SQLException {
        return this._res[this._idx].getBigInteger(obj);
    }

    @Override
    public InputStream getBinaryStream(Object obj) throws SQLException {
        return this._res[this._idx].getBinaryStream(obj);
    }

    @Override
    public InputStream getLOBStream(JDBCStore store, Object obj) throws SQLException {
        return this._res[this._idx].getLOBStream(store, obj);
    }

    @Override
    public Blob getBlob(Object obj) throws SQLException {
        return this._res[this._idx].getBlob(obj);
    }

    @Override
    public boolean getBoolean(Object obj) throws SQLException {
        return this._res[this._idx].getBoolean(obj);
    }

    @Override
    public byte getByte(Object obj) throws SQLException {
        return this._res[this._idx].getByte(obj);
    }

    @Override
    public byte[] getBytes(Object obj) throws SQLException {
        return this._res[this._idx].getBytes(obj);
    }

    @Override
    public Calendar getCalendar(Object obj) throws SQLException {
        return this._res[this._idx].getCalendar(obj);
    }

    @Override
    public char getChar(Object obj) throws SQLException {
        return this._res[this._idx].getChar(obj);
    }

    @Override
    public Reader getCharacterStream(Object obj) throws SQLException {
        return this._res[this._idx].getCharacterStream(obj);
    }

    @Override
    public Clob getClob(Object obj) throws SQLException {
        return this._res[this._idx].getClob(obj);
    }

    @Override
    public java.util.Date getDate(Object obj) throws SQLException {
        return this._res[this._idx].getDate(obj);
    }

    @Override
    public Date getDate(Object obj, Calendar cal) throws SQLException {
        return this._res[this._idx].getDate(obj, cal);
    }

    @Override
    public double getDouble(Object obj) throws SQLException {
        return this._res[this._idx].getDouble(obj);
    }

    @Override
    public float getFloat(Object obj) throws SQLException {
        return this._res[this._idx].getFloat(obj);
    }

    @Override
    public int getInt(Object obj) throws SQLException {
        return this._res[this._idx].getInt(obj);
    }

    @Override
    public Locale getLocale(Object obj) throws SQLException {
        return this._res[this._idx].getLocale(obj);
    }

    @Override
    public long getLong(Object obj) throws SQLException {
        return this._res[this._idx].getLong(obj);
    }

    @Override
    public Number getNumber(Object obj) throws SQLException {
        return this._res[this._idx].getNumber(obj);
    }

    @Override
    public Object getObject(Object obj, int metaType, Object arg) throws SQLException {
        return this._res[this._idx].getObject(obj, metaType, arg);
    }

    @Override
    public Object getSQLObject(Object obj, Map map) throws SQLException {
        return this._res[this._idx].getSQLObject(obj, map);
    }

    @Override
    public Ref getRef(Object obj, Map map) throws SQLException {
        return this._res[this._idx].getRef(obj, map);
    }

    @Override
    public short getShort(Object obj) throws SQLException {
        return this._res[this._idx].getShort(obj);
    }

    @Override
    public String getString(Object obj) throws SQLException {
        return this._res[this._idx].getString(obj);
    }

    @Override
    public Time getTime(Object obj, Calendar cal) throws SQLException {
        return this._res[this._idx].getTime(obj, cal);
    }

    @Override
    public Timestamp getTimestamp(Object obj, Calendar cal) throws SQLException {
        return this._res[this._idx].getTimestamp(obj, cal);
    }

    @Override
    public Array getArray(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getArray(col, joins);
    }

    @Override
    public InputStream getAsciiStream(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getAsciiStream(col, joins);
    }

    @Override
    public BigDecimal getBigDecimal(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBigDecimal(col, joins);
    }

    @Override
    public BigInteger getBigInteger(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBigInteger(col, joins);
    }

    @Override
    public InputStream getBinaryStream(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBinaryStream(col, joins);
    }

    @Override
    public Blob getBlob(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBlob(col, joins);
    }

    @Override
    public boolean getBoolean(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBoolean(col, joins);
    }

    @Override
    public byte getByte(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getByte(col, joins);
    }

    @Override
    public byte[] getBytes(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getBytes(col, joins);
    }

    @Override
    public Calendar getCalendar(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getCalendar(col, joins);
    }

    @Override
    public char getChar(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getChar(col, joins);
    }

    @Override
    public Reader getCharacterStream(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getCharacterStream(col, joins);
    }

    @Override
    public Clob getClob(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getClob(col, joins);
    }

    @Override
    public java.util.Date getDate(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getDate(col, joins);
    }

    @Override
    public Date getDate(Column col, Calendar cal, Joins joins) throws SQLException {
        return this._res[this._idx].getDate(col, cal, joins);
    }

    @Override
    public double getDouble(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getDouble(col, joins);
    }

    @Override
    public float getFloat(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getFloat(col, joins);
    }

    @Override
    public int getInt(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getInt(col, joins);
    }

    @Override
    public Locale getLocale(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getLocale(col, joins);
    }

    @Override
    public long getLong(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getLong(col, joins);
    }

    @Override
    public Number getNumber(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getNumber(col, joins);
    }

    @Override
    public Object getObject(Column col, Object arg, Joins joins) throws SQLException {
        return this._res[this._idx].getObject(col, arg, joins);
    }

    @Override
    public Object getSQLObject(Column col, Map map, Joins joins) throws SQLException {
        return this._res[this._idx].getSQLObject(col, map, joins);
    }

    @Override
    public Ref getRef(Column col, Map map, Joins joins) throws SQLException {
        return this._res[this._idx].getRef(col, map, joins);
    }

    @Override
    public short getShort(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getShort(col, joins);
    }

    @Override
    public String getString(Column col, Joins joins) throws SQLException {
        return this._res[this._idx].getString(col, joins);
    }

    @Override
    public Time getTime(Column col, Calendar cal, Joins joins) throws SQLException {
        return this._res[this._idx].getTime(col, cal, joins);
    }

    @Override
    public Timestamp getTimestamp(Column col, Calendar cal, Joins joins) throws SQLException {
        return this._res[this._idx].getTimestamp(col, cal, joins);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._res[this._idx].wasNull();
    }

    @Override
    public void startDataRequest(Object mapping) {
        for (int i = 0; i < this._res.length; ++i) {
            this._res[i].startDataRequest(mapping);
        }
    }

    @Override
    public void endDataRequest() {
        for (int i = 0; i < this._res.length; ++i) {
            this._res[i].endDataRequest();
        }
    }

    public static interface ResultComparator
    extends Comparator {
        public Object getOrderingValue(Result var1, int var2);
    }
}

