/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * Job update thresholds and limits.
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class JobUpdateSettings implements org.apache.thrift.TBase<JobUpdateSettings, JobUpdateSettings._Fields>, java.io.Serializable, Cloneable, Comparable<JobUpdateSettings> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("JobUpdateSettings");

  private static final org.apache.thrift.protocol.TField UPDATE_GROUP_SIZE_FIELD_DESC = new org.apache.thrift.protocol.TField("updateGroupSize", org.apache.thrift.protocol.TType.I32, (short)1);
  private static final org.apache.thrift.protocol.TField MAX_PER_INSTANCE_FAILURES_FIELD_DESC = new org.apache.thrift.protocol.TField("maxPerInstanceFailures", org.apache.thrift.protocol.TType.I32, (short)2);
  private static final org.apache.thrift.protocol.TField MAX_FAILED_INSTANCES_FIELD_DESC = new org.apache.thrift.protocol.TField("maxFailedInstances", org.apache.thrift.protocol.TType.I32, (short)3);
  private static final org.apache.thrift.protocol.TField MIN_WAIT_IN_INSTANCE_RUNNING_MS_FIELD_DESC = new org.apache.thrift.protocol.TField("minWaitInInstanceRunningMs", org.apache.thrift.protocol.TType.I32, (short)5);
  private static final org.apache.thrift.protocol.TField ROLLBACK_ON_FAILURE_FIELD_DESC = new org.apache.thrift.protocol.TField("rollbackOnFailure", org.apache.thrift.protocol.TType.BOOL, (short)6);
  private static final org.apache.thrift.protocol.TField UPDATE_ONLY_THESE_INSTANCES_FIELD_DESC = new org.apache.thrift.protocol.TField("updateOnlyTheseInstances", org.apache.thrift.protocol.TType.SET, (short)7);
  private static final org.apache.thrift.protocol.TField WAIT_FOR_BATCH_COMPLETION_FIELD_DESC = new org.apache.thrift.protocol.TField("waitForBatchCompletion", org.apache.thrift.protocol.TType.BOOL, (short)8);
  private static final org.apache.thrift.protocol.TField BLOCK_IF_NO_PULSES_AFTER_MS_FIELD_DESC = new org.apache.thrift.protocol.TField("blockIfNoPulsesAfterMs", org.apache.thrift.protocol.TType.I32, (short)9);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new JobUpdateSettingsStandardSchemeFactory());
    schemes.put(TupleScheme.class, new JobUpdateSettingsTupleSchemeFactory());
  }

  /**
   * Max number of instances being updated at any given moment.
   */
  public int updateGroupSize; // required
  /**
   * Max number of instance failures to tolerate before marking instance as FAILED.
   */
  public int maxPerInstanceFailures; // required
  /**
   * Max number of FAILED instances to tolerate before terminating the update.
   */
  public int maxFailedInstances; // required
  /**
   * Min time to watch a RUNNING instance.
   */
  public int minWaitInInstanceRunningMs; // required
  /**
   * If true, enables failed update rollback.
   */
  public boolean rollbackOnFailure; // required
  /**
   * Instance IDs to act on. All instances will be affected if this is not set.
   */
  public Set<Range> updateOnlyTheseInstances; // required
  /**
   * If true, use updateGroupSize as strict batching boundaries, and avoid proceeding to another
   * batch until the preceding batch finishes updating.
   */
  public boolean waitForBatchCompletion; // required
  /**
   * If set, requires external calls to pulseJobUpdate RPC within the specified rate for the
   * update to make progress. If no pulses received within specified interval the update will
   * block. A blocked update is unable to continue but retains its current status. It may only get
   * unblocked by a fresh pulseJobUpdate call.
   */
  public int blockIfNoPulsesAfterMs; // optional

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    /**
     * Max number of instances being updated at any given moment.
     */
    UPDATE_GROUP_SIZE((short)1, "updateGroupSize"),
    /**
     * Max number of instance failures to tolerate before marking instance as FAILED.
     */
    MAX_PER_INSTANCE_FAILURES((short)2, "maxPerInstanceFailures"),
    /**
     * Max number of FAILED instances to tolerate before terminating the update.
     */
    MAX_FAILED_INSTANCES((short)3, "maxFailedInstances"),
    /**
     * Min time to watch a RUNNING instance.
     */
    MIN_WAIT_IN_INSTANCE_RUNNING_MS((short)5, "minWaitInInstanceRunningMs"),
    /**
     * If true, enables failed update rollback.
     */
    ROLLBACK_ON_FAILURE((short)6, "rollbackOnFailure"),
    /**
     * Instance IDs to act on. All instances will be affected if this is not set.
     */
    UPDATE_ONLY_THESE_INSTANCES((short)7, "updateOnlyTheseInstances"),
    /**
     * If true, use updateGroupSize as strict batching boundaries, and avoid proceeding to another
     * batch until the preceding batch finishes updating.
     */
    WAIT_FOR_BATCH_COMPLETION((short)8, "waitForBatchCompletion"),
    /**
     * If set, requires external calls to pulseJobUpdate RPC within the specified rate for the
     * update to make progress. If no pulses received within specified interval the update will
     * block. A blocked update is unable to continue but retains its current status. It may only get
     * unblocked by a fresh pulseJobUpdate call.
     */
    BLOCK_IF_NO_PULSES_AFTER_MS((short)9, "blockIfNoPulsesAfterMs");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 1: // UPDATE_GROUP_SIZE
          return UPDATE_GROUP_SIZE;
        case 2: // MAX_PER_INSTANCE_FAILURES
          return MAX_PER_INSTANCE_FAILURES;
        case 3: // MAX_FAILED_INSTANCES
          return MAX_FAILED_INSTANCES;
        case 5: // MIN_WAIT_IN_INSTANCE_RUNNING_MS
          return MIN_WAIT_IN_INSTANCE_RUNNING_MS;
        case 6: // ROLLBACK_ON_FAILURE
          return ROLLBACK_ON_FAILURE;
        case 7: // UPDATE_ONLY_THESE_INSTANCES
          return UPDATE_ONLY_THESE_INSTANCES;
        case 8: // WAIT_FOR_BATCH_COMPLETION
          return WAIT_FOR_BATCH_COMPLETION;
        case 9: // BLOCK_IF_NO_PULSES_AFTER_MS
          return BLOCK_IF_NO_PULSES_AFTER_MS;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __UPDATEGROUPSIZE_ISSET_ID = 0;
  private static final int __MAXPERINSTANCEFAILURES_ISSET_ID = 1;
  private static final int __MAXFAILEDINSTANCES_ISSET_ID = 2;
  private static final int __MINWAITININSTANCERUNNINGMS_ISSET_ID = 3;
  private static final int __ROLLBACKONFAILURE_ISSET_ID = 4;
  private static final int __WAITFORBATCHCOMPLETION_ISSET_ID = 5;
  private static final int __BLOCKIFNOPULSESAFTERMS_ISSET_ID = 6;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.BLOCK_IF_NO_PULSES_AFTER_MS};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.UPDATE_GROUP_SIZE, new org.apache.thrift.meta_data.FieldMetaData("updateGroupSize", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.MAX_PER_INSTANCE_FAILURES, new org.apache.thrift.meta_data.FieldMetaData("maxPerInstanceFailures", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.MAX_FAILED_INSTANCES, new org.apache.thrift.meta_data.FieldMetaData("maxFailedInstances", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.MIN_WAIT_IN_INSTANCE_RUNNING_MS, new org.apache.thrift.meta_data.FieldMetaData("minWaitInInstanceRunningMs", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(_Fields.ROLLBACK_ON_FAILURE, new org.apache.thrift.meta_data.FieldMetaData("rollbackOnFailure", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.UPDATE_ONLY_THESE_INSTANCES, new org.apache.thrift.meta_data.FieldMetaData("updateOnlyTheseInstances", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.SetMetaData(org.apache.thrift.protocol.TType.SET, 
            new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Range.class))));
    tmpMap.put(_Fields.WAIT_FOR_BATCH_COMPLETION, new org.apache.thrift.meta_data.FieldMetaData("waitForBatchCompletion", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
    tmpMap.put(_Fields.BLOCK_IF_NO_PULSES_AFTER_MS, new org.apache.thrift.meta_data.FieldMetaData("blockIfNoPulsesAfterMs", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(JobUpdateSettings.class, metaDataMap);
  }

  public JobUpdateSettings() {
  }

  public JobUpdateSettings(
    int updateGroupSize,
    int maxPerInstanceFailures,
    int maxFailedInstances,
    int minWaitInInstanceRunningMs,
    boolean rollbackOnFailure,
    Set<Range> updateOnlyTheseInstances,
    boolean waitForBatchCompletion)
  {
    this();
    this.updateGroupSize = updateGroupSize;
    setUpdateGroupSizeIsSet(true);
    this.maxPerInstanceFailures = maxPerInstanceFailures;
    setMaxPerInstanceFailuresIsSet(true);
    this.maxFailedInstances = maxFailedInstances;
    setMaxFailedInstancesIsSet(true);
    this.minWaitInInstanceRunningMs = minWaitInInstanceRunningMs;
    setMinWaitInInstanceRunningMsIsSet(true);
    this.rollbackOnFailure = rollbackOnFailure;
    setRollbackOnFailureIsSet(true);
    this.updateOnlyTheseInstances = updateOnlyTheseInstances;
    this.waitForBatchCompletion = waitForBatchCompletion;
    setWaitForBatchCompletionIsSet(true);
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public JobUpdateSettings(JobUpdateSettings other) {
    __isset_bitfield = other.__isset_bitfield;
    this.updateGroupSize = other.updateGroupSize;
    this.maxPerInstanceFailures = other.maxPerInstanceFailures;
    this.maxFailedInstances = other.maxFailedInstances;
    this.minWaitInInstanceRunningMs = other.minWaitInInstanceRunningMs;
    this.rollbackOnFailure = other.rollbackOnFailure;
    if (other.isSetUpdateOnlyTheseInstances()) {
      Set<Range> __this__updateOnlyTheseInstances = new HashSet<Range>(other.updateOnlyTheseInstances.size());
      for (Range other_element : other.updateOnlyTheseInstances) {
        __this__updateOnlyTheseInstances.add(new Range(other_element));
      }
      this.updateOnlyTheseInstances = __this__updateOnlyTheseInstances;
    }
    this.waitForBatchCompletion = other.waitForBatchCompletion;
    this.blockIfNoPulsesAfterMs = other.blockIfNoPulsesAfterMs;
  }

  public JobUpdateSettings deepCopy() {
    return new JobUpdateSettings(this);
  }

  @Override
  public void clear() {
    setUpdateGroupSizeIsSet(false);
    this.updateGroupSize = 0;
    setMaxPerInstanceFailuresIsSet(false);
    this.maxPerInstanceFailures = 0;
    setMaxFailedInstancesIsSet(false);
    this.maxFailedInstances = 0;
    setMinWaitInInstanceRunningMsIsSet(false);
    this.minWaitInInstanceRunningMs = 0;
    setRollbackOnFailureIsSet(false);
    this.rollbackOnFailure = false;
    this.updateOnlyTheseInstances = null;
    setWaitForBatchCompletionIsSet(false);
    this.waitForBatchCompletion = false;
    setBlockIfNoPulsesAfterMsIsSet(false);
    this.blockIfNoPulsesAfterMs = 0;
  }

  /**
   * Max number of instances being updated at any given moment.
   */
  public int getUpdateGroupSize() {
    return this.updateGroupSize;
  }

  /**
   * Max number of instances being updated at any given moment.
   */
  public JobUpdateSettings setUpdateGroupSize(int updateGroupSize) {
    this.updateGroupSize = updateGroupSize;
    setUpdateGroupSizeIsSet(true);
    return this;
  }

  public void unsetUpdateGroupSize() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __UPDATEGROUPSIZE_ISSET_ID);
  }

  /** Returns true if field updateGroupSize is set (has been assigned a value) and false otherwise */
  public boolean isSetUpdateGroupSize() {
    return EncodingUtils.testBit(__isset_bitfield, __UPDATEGROUPSIZE_ISSET_ID);
  }

  public void setUpdateGroupSizeIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __UPDATEGROUPSIZE_ISSET_ID, value);
  }

  /**
   * Max number of instance failures to tolerate before marking instance as FAILED.
   */
  public int getMaxPerInstanceFailures() {
    return this.maxPerInstanceFailures;
  }

  /**
   * Max number of instance failures to tolerate before marking instance as FAILED.
   */
  public JobUpdateSettings setMaxPerInstanceFailures(int maxPerInstanceFailures) {
    this.maxPerInstanceFailures = maxPerInstanceFailures;
    setMaxPerInstanceFailuresIsSet(true);
    return this;
  }

  public void unsetMaxPerInstanceFailures() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __MAXPERINSTANCEFAILURES_ISSET_ID);
  }

  /** Returns true if field maxPerInstanceFailures is set (has been assigned a value) and false otherwise */
  public boolean isSetMaxPerInstanceFailures() {
    return EncodingUtils.testBit(__isset_bitfield, __MAXPERINSTANCEFAILURES_ISSET_ID);
  }

  public void setMaxPerInstanceFailuresIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __MAXPERINSTANCEFAILURES_ISSET_ID, value);
  }

  /**
   * Max number of FAILED instances to tolerate before terminating the update.
   */
  public int getMaxFailedInstances() {
    return this.maxFailedInstances;
  }

  /**
   * Max number of FAILED instances to tolerate before terminating the update.
   */
  public JobUpdateSettings setMaxFailedInstances(int maxFailedInstances) {
    this.maxFailedInstances = maxFailedInstances;
    setMaxFailedInstancesIsSet(true);
    return this;
  }

  public void unsetMaxFailedInstances() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __MAXFAILEDINSTANCES_ISSET_ID);
  }

  /** Returns true if field maxFailedInstances is set (has been assigned a value) and false otherwise */
  public boolean isSetMaxFailedInstances() {
    return EncodingUtils.testBit(__isset_bitfield, __MAXFAILEDINSTANCES_ISSET_ID);
  }

  public void setMaxFailedInstancesIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __MAXFAILEDINSTANCES_ISSET_ID, value);
  }

  /**
   * Min time to watch a RUNNING instance.
   */
  public int getMinWaitInInstanceRunningMs() {
    return this.minWaitInInstanceRunningMs;
  }

  /**
   * Min time to watch a RUNNING instance.
   */
  public JobUpdateSettings setMinWaitInInstanceRunningMs(int minWaitInInstanceRunningMs) {
    this.minWaitInInstanceRunningMs = minWaitInInstanceRunningMs;
    setMinWaitInInstanceRunningMsIsSet(true);
    return this;
  }

  public void unsetMinWaitInInstanceRunningMs() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __MINWAITININSTANCERUNNINGMS_ISSET_ID);
  }

  /** Returns true if field minWaitInInstanceRunningMs is set (has been assigned a value) and false otherwise */
  public boolean isSetMinWaitInInstanceRunningMs() {
    return EncodingUtils.testBit(__isset_bitfield, __MINWAITININSTANCERUNNINGMS_ISSET_ID);
  }

  public void setMinWaitInInstanceRunningMsIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __MINWAITININSTANCERUNNINGMS_ISSET_ID, value);
  }

  /**
   * If true, enables failed update rollback.
   */
  public boolean isRollbackOnFailure() {
    return this.rollbackOnFailure;
  }

  /**
   * If true, enables failed update rollback.
   */
  public JobUpdateSettings setRollbackOnFailure(boolean rollbackOnFailure) {
    this.rollbackOnFailure = rollbackOnFailure;
    setRollbackOnFailureIsSet(true);
    return this;
  }

  public void unsetRollbackOnFailure() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __ROLLBACKONFAILURE_ISSET_ID);
  }

  /** Returns true if field rollbackOnFailure is set (has been assigned a value) and false otherwise */
  public boolean isSetRollbackOnFailure() {
    return EncodingUtils.testBit(__isset_bitfield, __ROLLBACKONFAILURE_ISSET_ID);
  }

  public void setRollbackOnFailureIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __ROLLBACKONFAILURE_ISSET_ID, value);
  }

  public int getUpdateOnlyTheseInstancesSize() {
    return (this.updateOnlyTheseInstances == null) ? 0 : this.updateOnlyTheseInstances.size();
  }

  public java.util.Iterator<Range> getUpdateOnlyTheseInstancesIterator() {
    return (this.updateOnlyTheseInstances == null) ? null : this.updateOnlyTheseInstances.iterator();
  }

  public void addToUpdateOnlyTheseInstances(Range elem) {
    if (this.updateOnlyTheseInstances == null) {
      this.updateOnlyTheseInstances = new HashSet<Range>();
    }
    this.updateOnlyTheseInstances.add(elem);
  }

  /**
   * Instance IDs to act on. All instances will be affected if this is not set.
   */
  public Set<Range> getUpdateOnlyTheseInstances() {
    return this.updateOnlyTheseInstances;
  }

  /**
   * Instance IDs to act on. All instances will be affected if this is not set.
   */
  public JobUpdateSettings setUpdateOnlyTheseInstances(Set<Range> updateOnlyTheseInstances) {
    this.updateOnlyTheseInstances = updateOnlyTheseInstances;
    return this;
  }

  public void unsetUpdateOnlyTheseInstances() {
    this.updateOnlyTheseInstances = null;
  }

  /** Returns true if field updateOnlyTheseInstances is set (has been assigned a value) and false otherwise */
  public boolean isSetUpdateOnlyTheseInstances() {
    return this.updateOnlyTheseInstances != null;
  }

  public void setUpdateOnlyTheseInstancesIsSet(boolean value) {
    if (!value) {
      this.updateOnlyTheseInstances = null;
    }
  }

  /**
   * If true, use updateGroupSize as strict batching boundaries, and avoid proceeding to another
   * batch until the preceding batch finishes updating.
   */
  public boolean isWaitForBatchCompletion() {
    return this.waitForBatchCompletion;
  }

  /**
   * If true, use updateGroupSize as strict batching boundaries, and avoid proceeding to another
   * batch until the preceding batch finishes updating.
   */
  public JobUpdateSettings setWaitForBatchCompletion(boolean waitForBatchCompletion) {
    this.waitForBatchCompletion = waitForBatchCompletion;
    setWaitForBatchCompletionIsSet(true);
    return this;
  }

  public void unsetWaitForBatchCompletion() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __WAITFORBATCHCOMPLETION_ISSET_ID);
  }

  /** Returns true if field waitForBatchCompletion is set (has been assigned a value) and false otherwise */
  public boolean isSetWaitForBatchCompletion() {
    return EncodingUtils.testBit(__isset_bitfield, __WAITFORBATCHCOMPLETION_ISSET_ID);
  }

  public void setWaitForBatchCompletionIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __WAITFORBATCHCOMPLETION_ISSET_ID, value);
  }

  /**
   * If set, requires external calls to pulseJobUpdate RPC within the specified rate for the
   * update to make progress. If no pulses received within specified interval the update will
   * block. A blocked update is unable to continue but retains its current status. It may only get
   * unblocked by a fresh pulseJobUpdate call.
   */
  public int getBlockIfNoPulsesAfterMs() {
    return this.blockIfNoPulsesAfterMs;
  }

  /**
   * If set, requires external calls to pulseJobUpdate RPC within the specified rate for the
   * update to make progress. If no pulses received within specified interval the update will
   * block. A blocked update is unable to continue but retains its current status. It may only get
   * unblocked by a fresh pulseJobUpdate call.
   */
  public JobUpdateSettings setBlockIfNoPulsesAfterMs(int blockIfNoPulsesAfterMs) {
    this.blockIfNoPulsesAfterMs = blockIfNoPulsesAfterMs;
    setBlockIfNoPulsesAfterMsIsSet(true);
    return this;
  }

  public void unsetBlockIfNoPulsesAfterMs() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __BLOCKIFNOPULSESAFTERMS_ISSET_ID);
  }

  /** Returns true if field blockIfNoPulsesAfterMs is set (has been assigned a value) and false otherwise */
  public boolean isSetBlockIfNoPulsesAfterMs() {
    return EncodingUtils.testBit(__isset_bitfield, __BLOCKIFNOPULSESAFTERMS_ISSET_ID);
  }

  public void setBlockIfNoPulsesAfterMsIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __BLOCKIFNOPULSESAFTERMS_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case UPDATE_GROUP_SIZE:
      if (value == null) {
        unsetUpdateGroupSize();
      } else {
        setUpdateGroupSize((Integer)value);
      }
      break;

    case MAX_PER_INSTANCE_FAILURES:
      if (value == null) {
        unsetMaxPerInstanceFailures();
      } else {
        setMaxPerInstanceFailures((Integer)value);
      }
      break;

    case MAX_FAILED_INSTANCES:
      if (value == null) {
        unsetMaxFailedInstances();
      } else {
        setMaxFailedInstances((Integer)value);
      }
      break;

    case MIN_WAIT_IN_INSTANCE_RUNNING_MS:
      if (value == null) {
        unsetMinWaitInInstanceRunningMs();
      } else {
        setMinWaitInInstanceRunningMs((Integer)value);
      }
      break;

    case ROLLBACK_ON_FAILURE:
      if (value == null) {
        unsetRollbackOnFailure();
      } else {
        setRollbackOnFailure((Boolean)value);
      }
      break;

    case UPDATE_ONLY_THESE_INSTANCES:
      if (value == null) {
        unsetUpdateOnlyTheseInstances();
      } else {
        setUpdateOnlyTheseInstances((Set<Range>)value);
      }
      break;

    case WAIT_FOR_BATCH_COMPLETION:
      if (value == null) {
        unsetWaitForBatchCompletion();
      } else {
        setWaitForBatchCompletion((Boolean)value);
      }
      break;

    case BLOCK_IF_NO_PULSES_AFTER_MS:
      if (value == null) {
        unsetBlockIfNoPulsesAfterMs();
      } else {
        setBlockIfNoPulsesAfterMs((Integer)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case UPDATE_GROUP_SIZE:
      return getUpdateGroupSize();

    case MAX_PER_INSTANCE_FAILURES:
      return getMaxPerInstanceFailures();

    case MAX_FAILED_INSTANCES:
      return getMaxFailedInstances();

    case MIN_WAIT_IN_INSTANCE_RUNNING_MS:
      return getMinWaitInInstanceRunningMs();

    case ROLLBACK_ON_FAILURE:
      return isRollbackOnFailure();

    case UPDATE_ONLY_THESE_INSTANCES:
      return getUpdateOnlyTheseInstances();

    case WAIT_FOR_BATCH_COMPLETION:
      return isWaitForBatchCompletion();

    case BLOCK_IF_NO_PULSES_AFTER_MS:
      return getBlockIfNoPulsesAfterMs();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case UPDATE_GROUP_SIZE:
      return isSetUpdateGroupSize();
    case MAX_PER_INSTANCE_FAILURES:
      return isSetMaxPerInstanceFailures();
    case MAX_FAILED_INSTANCES:
      return isSetMaxFailedInstances();
    case MIN_WAIT_IN_INSTANCE_RUNNING_MS:
      return isSetMinWaitInInstanceRunningMs();
    case ROLLBACK_ON_FAILURE:
      return isSetRollbackOnFailure();
    case UPDATE_ONLY_THESE_INSTANCES:
      return isSetUpdateOnlyTheseInstances();
    case WAIT_FOR_BATCH_COMPLETION:
      return isSetWaitForBatchCompletion();
    case BLOCK_IF_NO_PULSES_AFTER_MS:
      return isSetBlockIfNoPulsesAfterMs();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof JobUpdateSettings)
      return this.equals((JobUpdateSettings)that);
    return false;
  }

  public boolean equals(JobUpdateSettings that) {
    if (that == null)
      return false;

    boolean this_present_updateGroupSize = true;
    boolean that_present_updateGroupSize = true;
    if (this_present_updateGroupSize || that_present_updateGroupSize) {
      if (!(this_present_updateGroupSize && that_present_updateGroupSize))
        return false;
      if (this.updateGroupSize != that.updateGroupSize)
        return false;
    }

    boolean this_present_maxPerInstanceFailures = true;
    boolean that_present_maxPerInstanceFailures = true;
    if (this_present_maxPerInstanceFailures || that_present_maxPerInstanceFailures) {
      if (!(this_present_maxPerInstanceFailures && that_present_maxPerInstanceFailures))
        return false;
      if (this.maxPerInstanceFailures != that.maxPerInstanceFailures)
        return false;
    }

    boolean this_present_maxFailedInstances = true;
    boolean that_present_maxFailedInstances = true;
    if (this_present_maxFailedInstances || that_present_maxFailedInstances) {
      if (!(this_present_maxFailedInstances && that_present_maxFailedInstances))
        return false;
      if (this.maxFailedInstances != that.maxFailedInstances)
        return false;
    }

    boolean this_present_minWaitInInstanceRunningMs = true;
    boolean that_present_minWaitInInstanceRunningMs = true;
    if (this_present_minWaitInInstanceRunningMs || that_present_minWaitInInstanceRunningMs) {
      if (!(this_present_minWaitInInstanceRunningMs && that_present_minWaitInInstanceRunningMs))
        return false;
      if (this.minWaitInInstanceRunningMs != that.minWaitInInstanceRunningMs)
        return false;
    }

    boolean this_present_rollbackOnFailure = true;
    boolean that_present_rollbackOnFailure = true;
    if (this_present_rollbackOnFailure || that_present_rollbackOnFailure) {
      if (!(this_present_rollbackOnFailure && that_present_rollbackOnFailure))
        return false;
      if (this.rollbackOnFailure != that.rollbackOnFailure)
        return false;
    }

    boolean this_present_updateOnlyTheseInstances = true && this.isSetUpdateOnlyTheseInstances();
    boolean that_present_updateOnlyTheseInstances = true && that.isSetUpdateOnlyTheseInstances();
    if (this_present_updateOnlyTheseInstances || that_present_updateOnlyTheseInstances) {
      if (!(this_present_updateOnlyTheseInstances && that_present_updateOnlyTheseInstances))
        return false;
      if (!this.updateOnlyTheseInstances.equals(that.updateOnlyTheseInstances))
        return false;
    }

    boolean this_present_waitForBatchCompletion = true;
    boolean that_present_waitForBatchCompletion = true;
    if (this_present_waitForBatchCompletion || that_present_waitForBatchCompletion) {
      if (!(this_present_waitForBatchCompletion && that_present_waitForBatchCompletion))
        return false;
      if (this.waitForBatchCompletion != that.waitForBatchCompletion)
        return false;
    }

    boolean this_present_blockIfNoPulsesAfterMs = true && this.isSetBlockIfNoPulsesAfterMs();
    boolean that_present_blockIfNoPulsesAfterMs = true && that.isSetBlockIfNoPulsesAfterMs();
    if (this_present_blockIfNoPulsesAfterMs || that_present_blockIfNoPulsesAfterMs) {
      if (!(this_present_blockIfNoPulsesAfterMs && that_present_blockIfNoPulsesAfterMs))
        return false;
      if (this.blockIfNoPulsesAfterMs != that.blockIfNoPulsesAfterMs)
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_updateGroupSize = true;
    list.add(present_updateGroupSize);
    if (present_updateGroupSize)
      list.add(updateGroupSize);

    boolean present_maxPerInstanceFailures = true;
    list.add(present_maxPerInstanceFailures);
    if (present_maxPerInstanceFailures)
      list.add(maxPerInstanceFailures);

    boolean present_maxFailedInstances = true;
    list.add(present_maxFailedInstances);
    if (present_maxFailedInstances)
      list.add(maxFailedInstances);

    boolean present_minWaitInInstanceRunningMs = true;
    list.add(present_minWaitInInstanceRunningMs);
    if (present_minWaitInInstanceRunningMs)
      list.add(minWaitInInstanceRunningMs);

    boolean present_rollbackOnFailure = true;
    list.add(present_rollbackOnFailure);
    if (present_rollbackOnFailure)
      list.add(rollbackOnFailure);

    boolean present_updateOnlyTheseInstances = true && (isSetUpdateOnlyTheseInstances());
    list.add(present_updateOnlyTheseInstances);
    if (present_updateOnlyTheseInstances)
      list.add(updateOnlyTheseInstances);

    boolean present_waitForBatchCompletion = true;
    list.add(present_waitForBatchCompletion);
    if (present_waitForBatchCompletion)
      list.add(waitForBatchCompletion);

    boolean present_blockIfNoPulsesAfterMs = true && (isSetBlockIfNoPulsesAfterMs());
    list.add(present_blockIfNoPulsesAfterMs);
    if (present_blockIfNoPulsesAfterMs)
      list.add(blockIfNoPulsesAfterMs);

    return list.hashCode();
  }

  @Override
  public int compareTo(JobUpdateSettings other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetUpdateGroupSize()).compareTo(other.isSetUpdateGroupSize());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUpdateGroupSize()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateGroupSize, other.updateGroupSize);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMaxPerInstanceFailures()).compareTo(other.isSetMaxPerInstanceFailures());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMaxPerInstanceFailures()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.maxPerInstanceFailures, other.maxPerInstanceFailures);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMaxFailedInstances()).compareTo(other.isSetMaxFailedInstances());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMaxFailedInstances()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.maxFailedInstances, other.maxFailedInstances);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetMinWaitInInstanceRunningMs()).compareTo(other.isSetMinWaitInInstanceRunningMs());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetMinWaitInInstanceRunningMs()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.minWaitInInstanceRunningMs, other.minWaitInInstanceRunningMs);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetRollbackOnFailure()).compareTo(other.isSetRollbackOnFailure());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetRollbackOnFailure()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.rollbackOnFailure, other.rollbackOnFailure);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetUpdateOnlyTheseInstances()).compareTo(other.isSetUpdateOnlyTheseInstances());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetUpdateOnlyTheseInstances()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateOnlyTheseInstances, other.updateOnlyTheseInstances);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetWaitForBatchCompletion()).compareTo(other.isSetWaitForBatchCompletion());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetWaitForBatchCompletion()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.waitForBatchCompletion, other.waitForBatchCompletion);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetBlockIfNoPulsesAfterMs()).compareTo(other.isSetBlockIfNoPulsesAfterMs());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetBlockIfNoPulsesAfterMs()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.blockIfNoPulsesAfterMs, other.blockIfNoPulsesAfterMs);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("JobUpdateSettings(");
    boolean first = true;

    sb.append("updateGroupSize:");
    sb.append(this.updateGroupSize);
    first = false;
    if (!first) sb.append(", ");
    sb.append("maxPerInstanceFailures:");
    sb.append(this.maxPerInstanceFailures);
    first = false;
    if (!first) sb.append(", ");
    sb.append("maxFailedInstances:");
    sb.append(this.maxFailedInstances);
    first = false;
    if (!first) sb.append(", ");
    sb.append("minWaitInInstanceRunningMs:");
    sb.append(this.minWaitInInstanceRunningMs);
    first = false;
    if (!first) sb.append(", ");
    sb.append("rollbackOnFailure:");
    sb.append(this.rollbackOnFailure);
    first = false;
    if (!first) sb.append(", ");
    sb.append("updateOnlyTheseInstances:");
    if (this.updateOnlyTheseInstances == null) {
      sb.append("null");
    } else {
      sb.append(this.updateOnlyTheseInstances);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("waitForBatchCompletion:");
    sb.append(this.waitForBatchCompletion);
    first = false;
    if (isSetBlockIfNoPulsesAfterMs()) {
      if (!first) sb.append(", ");
      sb.append("blockIfNoPulsesAfterMs:");
      sb.append(this.blockIfNoPulsesAfterMs);
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class JobUpdateSettingsStandardSchemeFactory implements SchemeFactory {
    public JobUpdateSettingsStandardScheme getScheme() {
      return new JobUpdateSettingsStandardScheme();
    }
  }

  private static class JobUpdateSettingsStandardScheme extends StandardScheme<JobUpdateSettings> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, JobUpdateSettings struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 1: // UPDATE_GROUP_SIZE
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.updateGroupSize = iprot.readI32();
              struct.setUpdateGroupSizeIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // MAX_PER_INSTANCE_FAILURES
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.maxPerInstanceFailures = iprot.readI32();
              struct.setMaxPerInstanceFailuresIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // MAX_FAILED_INSTANCES
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.maxFailedInstances = iprot.readI32();
              struct.setMaxFailedInstancesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // MIN_WAIT_IN_INSTANCE_RUNNING_MS
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.minWaitInInstanceRunningMs = iprot.readI32();
              struct.setMinWaitInInstanceRunningMsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // ROLLBACK_ON_FAILURE
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.rollbackOnFailure = iprot.readBool();
              struct.setRollbackOnFailureIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // UPDATE_ONLY_THESE_INSTANCES
            if (schemeField.type == org.apache.thrift.protocol.TType.SET) {
              {
                org.apache.thrift.protocol.TSet _set190 = iprot.readSetBegin();
                struct.updateOnlyTheseInstances = new HashSet<Range>(2*_set190.size);
                Range _elem191;
                for (int _i192 = 0; _i192 < _set190.size; ++_i192)
                {
                  _elem191 = new Range();
                  _elem191.read(iprot);
                  struct.updateOnlyTheseInstances.add(_elem191);
                }
                iprot.readSetEnd();
              }
              struct.setUpdateOnlyTheseInstancesIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // WAIT_FOR_BATCH_COMPLETION
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.waitForBatchCompletion = iprot.readBool();
              struct.setWaitForBatchCompletionIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 9: // BLOCK_IF_NO_PULSES_AFTER_MS
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.blockIfNoPulsesAfterMs = iprot.readI32();
              struct.setBlockIfNoPulsesAfterMsIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, JobUpdateSettings struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(UPDATE_GROUP_SIZE_FIELD_DESC);
      oprot.writeI32(struct.updateGroupSize);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(MAX_PER_INSTANCE_FAILURES_FIELD_DESC);
      oprot.writeI32(struct.maxPerInstanceFailures);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(MAX_FAILED_INSTANCES_FIELD_DESC);
      oprot.writeI32(struct.maxFailedInstances);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(MIN_WAIT_IN_INSTANCE_RUNNING_MS_FIELD_DESC);
      oprot.writeI32(struct.minWaitInInstanceRunningMs);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(ROLLBACK_ON_FAILURE_FIELD_DESC);
      oprot.writeBool(struct.rollbackOnFailure);
      oprot.writeFieldEnd();
      if (struct.updateOnlyTheseInstances != null) {
        oprot.writeFieldBegin(UPDATE_ONLY_THESE_INSTANCES_FIELD_DESC);
        {
          oprot.writeSetBegin(new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, struct.updateOnlyTheseInstances.size()));
          for (Range _iter193 : struct.updateOnlyTheseInstances)
          {
            _iter193.write(oprot);
          }
          oprot.writeSetEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(WAIT_FOR_BATCH_COMPLETION_FIELD_DESC);
      oprot.writeBool(struct.waitForBatchCompletion);
      oprot.writeFieldEnd();
      if (struct.isSetBlockIfNoPulsesAfterMs()) {
        oprot.writeFieldBegin(BLOCK_IF_NO_PULSES_AFTER_MS_FIELD_DESC);
        oprot.writeI32(struct.blockIfNoPulsesAfterMs);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class JobUpdateSettingsTupleSchemeFactory implements SchemeFactory {
    public JobUpdateSettingsTupleScheme getScheme() {
      return new JobUpdateSettingsTupleScheme();
    }
  }

  private static class JobUpdateSettingsTupleScheme extends TupleScheme<JobUpdateSettings> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, JobUpdateSettings struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      BitSet optionals = new BitSet();
      if (struct.isSetUpdateGroupSize()) {
        optionals.set(0);
      }
      if (struct.isSetMaxPerInstanceFailures()) {
        optionals.set(1);
      }
      if (struct.isSetMaxFailedInstances()) {
        optionals.set(2);
      }
      if (struct.isSetMinWaitInInstanceRunningMs()) {
        optionals.set(3);
      }
      if (struct.isSetRollbackOnFailure()) {
        optionals.set(4);
      }
      if (struct.isSetUpdateOnlyTheseInstances()) {
        optionals.set(5);
      }
      if (struct.isSetWaitForBatchCompletion()) {
        optionals.set(6);
      }
      if (struct.isSetBlockIfNoPulsesAfterMs()) {
        optionals.set(7);
      }
      oprot.writeBitSet(optionals, 8);
      if (struct.isSetUpdateGroupSize()) {
        oprot.writeI32(struct.updateGroupSize);
      }
      if (struct.isSetMaxPerInstanceFailures()) {
        oprot.writeI32(struct.maxPerInstanceFailures);
      }
      if (struct.isSetMaxFailedInstances()) {
        oprot.writeI32(struct.maxFailedInstances);
      }
      if (struct.isSetMinWaitInInstanceRunningMs()) {
        oprot.writeI32(struct.minWaitInInstanceRunningMs);
      }
      if (struct.isSetRollbackOnFailure()) {
        oprot.writeBool(struct.rollbackOnFailure);
      }
      if (struct.isSetUpdateOnlyTheseInstances()) {
        {
          oprot.writeI32(struct.updateOnlyTheseInstances.size());
          for (Range _iter194 : struct.updateOnlyTheseInstances)
          {
            _iter194.write(oprot);
          }
        }
      }
      if (struct.isSetWaitForBatchCompletion()) {
        oprot.writeBool(struct.waitForBatchCompletion);
      }
      if (struct.isSetBlockIfNoPulsesAfterMs()) {
        oprot.writeI32(struct.blockIfNoPulsesAfterMs);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, JobUpdateSettings struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      BitSet incoming = iprot.readBitSet(8);
      if (incoming.get(0)) {
        struct.updateGroupSize = iprot.readI32();
        struct.setUpdateGroupSizeIsSet(true);
      }
      if (incoming.get(1)) {
        struct.maxPerInstanceFailures = iprot.readI32();
        struct.setMaxPerInstanceFailuresIsSet(true);
      }
      if (incoming.get(2)) {
        struct.maxFailedInstances = iprot.readI32();
        struct.setMaxFailedInstancesIsSet(true);
      }
      if (incoming.get(3)) {
        struct.minWaitInInstanceRunningMs = iprot.readI32();
        struct.setMinWaitInInstanceRunningMsIsSet(true);
      }
      if (incoming.get(4)) {
        struct.rollbackOnFailure = iprot.readBool();
        struct.setRollbackOnFailureIsSet(true);
      }
      if (incoming.get(5)) {
        {
          org.apache.thrift.protocol.TSet _set195 = new org.apache.thrift.protocol.TSet(org.apache.thrift.protocol.TType.STRUCT, iprot.readI32());
          struct.updateOnlyTheseInstances = new HashSet<Range>(2*_set195.size);
          Range _elem196;
          for (int _i197 = 0; _i197 < _set195.size; ++_i197)
          {
            _elem196 = new Range();
            _elem196.read(iprot);
            struct.updateOnlyTheseInstances.add(_elem196);
          }
        }
        struct.setUpdateOnlyTheseInstancesIsSet(true);
      }
      if (incoming.get(6)) {
        struct.waitForBatchCompletion = iprot.readBool();
        struct.setWaitForBatchCompletionIsSet(true);
      }
      if (incoming.get(7)) {
        struct.blockIfNoPulsesAfterMs = iprot.readI32();
        struct.setBlockIfNoPulsesAfterMsIsSet(true);
      }
    }
  }

}

