/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class PdfStamperImp
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    int[] myXref;
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        }
        super.open();
    }

    void close(HashMap hashMap) throws DocumentException, IOException {
        PdfObject pdfObject;
        Object object;
        Object object2;
        PdfDictionary pdfDictionary;
        Object object3;
        if (this.closed) {
            return;
        }
        if (this.flat) {
            this.flatFields();
        }
        this.closed = true;
        this.myXref = new int[this.reader.xrefObj.length];
        this.addSharedObjectsToBody();
        PRIndirectReference pRIndirectReference = null;
        try {
            this.file.reOpen();
            this.alterContents();
            object3 = this.reader.xrefObj;
            boolean bl = true;
            pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n = -1;
            if (pRIndirectReference != null) {
                n = pRIndirectReference.getNumber();
            }
            int n2 = 1;
            while (n2 < ((PdfObject[])object3).length) {
                if (object3[n2] != null && n != n2) {
                    this.addToBody(object3[n2], this.getNewObjectNumber(this.reader, n2, 0));
                }
                ++n2;
            }
            pdfDictionary = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                this.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.file.close();
        }
        catch (Exception object4) {}
        object3 = null;
        PdfObject pdfObject2 = null;
        if (this.crypto != null) {
            PdfIndirectObject pdfIndirectObject = this.body.add(this.crypto.getEncryptionDictionary());
            object3 = pdfIndirectObject.getIndirectReference();
            pdfObject2 = this.crypto.getFileID();
        }
        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference2.getNumber(), 0));
        PdfIndirectReference pdfIndirectReference2 = null;
        pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        object4 = new PdfDictionary();
        if (pdfDictionary != null) {
            object2 = pdfDictionary.getKeys().iterator();
            while (object2.hasNext()) {
                object = (PdfName)object2.next();
                pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)object));
                ((PdfDictionary)object4).put((PdfName)object, pdfObject);
            }
        }
        if (hashMap != null) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                pdfObject = new PdfName((String)object);
                String string = (String)hashMap.get(object);
                if (string == null) {
                    ((PdfDictionary)object4).remove((PdfName)pdfObject);
                    continue;
                }
                ((PdfDictionary)object4).put((PdfName)pdfObject, new PdfString(string, "UnicodeBig"));
            }
        }
        if (!((PdfDictionary)object4).getKeys().isEmpty()) {
            pdfIndirectReference2 = this.addToBody((PdfObject)object4).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os);
        object2 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference, pdfIndirectReference2, (PdfIndirectReference)object3, pdfObject2);
        ((PdfWriter.PdfTrailer)object2).toPdf(this, this.os);
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
    }

    void applyRotation(int n, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n);
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            byteBuffer.append(this.reader.getPageContent(n, this.file));
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            this.reader.setPageContent(n, byteBuffer.toByteArray());
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        PdfDictionary pdfDictionary = this.reader.getPageN(pageStamp.pageNumber);
        pdfDictionary.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        if (this.currentPdfReaderInstance == null) {
            if (this.myXref[n] == 0) {
                this.myXref[n] = this.getIndirectReferenceNumber();
            }
            return this.myXref[n];
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PageStamp getPageStamp(int n) {
        Integer n2 = new Integer(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n2);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, n);
            this.pagesToContent.put(n2, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, n);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, n);
        }
        return pageStamp.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    void flatFields() {
        PdfObject pdfObject;
        int n;
        Object object;
        PdfObject pdfObject2;
        this.getAcroFields();
        HashMap hashMap = this.acroFields.getFields();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            AcroFields.Item item = (AcroFields.Item)iterator.next();
            int n2 = 0;
            while (n2 < item.merged.size()) {
                pdfObject2 = (PdfDictionary)item.merged.get(n2);
                object = (PdfNumber)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.F));
                n = 0;
                if (object != null) {
                    n = ((PdfNumber)object).intValue();
                }
                if ((n & 4) != 0 && (n & 2) == 0 && (pdfObject = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.AP))) != null) {
                    PdfIndirectReference pdfIndirectReference;
                    Object object2;
                    PdfObject pdfObject3 = ((PdfDictionary)pdfObject).get(PdfName.N);
                    PdfAppearance pdfAppearance = null;
                    PdfObject pdfObject4 = PdfReader.getPdfObject(pdfObject3);
                    if (pdfObject3 instanceof PdfIndirectReference && pdfObject3.type() != 10) {
                        pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                    } else if (pdfObject4 instanceof PdfStream) {
                        ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                        pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject3);
                    } else if (pdfObject4.type() == 6 && (object2 = (PdfName)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.AS))) != null && (pdfIndirectReference = (PdfIndirectReference)((PdfDictionary)pdfObject4).get((PdfName)object2)) != null) {
                        pdfAppearance = new PdfAppearance(pdfIndirectReference);
                        if (pdfIndirectReference.type() == 10) {
                            pdfObject4 = PdfReader.getPdfObject(pdfIndirectReference);
                            ((PdfDictionary)pdfObject4).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (pdfAppearance != null) {
                        object2 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(((PdfDictionary)pdfObject2).get(PdfName.RECT)));
                        int n3 = (Integer)item.page.get(n2);
                        PdfContentByte pdfContentByte = this.getOverContent(n3);
                        pdfContentByte.setLiteral("Q ");
                        pdfContentByte.addTemplate(pdfAppearance, ((Rectangle)object2).left(), ((Rectangle)object2).bottom());
                        pdfContentByte.setLiteral("q ");
                    }
                }
                ++n2;
            }
        }
        int n4 = 1;
        while (n4 <= this.reader.getNumberOfPages()) {
            PdfDictionary pdfDictionary = this.reader.getPageN(n4);
            pdfObject2 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfObject2 != null) {
                object = ((PdfArray)pdfObject2).getArrayList();
                n = 0;
                while (n < ((ArrayList)object).size()) {
                    pdfObject = (PdfDictionary)PdfReader.getPdfObject((PdfObject)((ArrayList)object).get(n));
                    if (PdfName.WIDGET.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) {
                        ((ArrayList)object).remove(n);
                        --n;
                    }
                    ++n;
                }
                if (((ArrayList)object).size() == 0) {
                    pdfObject = pdfDictionary.get(PdfName.ANNOTS);
                    if (pdfObject.type() == 10) {
                        this.reader.xrefObj[((PRIndirectReference)pdfObject).getNumber()] = null;
                    }
                    pdfDictionary.remove(PdfName.ANNOTS);
                }
            }
            ++n4;
        }
        this.eliminateAcroformObjects();
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
        }
        PdfReader.killIndirect(pdfObject);
        this.reader.getCatalog().remove(PdfName.ACROFORM);
    }

    void sweepKids(PdfObject pdfObject) {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.killIndirect(pdfObject);
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            this.sweepKids((PdfObject)arrayList.get(n));
            ++n;
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        try {
            if (pdfAnnotation.isForm()) {
                throw new RuntimeException("Form fields not yet supported.");
            }
            PdfRectangle pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT);
            int n2 = this.reader.getPageRotation(n);
            Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
            switch (n2) {
                case 90: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                    break;
                }
                case 180: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                    break;
                }
                case 270: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                }
            }
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfArray == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.ANNOTS, pdfArray);
            }
            PdfIndirectReference pdfIndirectReference = this.addToBody(pdfAnnotation).getIndirectReference();
            pdfArray.add(pdfIndirectReference);
            pdfAnnotation.put(PdfName.RECT, pdfRectangle);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp2, PdfReader pdfReader, int n) {
            this.pageNumber = n;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary = pdfReader.getPageN(n);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfReader);
        }
    }
}

