/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode128
extends Barcode {
    static byte[][] BARS = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    static byte[] BARS_STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1 = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean isNextDigits(String var0, int var1_1, int var2_2) {
        if (var1_1 + var2_2 <= var0.length()) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((var3_3 = var0.charAt(var1_1++)) >= '0' && var3_3 <= '9') continue;
            return false;
lbl5:
            // 2 sources

            ** while (var2_2-- > 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    static String getPackedRawDigits(String string, int n, int n2) {
        String string2 = "";
        while (n2 > 0) {
            n2 -= 2;
            int n3 = string.charAt(n++) - 48;
            int n4 = string.charAt(n++) - 48;
            string2 = string2 + (char)(n3 * 10 + n4);
        }
        return string2;
    }

    public static String getRawText(String string, boolean bl) {
        String string2 = "";
        int n = string.length();
        if (n == 0) {
            string2 = string2 + 'h';
            if (bl) {
                string2 = string2 + 'f';
            }
            return string2;
        }
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c > '\u007f') {
                throw new RuntimeException("There are illegal characters for barcode 128 in '" + string + "'.");
            }
            ++n2;
        }
        c = string.charAt(0);
        int n3 = 104;
        int n4 = 0;
        if (Barcode128.isNextDigits(string, n4, 2)) {
            n3 = 105;
            string2 = string2 + (char)n3;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + Barcode128.getPackedRawDigits(string, n4, 2);
            n4 += 2;
        } else if (c < ' ') {
            n3 = 103;
            string2 = string2 + (char)n3;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c + 64);
            ++n4;
        } else {
            string2 = string2 + (char)n3;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c - 32);
            ++n4;
        }
        while (n4 < n) {
            switch (n3) {
                case 103: {
                    if (Barcode128.isNextDigits(string, n4, 4)) {
                        n3 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n4, 4);
                        n4 += 4;
                        break;
                    }
                    if ((c = string.charAt(n4++)) > '_') {
                        n3 = 104;
                        string2 = string2 + 'd';
                        string2 = string2 + (char)(c - 32);
                        break;
                    }
                    if (c < ' ') {
                        string2 = string2 + (char)(c + 64);
                        break;
                    }
                    string2 = string2 + (char)(c - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.isNextDigits(string, n4, 4)) {
                        n3 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n4, 4);
                        n4 += 4;
                        break;
                    }
                    if ((c = string.charAt(n4++)) < ' ') {
                        n3 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c + 64);
                        break;
                    }
                    string2 = string2 + (char)(c - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.isNextDigits(string, n4, 2)) {
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n4, 2);
                        n4 += 2;
                        break;
                    }
                    if ((c = string.charAt(n4++)) < ' ') {
                        n3 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c + 64);
                        break;
                    }
                    n3 = 104;
                    string2 = string2 + 'd';
                    string2 = string2 + (char)(c - 32);
                }
            }
        }
        return string2;
    }

    public static byte[] getBarsCode128Raw(String string) {
        int n = string.indexOf(65535);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        int n2 = string.charAt(0);
        int n3 = 1;
        while (n3 < string.length()) {
            n2 += n3 * string.charAt(n3);
            ++n3;
        }
        string = string + (char)(n2 %= 103);
        byte[] byArray = new byte[(string.length() + 1) * 6 + 7];
        int n4 = 0;
        while (n4 < string.length()) {
            System.arraycopy(BARS[string.charAt(n4)], 0, byArray, n4 * 6, 6);
            ++n4;
        }
        System.arraycopy(BARS_STOP, 0, byArray, n4 * 6, 7);
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        int n;
        String string;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.codeType == 11) {
                n = this.code.indexOf(65535);
                string = n < 0 ? "" : this.code.substring(n + 1);
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 11 ? ((n = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n = string.length();
        float f3 = (float)((n + 2) * 11) * this.x + 2.0f * this.x;
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        int n;
        String string = this.code;
        if (this.codeType == 11) {
            int n2 = this.code.indexOf(65535);
            string = n2 < 0 ? "" : this.code.substring(n2 + 1);
        }
        float f = 0.0f;
        if (this.font != null) {
            f = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.codeType == 11 ? ((n = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n = string2.length();
        float f2 = (float)((n + 2) * 11) * this.x + 2.0f * this.x;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f2) {
                    f3 = f - f2;
                    break;
                }
                f4 = f2 - f;
                break;
            }
            default: {
                if (f > f2) {
                    f3 = (f - f2) / 2.0f;
                    break;
                }
                f4 = (f2 - f) / 2.0f;
            }
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f6 = this.barHeight - this.baseline;
            } else {
                f6 = -this.font.getFontDescriptor(3, this.size);
                f5 = f6 + this.baseline;
            }
        }
        byte[] byArray = Barcode128.getBarsCode128Raw(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n3 = 0;
        while (n3 < byArray.length) {
            float f7 = (float)byArray[n3] * this.x;
            if (bl) {
                pdfContentByte.rectangle(f3, f5, f7 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f3 += f7;
            ++n3;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f4, f6);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n;
        int n2;
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = this.codeType == 11 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string.length();
        int n5 = (n2 + 2) * 11 + 2;
        byte[] byArray = Barcode128.getBarsCode128Raw(string);
        boolean bl = true;
        int n6 = 0;
        int n7 = (int)this.barHeight;
        int[] nArray = new int[n5 * n7];
        int n8 = 0;
        while (n8 < byArray.length) {
            n = byArray[n8];
            int n9 = n4;
            if (bl) {
                n9 = n3;
            }
            bl = !bl;
            int n10 = 0;
            while (n10 < n) {
                nArray[n6++] = n9;
                ++n10;
            }
            ++n8;
        }
        n = n5;
        while (n < nArray.length) {
            System.arraycopy(nArray, 0, nArray, n, n5);
            n += n5;
        }
        Image image = canvas.createImage(new MemoryImageSource(n5, n7, nArray, 0, n5));
        return image;
    }
}

