/*
 Very simple installer of W32TeX (TeX Live 2015/W32TeX)

 Usage   : texinst2015 dir

 Here dir is the full name of the directory where packages are saved.
 Example : texinst2015 c:/temp

 Current directory must be the installation directory of TeX,
 e.g., c:/w32tex. It is assumed that tar.exe, gzip.exe, bzip2.exe
 and xz.exe can be found in the command path.

 (--ak)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <process.h>
#include <direct.h>

#ifndef R_OK
#define R_OK 4
#endif

/*
 File names
*/
char *fname[] = {
  "aleph-w32.tar.xz",
  "aleph-w32_tar.xz",
  "aleph-w32_tar.tar",
  "biblatex-biber.tar.xz",
  "biblatex-biber_tar.xz",
  "biblatex-biber_tar.tar",
  "cjkzr.tar.xz",
  "cjkzr_tar.xz",
  "cjkzr_tar.tar",
  "context.tar.xz",
  "context_tar.xz",
  "context_tar.tar",
  "context-doc.tar.xz",
  "context-doc_tar.xz",
  "context-doc_tar.tar",
  "cweb-w32.tar.xz",
  "cweb-w32_tar.xz",
  "cweb-w32_tar.tar",
  "dvi2ps-w32.tar.xz",
  "dvi2ps-w32_tar.xz",
  "dvi2ps-w32_tar.tar",
  "dvi2tty-w32.tar.xz",
  "dvi2tty-w32_tar.xz",
  "dvi2tty-w32_tar.tar",
  "dvipdfm-w32.tar.xz",
  "dvipdfm-w32_tar.xz",
  "dvipdfm-w32_tar.tar",
  "dvipsk-w32.tar.xz",
  "dvipsk-w32_tar.xz",
  "dvipsk-w32_tar.tar",
  "dvitools-w32.tar.xz",
  "dvitools-w32_tar.xz",
  "dvitools-w32_tar.tar",
  "jtex-w32.tar.xz",
  "jtex-w32_tar.xz",
  "jtex-w32_tar.tar",
  "latex.tar.xz",
  "latex_tar.xz",
  "latex_tar.tar",
  "lcdf-typetools-w32.tar.xz",
  "lcdf-typetools-w32_tar.xz",
  "lcdf-typetools-w32_tar.tar",
  "ltxpkgs.tar.xz",
  "ltxpkgs_tar.xz",
  "ltxpkgs_tar.tar",
  "luatex-w32.tar.xz",
  "luatex-w32_tar.xz",
  "luatex-w32_tar.tar",
  "luajittex-w32.tar.xz",
  "luajittex-w32_tar.xz",
  "luajittex-w32_tar.tar",
  "luatex-dev-w32.tar.xz",
  "luatex-dev-w32_tar.xz",
  "luatex-dev-w32_tar.tar",
  "luajittex-dev-w32.tar.xz",
  "luajittex-dev-w32_tar.xz",
  "luajittex-dev-w32_tar.tar",
  "luatexja.tar.xz",
  "luatexja_tar.xz",
  "luatexja_tar.tar",
  "makeindex-w32.tar.xz",
  "makeindex-w32_tar.xz",
  "makeindex-w32_tar.tar",
  "manual.tar.xz",
  "manual_tar.xz",
  "manual_tar.tar",
  "mftools.tar.xz",
  "mftools_tar.xz",
  "mftools_tar.tar",
  "mftrace.tar.xz",
  "mftrace_tar.xz",
  "mftrace_tar.tar",
  "minitoc.tar.xz",
  "minitoc_tar.xz",
  "minitoc_tar.tar",
  "m-tx.tar.xz",
  "m-tx_tar.xz",
  "m-tx_tar.tar",
  "newtxpx-boondoxfonts.tar.xz",
  "newtxpx-boondoxfonts_tar.xz",
  "newtxpx-boondoxfonts_tar.tar",
  "omegaj-w32.tar.xz",
  "omegaj-w32_tar.xz",
  "omegaj-w32_tar.tar",
  "otf.tar.xz",
  "otf_tar.xz",
  "otf_tar.tar",
  "otfdevel.tar.xz",
  "otfdevel_tar.xz",
  "otfdevel_tar.tar",
  "otfbeta.tar.xz",
  "otfbeta_tar.xz",
  "otfbeta_tar.tar",
  "pdftex-w32.tar.xz",
  "pdftex-w32_tar.xz",
  "pdftex-w32_tar.tar",
  "pgfcontrib.tar.xz",
  "pgfcontrib_tar.xz",
  "pgfcontrib_tar.tar",
  "plain2-2.54-w32.tar.xz",
  "plain2-2_54-w32_tar.xz",
  "plain2-2_54-w32_tar.tar",
  "platex.tar.xz",
  "platex_tar.xz",
  "platex_tar.tar",
  "pmx.tar.xz",
  "pmx_tar.xz",
  "pmx_tar.tar",
  "pstoedit-w32.tar.xz",
  "pstoedit-w32_tar.xz",
  "pstoedit-w32_tar.tar",
  "psutils-w32.tar.xz",
  "psutils-w32_tar.xz",
  "psutils-w32_tar.tar",
  "pstricks.tar.xz",
  "pstricks_tar.xz",
  "pstricks_tar.tar",
  "ptex-w32.tar.xz",
  "ptex-w32_tar.xz",
  "ptex-w32_tar.tar",
  "ptex-ng-w32.tar.xz",
  "ptex-ng-w32_tar.xz",
  "ptex-ng-w32_tar.tar",
  "qpdf-w32.tar.xz",
  "qpdf-w32_tar.xz",
  "qpdf-w32_tar.tar",
  "sam2p-w32.tar.xz",
  "sam2p-w32_tar.xz",
  "sam2p-w32_tar.tar",
  "t1fonts.tar.xz",
  "t1fonts_tar.xz",
  "t1fonts_tar.tar",
  "t1utils-w32.tar.xz",
  "t1utils-w32_tar.xz",
  "t1utils-w32_tar.tar",
  "tex-gyre.tar.xz",
  "tex-gyre_tar.xz",
  "tex-gyre_tar.tar",
  "tex4htk-w32.tar.xz",
  "tex4htk-w32_tar.xz",
  "tex4htk-w32_tar.tar",
  "texinfotools-w32.tar.xz",
  "texinfotools-w32_tar.xz",
  "texinfotools-w32_tar.tar",
  "txtutil.tar.xz",
  "txtutil_tar.xz",
  "txtutil_tar.tar",
  "tiff2png-w32.tar.xz",
  "tiff2png-w32_tar.xz",
  "tiff2png-w32_tar.tar",
  "ttf2pk-w32.tar.xz",
  "ttf2pk-w32_tar.xz",
  "ttf2pk-w32_tar.tar",
  "ttf2pt1-w32.tar.xz",
  "ttf2pt1-w32_tar.xz",
  "ttf2pt1-w32_tar.tar",
  "timesnew.tar.xz",
  "timesnew_tar.xz",
  "timesnew_tar.tar",
  "txpx-pazofonts.tar.xz",
  "txpx-pazofonts_tar.xz",
  "txpx-pazofonts_tar.tar",
  "ums.tar.xz",
  "ums_tar.xz",
  "ums_tar.tar",
  "uptex-w32.tar.xz",
  "uptex-w32_tar.xz",
  "uptex-w32_tar.tar",
  "utf.tar.xz",
  "utf_tar.xz",
  "utf_tar.tar",
  "vf-a2bk.tar.xz",
  "vf-a2bk_tar.xz",
  "vf-a2bk_tar.tar",
  "vf-n2bk.tar.xz",
  "vf-n2bk_tar.xz",
  "vf-n2bk_tar.tar",
  "web2c-lib.tar.xz",
  "web2c-lib_tar.xz",
  "web2c-lib_tar.tar",
  "web2c-w32.tar.xz",
  "web2c-w32_tar.xz",
  "web2c-w32_tar.tar",
  "xetex-w32.tar.xz",
  "xetex-w32_tar.xz",
  "xetex-w32_tar.tar",
  "xindy-w32.tar.xz",
  "xindy-w32_tar.xz",
  "xindy-w32_tar.tar",
  "xymtex.tar.xz",
  "xymtex_tar.xz",
  "xymtex_tar.tar",
  "xypic.tar.xz",
  "xypic_tar.xz",
  "xypic_tar.tar",
  "aleph-w64.tar.xz",
  "aleph-w64_tar.xz",
  "aleph-w64_tar.tar",
  "context-w64.tar.xz",
  "context-w64_tar.xz",
  "context-w64_tar.tar",
  "cweb-w64.tar.xz",
  "cweb-w64_tar.xz",
  "cweb-w64_tar.tar",
  "dvi2ps-w64.tar.xz",
  "dvi2ps-w64_tar.xz",
  "dvi2ps-w64_tar.tar",
  "dvi2tty-w64.tar.xz",
  "dvi2tty-w64_tar.xz",
  "dvi2tty-w64_tar.tar",
  "dvipdfm-w64.tar.xz",
  "dvipdfm-w64_tar.xz",
  "dvipdfm-w64_tar.tar",
  "dvipsk-w64.tar.xz",
  "dvipsk-w64_tar.xz",
  "dvipsk-w64_tar.tar",
  "dvitools-w64.tar.xz",
  "dvitools-w64_tar.xz",
  "dvitools-w64_tar.tar",
  "jtex-w64.tar.xz",
  "jtex-w64_tar.xz",
  "jtex-w64_tar.tar",
  "lcdf-typetools-w64.tar.xz",
  "lcdf-typetools-w64_tar.xz",
  "lcdf-typetools-w64_tar.tar",
  "luatex-dev-w64.tar.xz",
  "luatex-dev-w64_tar.xz",
  "luatex-dev-w64_tar.tar",
  "luatex-w64.tar.xz",
  "luatex-w64_tar.xz",
  "luatex-w64_tar.tar",
  "luajittex-w64.tar.xz",
  "luajittex-w64_tar.xz",
  "luajittex-w64_tar.tar",
  "luajittex-dev-w64.tar.xz",
  "luajittex-dev-w64_tar.xz",
  "luajittex-dev-w64_tar.tar",
  "m-tx-w64.tar.xz",
  "m-tx-w64_tar.xz",
  "m-tx-w64_tar.tar",
  "makeindex-w64.tar.xz",
  "makeindex-w64_tar.xz",
  "makeindex-w64_tar.tar",
  "mftools-w64.tar.xz",
  "mftools-w64_tar.xz",
  "mftools-w64_tar.tar",
  "mftrace-w64.tar.xz",
  "mftrace-w64_tar.xz",
  "mftrace-w64_tar.tar",
  "omegaj-w64.tar.xz",
  "omegaj-w64_tar.xz",
  "omegaj-w64_tar.tar",
  "pdftex-w64.tar.xz",
  "pdftex-w64_tar.xz",
  "pdftex-w64_tar.tar",
  "plain2-2.54-w64.tar.xz",
  "plain2-2_54-w64_tar.xz",
  "plain2-2_54-w64_tar.tar",
  "pmx-w64.tar.xz",
  "pmx-w64_tar.xz",
  "pmx-w64_tar.tar",
  "pstoedit-w64.tar.xz",
  "pstoedit-w64_tar.xz",
  "pstoedit-w64_tar.tar",
  "psutils-w64.tar.xz",
  "psutils-w64_tar.xz",
  "psutils-w64_tar.tar",
  "ptex-w64.tar.xz",
  "ptex-w64_tar.xz",
  "ptex-w64_tar.tar",
  "ptex-ng-w64.tar.xz",
  "ptex-ng-w64_tar.xz",
  "ptex-ng-w64_tar.tar",
  "sam2p-w64.tar.xz",
  "sam2p-w64_tar.xz",
  "sam2p-w64_tar.tar",
  "t1utils-w64.tar.xz",
  "t1utils-w64_tar.xz",
  "t1utils-w64_tar.tar",
  "tex4htk-w64.tar.xz",
  "tex4htk-w64_tar.xz",
  "tex4htk-w64_tar.tar",
  "tiff2png-w64.tar.xz",
  "tiff2png-w64_tar.xz",
  "tiff2png-w64_tar.tar",
  "ttf2pk-w64.tar.xz",
  "ttf2pk-w64_tar.xz",
  "ttf2pk-w64_tar.tar",
  "ttf2pt1-w64.tar.xz",
  "ttf2pt1-w64_tar.xz",
  "ttf2pt1-w64_tar.tar",
  "txtutil-w64.tar.xz",
  "txtutil-w64_tar.xz",
  "txtutil-w64_tar.tar",
  "uptex-w64.tar.xz",
  "uptex-w64_tar.xz",
  "uptex-w64_tar.tar",
  "web2c-w64.tar.xz",
  "web2c-w64_tar.xz",
  "web2c-w64_tar.tar",
  "xetex-w64.tar.xz",
  "xetex-w64_tar.xz",
  "xetex-w64_tar.tar",
  (char *)NULL,
  (char *)NULL,
  (char *)NULL
};

int iskanji(int c)
{
  c &= 0xff;
  return((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc));
}

int main(int ac, char **av)
{
  int i, j, len;
  char dirname[256];
  char cmd[256];
  char *base = "tar ";
  char *option = "12345";
  char name[256];
  char *p;
  int  otf=0;
  int  lua=0;

  strcpy(av[0], "texinst2015");

  if(ac != 2) {
    fprintf(stderr,
     " Simple installer of W32TeX (TeX Live 2015/W32TeX)\n\n"
     " Usage   : texinst2015 dir\n\n"
     " dir is an absolute path of the directory where packages are saved.\n"
     " Example : texinst2015 c:/windows/temp\n"
     " The current directory should be the installation\n"
     " directory of W32TeX, e.g., c:/w32tex.\n"
     " It is assumed that tar.exe, gzip.exe, bzip2.exe and xz.exe\n"
     " can be found in the command PATH.\n");
    exit (100);
  }

  len = strlen(av[1]);
  if(len > 255) {
    fprintf(stderr, "Too long a name of the path.\n");
    exit(100);
  }

  strcpy(dirname, av[1]);

  for(p = dirname; *p; p++) {
    if(iskanji(*p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }

  p--;
  while(*p == '/' && p >= dirname) {
    *p = '\0';
    p--;
  }

  len = strlen(dirname);
  if(len < 2) {
    fprintf(stderr, "Wrong name of the path.\n");
    exit(100);
  }

  for(i = 0, j=0; fname[3*i] != NULL; i++) {

    len = strlen(fname[3*i]);
    if((len >= 4) && (stricmp(fname[3*i] + len - 4, ".bz2") == 0))
      strcpy(option, "jxvf ");
    else if((len >= 3) && (stricmp(fname[3*i] + len - 3, ".gz") == 0))
      strcpy(option, "zxvf ");
    else if((len >= 3) && (stricmp(fname[3*i] + len - 3, ".xz") == 0))
      strcpy(option, "Jxvf ");
    else {
      fprintf(stderr, "I don't know the extension.\n");
      continue;
    }
    strcpy(name, dirname);
    strcat(name, "/");
    strcat(name, fname[3*i]);
    if(!access(name, R_OK)) {
      if(strnicmp(fname[3*i], "otf", 3) == 0) {
	otf++;
	if(otf > 1)
	  continue;
      }
/*
      if(strnicmp(fname[3*i], "luatex-", 7) == 0) {
	lua++;
	if(lua > 1)
	  continue;
      }
*/
      strcpy(cmd, base);
      strcat(cmd, option);
      strcat(cmd, name);
      fprintf(stderr,"\nInstalling %s.\n\n", fname[3*i]);
      system(cmd);
      j++;
    } else {
      strcpy(name, dirname);
      strcat(name, "/");
      strcat(name, fname[3*i + 1]);
      if(!access(name, R_OK)) {
	if(strnicmp(fname[3*i + 1], "otf", 3) == 0) {
	  otf++;
	  if(otf > 1)
	    continue;
	}
/*
	if(strnicmp(fname[3*i + 1], "lua", 3) == 0) {
	  lua++;
	  if(lua > 1)
	    continue;
	}
*/
	strcpy(cmd, base);
	strcat(cmd, option);
	strcat(cmd, name);
	fprintf(stderr,"\nInstalling %s.\n\n", fname[3*i]);
	system(cmd);
	j++;
      } else {
	strcpy(name, dirname);
	strcat(name, "/");
	strcat(name, fname[3*i + 2]);
	if(!access(name, R_OK)) {
	  if(strnicmp(fname[3*i + 2], "otf", 3) == 0) {
	    otf++;
	    if(otf > 1)
	      continue;
	  }
/*
	  if(strnicmp(fname[3*i + 2], "lua", 3) == 0) {
	    lua++;
	    if(lua > 1)
	      continue;
	  }
*/
	  strcpy(cmd, base);
	  strcat(cmd, option);
	  strcat(cmd, name);
	  fprintf(stderr,"\nInstalling %s.\n\n", fname[3*i]);
	  system(cmd);
	  j++;
	}
      }
    }
  }

  (void)_getcwd(name,128);
  strcpy(cmd, name);
  for(p = name; *p ; p++) {
    if(iskanji(*p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }

  if(j) {
    fprintf(stderr,
	    "Add\n%s\\bin\n"
            "or\n"
            "%s\\bin64;%s\\bin\nin the case of 64bit OS\n"
	    "to user's PATH in the control panel.\n", cmd, cmd, cmd);
  }
  else {
    fprintf(stderr,"No package has been installed.\n");
  }
  return 0;
}
