/* symlink/io.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef _SYMLINK_IO_H
#define _SYMLINK_IO_H


#include <symlink/cdefs.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <io.h>


__BEGIN_DECLS

int symlink_open __PROTO ((const char *name, int flags, ...));
int symlink_creat __PROTO ((const char *name, int mode));
int symlink_sopen __PROTO ((const char *name, int flags, int share, ...));
int symlink_access __PROTO ((const char *name, int mode));
int symlink_chmod __PROTO ((const char *name, int mode));

__END_DECLS


#ifdef USE_SYMLINK_IO

#undef open
#undef creat
#undef sopen
#undef access
#undef chmod

#define open	symlink_open
#define creat	symlink_creat
#define sopen	symlink_sopen
#define access	symlink_access
#define chmod	symlink_chmod

#endif /* USE_SYMLINK_IO */


#endif /* not _SYMLINK_IO_H */
