/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import nts.base.Dimen;
import nts.base.Glue;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.AnyBoxedNode;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.NodeList;
import nts.node.SizesEvaluator;

public class AnyUnsetNode
extends AnyBoxedNode {
    protected final NodeList list;
    protected final int spanCount;
    protected final Dimen stretch;
    protected final byte strOrder;
    protected final Dimen shrink;
    protected final byte shrOrder;

    public NodeList getList() {
        return this.list;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc()).add(this.sizes);
        StringBuffer buf = new StringBuffer(80);
        if (this.spanCount != 0) {
            buf.append(" (").append(this.spanCount + 1).append(" columns)");
        }
        if (!this.stretch.isZero()) {
            Glue.append(buf.append(", stretch "), this.stretch, this.strOrder, null);
        }
        if (!this.shrink.isZero()) {
            Glue.append(buf.append(", shrink "), this.shrink, this.shrOrder, null);
        }
        log.add(buf.toString());
        cntx.addOn(log, this.list.nodes());
    }

    public String getDesc() {
        return "unsetbox";
    }

    public GlueSetting getSetting(Dimen excess) {
        SizesEvaluator pack = new SizesEvaluator();
        pack.addStretch(this.stretch, this.strOrder);
        pack.addShrink(this.shrink, this.shrOrder);
        pack.evaluate(excess, false);
        return pack.getSetting();
    }

    public AnyUnsetNode(BoxSizes sizes, NodeList list, int spanCount, Dimen stretch, byte strOrder, Dimen shrink, byte shrOrder) {
        super(sizes);
        this.list = list;
        this.spanCount = spanCount;
        this.stretch = stretch;
        this.strOrder = strOrder;
        this.shrink = shrink;
        this.shrOrder = shrOrder;
    }

    public AnyUnsetNode(BoxSizes sizes, NodeList list) {
        this(sizes, list, 0, Dimen.ZERO, 0, Dimen.ZERO, 0);
    }

    public AnyUnsetNode() {
        this(BoxSizes.ZERO, NodeList.EMPTY);
    }
}

