# TeX run with the file $main_file$tsuff and with the format $texmem$texfmt
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc tex {f austext} {# TeX run: file $main_file$tsuff, format $texfmt   

  upvar 1 $austext a

  global  texfmt main_file tsuff prsuffix texmem texrun texmax texopts
  global  editor edsubback env vv xtermcall xtem_path tclcall texonemorerun texedit

  set noedittext "\n$vv(ten1)\n$vv(ten2)\n"
  eval set noeditortext \"\n$vv(ten3)\n$vv(ten4) $vv(ten2)\n\$vv(tsrt2)\n\"


  if {($texonemorerun==0)&&($texrun==1)} {writescr0 $f ""}
  writescr $f  "[datime] $vv(te1) $texfmt $main_file$tsuff\n"
  if {($texrun>1)&&($texonemorerun==0)} {# 2th, 3rd, ... run (if max. number of TeX runs >1)
    writescr $f	"\n$texrun. $vv(te2)  $texmax  $vv(te3)\n\n"
    mybell 1
  }
  set a ""


  FileDelete .tmp.noedit

  if { $edsubback == 0 } {

    # you can either set variable texedit in file "locals_*/install.vst"
    # (e.g.  texedit nedit +%d %s
    #  or    texedit $tclcall -c \"exec $xtermcall -e ue +%d %s\"
    #  note that you have to protect semicolon and double-quotes)
    # or you can add a new "elseif" to the following list
    #
    if {$texedit!=""}			{eval set ev \"$texedit\"
    } elseif {$editor=="emacs"}		{set ev "emacs +%d %s"
    } elseif {$editor=="xemacs"}	{set ev "xemacs +%d %s"
    } elseif {$editor=="nedit"}		{set ev "nedit +%d %s"
    } elseif {$editor=="textedit"}	{set ev "textedit %s"
    } elseif {$editor=="ue"}	{set ev "$tclcall -c \"exec $xtermcall -e ue +%d %s\""
    } elseif {$editor=="vi"}	{set ev "$tclcall -c \"exec $xtermcall -e vi +%d %s\""
    } else			{set ev "echo \"$noeditortext\";touch .tmp.noedit"}
    set env(TEXEDIT) "$ev"

  } else {# editor in background: e-option forbidden, except with emacsserver/emacsclient 
    set env(TEXEDIT) "echo \"$noedittext\";touch .tmp.noedit"
  }


#   tex/latex/... call

    ## either:
    ################################################################
    mkCmd_wait  $f  $texmem$texfmt  [list "[string trim "$texopts $main_file$tsuff"]"]
    ################################################################
    ## or:
    ################################################################
    #set message ""
    #FileDelete ${main_file}.log
    #regsub -all {\\} $texopts {\\\\} s
    #eval set r [catch "exec xterm -e $texmem$texfmt $s $main_file$tsuff " m]
    #set pid "$m"
    #if [file exists ${main_file}.log] {catFile ${main_file}.log $f}
    #if [file exists .tmp.noedit] {set a "${a}$noedittext"} 
    ################################################################

}


proc tex_post {f austext} {# after TeX run: .dvi -> .ps if postscript-preview

  upvar 1 $austext a

  global vv Wq env anl0 main_file mainfile tsuff hyphenprog hyphenopts hyphenchk hyphenchke
  global texpostbib texposthyph texpostind texpostps texposttex texonemorerun texloganalyze
  global tlFileCheck language tlaOutLstAct chksum_idx prsuffix prpreopt dirprefix

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]}
  eval set hyphenchke \"$hyphenchk\"

  set a ""; set message ""; set dummy ""; set texonemorerun 0

  set dviNewGenerated [mdtest $main_file $tsuff .dvi dummy] 

  if {($texpostind==1)&&[winfo exists .c.2.in]} {

   set indexrunreq 0
   if {[file exists $main_file.idx]&&![file exists $main_file.ind]} {set indexrunreq 1}
   if {[file exists $main_file.idx]&&($chksum_idx!=[checksum .idx])} {set indexrunreq 1}

   if {$indexrunreq==1} {
     writescr $f "\n\n[datime] $vv(xtc2in) $vv(tea3)\n\n"
     index $f austxt; writescr $f "$austxt"
     set texonemorerun 1
   }
   mybell 1
  }

  if {$texpostbib==1} {

   set t "LaTeX Warning: There were undefined references"
   set mf "$main_file.log"
   set r [catch "exec grep \"$t\" $mf" m]

   TestPut 4 "<$t>  <$r> <$m> "
   if {$r==0} {set bibrun 1} else {set bibrun 0}

   if {$bibrun} {
     writescr $f "\n\n[datime] $vv(bib1) $main_file$tsuff $vv(tea3)\n"
     bibliogr $f austxt; writescr $f "$austxt"
     set texonemorerun 1
   }
   mybell 1
  }

  if {($texposttex==1)&&($texonemorerun==1)} {
    writescr .d.tt "\n\n"
    tex .d.tt austxt; if {$austxt!=""} {writescr .d.tt "\n$austxt"}
  }

  if {($texpostps==1)&&("$prsuffix"==".ps")&& \
      [file exists $main_file.dvi]&&($dviNewGenerated==1)} {
    # Postscript preview and .dvi-file newer than .tex-file, thus .dvi --> .ps
    writescr  $f "\n\n[datime] dvips $vv(tea3) $vv(tea4)\n"

    ## either:
    #catch "exec dvips $main_file.dvi $prpreopt -o $main_file.ps" message
    ## or:
    mkCmd_wait $f dvips "$main_file.dvi $prpreopt -o $main_file.ps"

  }


  if {(($texloganalyze=="1")||($texloganalyze=="yes"))&&[file exists $main_file.log]} {
    writescr .d.tt "\n$vv(xt36) ...\n"; update
    set tlFileCheck 1;  tlDriver .d.tt austxt;  writescr .d.tt "\n$austxt"
  }


  if {($texposthyph==1)&&[file exists $mainfile.dvi]&&([catch "which $hyphenprog" m]==0)} {

    FileDelete $mainfile.hyp
    if {($hyphenchke!="")&&![file exists $hyphenchke]} {exec touch $hyphenchke}
    writescr $f "\n[datime] $vv(teh0)"
    hyphGetStartPos

    ## either:
    ################################################################
    eval mkCmd_wait $f $hyphenprog \[list $hyphenopts $mainfile $hyphenchke\]
    #eval mkCmd_wait $f $hyphenprog [list "$hyphenopts $mainfile $hyphenchke"]
    ################################################################
    ## or:
    ################################################################
    #set r [catch "exec $hyphenprog $hyphenopts $mainfile $hyphenchke" m]
    #writescr $f "\n$m\n"
    ################################################################

    hyphGetEndPos
    hyphInitDisplay $f $mainfile [fontencTeX] [fontencOpt]

  } elseif {($texposthyph==1)&&[file exists $mainfile.dvi]} {# program hyphen_show not found
    writescr $f "\n$vv(aprog) \"$hyphenprog\" $vv(teh3) $vv(anf)\n"; mybell 3
  }

  writescr  $f "$message\n[datime] $vv(tea5)\n"
  mybell 1

}
