/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.io.File;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.ProgramRunner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuilderConfigDialog
extends Dialog {
    protected File lastPath;
    private Text fileField;
    private Text argsField;
    private Label statusField;
    private ProgramRunner builder;

    public BuilderConfigDialog(Shell parentShell, ProgramRunner runner) {
        super(parentShell);
        this.builder = runner;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TexlipsePlugin.getResourceString("preferenceBuilderDialogTitle"));
    }

    protected void okPressed() {
        String path = this.fileField.getText();
        if (!this.checkFile(path)) {
            return;
        }
        this.builder.setProgramPath(path);
        this.builder.setProgramArguments(this.argsField.getText());
        this.setReturnCode(0);
        this.close();
    }

    protected boolean checkFile(String path) {
        File exec;
        if (path != null && path.length() > 0 && (!(exec = new File(path)).isFile() || !exec.exists() && exec.isFile())) {
            this.setStatus("preferenceBuilderDialogFileNotFound", "");
            return false;
        }
        this.setStatus("preferenceBuilderDialogFileOk", "");
        return true;
    }

    protected void setStatus(String key, String info) {
        String msg = "";
        if (key != null && key.length() > 0 && (msg = TexlipsePlugin.getResourceString(key)).indexOf("%s") >= 0) {
            msg = msg.replaceAll("%s", info);
        }
        this.statusField.setText(msg);
    }

    private String resolveStatus() {
        String path = this.builder.getProgramPath();
        if (path == null || path.length() == 0) {
            return TexlipsePlugin.getResourceString("preferenceBuilderDialogFileEmpty");
        }
        File exec = new File(path);
        if (!exec.exists() && exec.isFile()) {
            return TexlipsePlugin.getResourceString("preferenceBuilderDialogFileNotFound");
        }
        return TexlipsePlugin.getResourceString("preferenceBuilderDialogFileOk");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = (GridLayout)composite.getLayout();
        gl.numColumns = 2;
        Label descrLabel = new Label(composite, 16384);
        descrLabel.setText(TexlipsePlugin.getResourceString("preferenceBuilderDialogDescriptionLabel").replaceAll("%s", this.builder.getDescription()));
        GridData dgd = new GridData(768);
        dgd.horizontalSpan = 2;
        descrLabel.setLayoutData((Object)dgd);
        this.addFileBrowser(composite);
        this.addArgumentsField(composite);
        if (this.builder.getInputFormat() != null && this.builder.getInputFormat().length() > 0 && this.builder.getOutputFormat() != null && this.builder.getOutputFormat().length() > 0) {
            this.addFormatsField(composite);
        }
        Group group = new Group(composite, 4);
        group.setLayoutData((Object)new GridData(768));
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout());
        this.statusField = new Label((Composite)group, 16384);
        this.statusField.setText(this.resolveStatus());
        this.statusField.setLayoutData((Object)new GridData(768));
        this.statusField.setToolTipText(TexlipsePlugin.getResourceString("preferenceBuilderDialogStatusTooltip"));
        return composite;
    }

    private void addFileBrowser(Composite composite) {
        Label fileLabel = new Label(composite, 16384);
        fileLabel.setText(TexlipsePlugin.getResourceString("preferenceBuilderCommandLabel"));
        fileLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceBuilderCommandTooltip"));
        fileLabel.setLayoutData((Object)new GridData());
        Composite browser = new Composite(composite, 0);
        browser.setLayoutData((Object)new GridData(768));
        GridLayout bgl = new GridLayout();
        bgl.numColumns = 2;
        browser.setLayout((Layout)bgl);
        this.fileField = new Text(browser, 2052);
        this.fileField.setText(this.builder.getProgramPath());
        this.fileField.setToolTipText(TexlipsePlugin.getResourceString("preferenceBuilderCommandTooltip"));
        this.fileField.setLayoutData((Object)new GridData(768));
        this.fileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuilderConfigDialog.this.checkFile(BuilderConfigDialog.this.fileField.getText());
            }
        });
        Button browseButton = new Button(browser, 8);
        browseButton.setText(JFaceResources.getString((String)"openBrowse"));
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String dir;
                FileDialog dialog = new FileDialog(BuilderConfigDialog.this.getShell());
                if (BuilderConfigDialog.this.lastPath != null) {
                    if (BuilderConfigDialog.this.lastPath.exists()) {
                        dialog.setFilterPath(BuilderConfigDialog.this.lastPath.getAbsolutePath());
                    }
                } else {
                    BuilderConfigDialog.this.lastPath = new File(BuilderConfigDialog.this.fileField.getText());
                    while (BuilderConfigDialog.this.lastPath != null && !BuilderConfigDialog.this.lastPath.isDirectory()) {
                        BuilderConfigDialog.this.lastPath = BuilderConfigDialog.this.lastPath.getParentFile();
                    }
                    if (BuilderConfigDialog.this.lastPath != null && BuilderConfigDialog.this.lastPath.exists()) {
                        dialog.setFilterPath(BuilderConfigDialog.this.lastPath.getAbsolutePath());
                    }
                }
                if ((dir = dialog.open()) != null) {
                    BuilderConfigDialog.this.lastPath = new File(dir.trim());
                    if (BuilderConfigDialog.this.lastPath.exists()) {
                        BuilderConfigDialog.this.fileField.setText(BuilderConfigDialog.this.lastPath.getAbsolutePath());
                    } else {
                        BuilderConfigDialog.this.lastPath = null;
                    }
                    BuilderConfigDialog.this.checkFile(BuilderConfigDialog.this.fileField.getText());
                }
            }
        });
    }

    private void addArgumentsField(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceBuilderArgsLabel"));
        label.setToolTipText(TexlipsePlugin.getResourceString("preferenceBuilderArgsTooltip"));
        label.setLayoutData((Object)new GridData());
        this.argsField = new Text(parent, 2052);
        this.argsField.setText(this.builder.getProgramArguments());
        this.argsField.setToolTipText(TexlipsePlugin.getResourceString("preferenceBuilderArgsTooltip"));
        this.argsField.setLayoutData((Object)new GridData(768));
    }

    private void addFormatsField(Composite parent) {
        Composite leftPart = new Composite(parent, 0);
        leftPart.setLayoutData((Object)new GridData());
        GridLayout llay = new GridLayout();
        llay.numColumns = 2;
        leftPart.setLayout((Layout)llay);
        Label label = new Label(leftPart, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceBuilderInputFormatLabel"));
        label.setLayoutData((Object)new GridData());
        Group inputGroup = new Group(leftPart, 4);
        inputGroup.setLayoutData((Object)new GridData());
        inputGroup.setLayout((Layout)new GridLayout());
        Label inputLabel = new Label((Composite)inputGroup, 16384);
        inputLabel.setText("." + this.builder.getInputFormat());
        inputLabel.setLayoutData((Object)new GridData());
        Composite rightPart = new Composite(parent, 0);
        rightPart.setLayoutData((Object)new GridData(768));
        GridLayout rlay = new GridLayout();
        rlay.numColumns = 2;
        rightPart.setLayout((Layout)rlay);
        Label label2 = new Label(rightPart, 16384);
        label2.setText(TexlipsePlugin.getResourceString("preferenceBuilderOutputFormatLabel"));
        label2.setLayoutData((Object)new GridData());
        Group outputGroup = new Group(rightPart, 4);
        outputGroup.setLayoutData((Object)new GridData());
        outputGroup.setLayout((Layout)new GridLayout());
        Label outputLabel = new Label((Composite)outputGroup, 16384);
        outputLabel.setText("." + this.builder.getOutputFormat());
        outputLabel.setLayoutData((Object)new GridData());
    }
}

